
# The mojo module.

The mojo module provides a simple cross platform application framework for writing games and other graphical apps.


## Initialization and the event loop

To initialize mojo, you need to do at least 3 things:

* Create an [[app.AppInstance]] using 'New AppInstance'. This will automatically initialize the [[app.App]] global variable.
* Create an [[app.Window]]. You will generally create a subclass of window you have defined yourself, eg: 'New MyWindow'.
* Start the app using App.Run().

This can all be done inside Main().

Once the app is running, mojo runs a simple event loop that looks like this:

* Get OS events and dispatch corresponding mojo events if necessary.
* Once there are no OS events left to process, any custom [[app.AppInstance.Idle]] handlers are called.
* If the application has called [[app.AppInstance.RequestRender]], the app is then rendered.

The app will continue executing the event loop until [[app.AppInstance.Terminate]] is called.

## Subclassing Window

Subclassing the app Window class is easy - just extend the [[app.Window]] class.

To render to the window, you will also need to override the [[app.Window.OnRender]] method. 

The OnRender method is called when the app needs to be rendered, and is passed a [[graphics.Canvas]] instance for window rendering code to use.

In addition, you may also want to override the [[app.Window.OnWindowEvent]] method to handle window close, resize etc events.

## Handling user input

There are 2 main ways to handle user input, via the [[app.View.OnKeyEvent]] and [[app.View.OnMouseEvent]] event handlers or using the
[[input.Keyboard]] and [[input.Mouse]] devices.

Key and mouse events are sent to your app as soon they are processed by the event loop, while the keyboard and mouse devices may be 'polled' at
any time.


## A minimal app

Ok, time to put it all together!

@example

#Import "<std>"
#Import "<mojo>"

Using std..
Using mojo..

Class MyWindow Extends Windows

	Method OnRender( canvas:Canvas ) Override

		canvas.DrawText( "Hello World",Width/2,Height/2,.5,.5 )
	End
	
End

Function Main()

	New AppInstance
	
	New MyWindow
	
	App.Run()
End

@end
