
#ifndef BB_STD_SOCKET_H
#define BB_STD_SOCKET_H

#include <bbmonkey.h>

namespace bbSocket{

	int connect( const char *hostname,const char *service,int type );
	
	int bind( const char *hostname,const char *service );

	int listen( const char *hostname,const char *service,int queue );

	int accept( int socket );
	
	void close( int socket );
	
	int send( int socket,void *data,int size );

	int recv( int socket,void *data,int size );
	
	int sendto( int socket,void *data,int size,const void *sockaddr,int addrlen );
	
	int recvfrom( int socket,void *data,int size,void *sockaddr,int *addrlen );
	
	void setopt( int socket,bbString name,int value );
	
	int getopt( int socket,bbString name );
	
	int cansend( int socket );
	
	int canrecv( int socket );
	
	int getsockaddr( int socket,void *sockaddr,int *addrlen );

	int getpeeraddr( int socket,void *sockaddr,int *addrlen );

	int sockaddrname( const void *sockaddr,int addrlen,char *host,char *service );
}

#endif
