Namespace linq

Alias Accumulator<T>:T(accumulation:T, item:T)

Alias Comparer<T>:Bool(item1:T, item2:T)

Alias ListSelector<T,TResult>:List<TResult>(item:T)
Alias ListSelectorWithIndex<T,TResult>:List<TResult>(item:T, index:Int)

Alias NumericTransform<T>:T(item:T)

Alias Predicate<T>:Bool(item:T)
Alias PredicateWithIndex<T>:Bool(item:T, index:Int)

Alias Selector<T,TResult>:TResult(item:T)
Alias SelectorWithIndex<T,TResult>:TResult(item:T, index:Int)

Alias Sorter<T>:Int(item1:T, item2:T)

Alias StackSelector<T,TResult>:Stack<TResult>(item:T)
Alias StackSelectorWithIndex<T,TResult>:Stack<TResult>(item:T, index:Int)

Alias Transform<T1,T2,TResult>:TResult(item1:T1, item2:T2)

' Sorter implementation that sorts ascending
Function SortAscending<T>:Int(item1:T, item2:T)
	If item1 < item2 Then Return -1
	If item1 > item2 Then Return 1
	Return 0
End

' Sorter implementation that sorts descending
Function SortDescending<T>:Int(item1:T, item2:T)
	If item1 > item2 Then Return -1
	If item1 < item2 Then Return 1
	Return 0
End
