Namespace linq

Class List<T> Extension

Private

	Method Linq:LinqHelper<List<T>,T>()
		Return LinqHelper<List<T>,T>.CreateForList<T>()
	End

Public
	
	Method Aggregate:T(accumulator:Accumulator<T>)
		Return Linq().Aggregate(Self, Null, accumulator)
	End

	Method Aggregate:T(seed:T, accumulator:Accumulator<T>)
		Return Linq().Aggregate(Self, seed, accumulator)
	End

	Method All2:Bool(predicate:Predicate<T>)
		Return Linq().All(Self, predicate)
	End

	#rem monkeydoc
	Determines whether a sequence contains any elements.
	#end
	Method Any:Bool()
		Return Linq().Any(Self)
	End
	
	#rem monkeydoc
	Determines whether any element of a sequence satisfies a condition.
	@param predicate A function to test each element for a condition.
	#end
	Method Any:Bool(predicate:Predicate<T>)
		Return Linq().Any(Self, predicate)
	End

	Method Average:T() Where T Extends INumeric
		Return Linq().Average(Self, Null)
	End

	Method Average:T(transform:NumericTransform<T>) Where T Extends INumeric
		Return Linq().Average(Self, transform)
	End

	Method Concat:List<T>(list:List<T>)
		Return Linq().Concat(Self, list)
	End

	Method Contains:Bool(match:T)
		Return Linq().Contains(Self, match)
	End
	
	Method Contains:Bool(match:T, comparer:Comparer<T>)
		Return Linq().Contains(Self, match, comparer)
	End

	' Count() already exists

	Method Count2:UInt(predicate:Predicate<T>)
		Return Linq().Count(Self, predicate)
	End
	
	Method DefaultIfEmpty:List<T>(defaultValue:T)
		Return Linq().DefaultIfEmpty(Self, defaultValue)
	End

	Method Distinct:List<T>()
		Return Linq().Distinct(Self, Null)
	End

	Method Distinct:List<T>(comparer:Comparer<T>)
		Return Linq().Distinct(Self, comparer)
	End

	Method ElementAt:T(index:UInt)
		Return Linq().ElementAtOrDefault(Self, index, Null)
	End

	Method ElementAtOrDefault:T(index:UInt, defaultValue:T)
		Return Linq().ElementAtOrDefault(Self, index, defaultValue)
	End
	
	Method Except:List<T>(list:List<T>)
		Return Linq().Except(Self, list, Null)
	End

	Method Except:List<T>(list:List<T>, comparer:Comparer<T>)
		Return Linq().Except(Self, list, comparer)
	End
	
	' First already exists

	Method First2:T(predicate:Predicate<T>)
		Return Linq().FirstOrDefault(Self, Null, predicate)
	End

	Method FirstOrDefault:T(defaultValue:T)
		
		Local first:T = Null
		If Not Empty Then first = First
	
		Return Linq().FirstOrDefault(Self, first, defaultValue)
		
	End

	Method FirstOrDefault:T(defaultValue:T, predicate:Predicate<T>)
		Return Linq().FirstOrDefault(Self, defaultValue, predicate)
	End
	
	Method Intersect:List<T>(list:List<T>)
		Return Linq().Intersect(Self, list, Null)
	End

	Method Intersect:List<T>(list:List<T>, comparer:Comparer<T>)
		Return Linq().Intersect(Self, list, comparer)
	End

	Method Join2<T,TInner,TKey,TResult>:List<TResult>(inner:List<TInner>, outerKeySelector:Selector<T,TKey>, innerKeySelector:Selector<TInner,TKey>, resultSelector:TResult(outer:T, inner:TInner))
		Return Linq().Join<T,List<TInner>,TInner,TKey,List<TResult>,TResult>(Self, inner, outerKeySelector, innerKeySelector, resultSelector)
	End
	
	Method Join2<T,TInner,TKey,TResult>:List<TResult>(inner:List<TInner>, outerKeySelector:Selector<T,TKey>, innerKeySelector:Selector<TInner,TKey>, resultSelector:TResult(outer:T, inner:TInner), keyComparer:Comparer<TKey>)
		Return Linq().Join<T,List<TInner>,TInner,TKey,List<TResult>,TResult>(Self, inner, outerKeySelector, innerKeySelector, resultSelector, keyComparer)
	End
	
	' Last already exists

	Method Last2:T(predicate:Predicate<T>)
		Return Linq().LastOrDefault(Self, Null, predicate)
	End

	Method LastOrDefault:T(defaultValue:T)
		
		Local last:T = Null
		If Not Empty Then last = Last

		Return Linq().LastOrDefault(Self, last, defaultValue)

	End

	Method LastOrDefault:T(defaultValue:T, predicate:Predicate<T>)
		Return Linq().LastOrDefault(Self, defaultValue, predicate)
	End
	
	Method Max:T() Where T Extends INumeric
		Return Linq().Max(Self, Null)
	End

	Method Max:T(transform:NumericTransform<T>) Where T Extends INumeric
		Return Linq().Max(Self, transform)
	End	
	
	Method Min:T() Where T Extends INumeric
		Return Linq().Min(Self, Null)
	End

	Method Min:T(transform:NumericTransform<T>) Where T Extends INumeric
		Return Linq().Min(Self, transform)
	End	
	
	Method OrderBy:List<T>(sorter:Sorter<T>)
		Return Linq().OrderBy(Self, sorter)
	End	
	
	Method OrderByDescending:List<T>(sorter:Sorter<T>)
		Return Linq().OrderByDescending(Self, sorter)
	End	
	
	' Where() equivalent
	Method Query:List<T>(predicate:Predicate<T>)
		Return Linq().Query(Self, predicate)
	End

	' Where() equivalent
	Method Query:List<T>(predicate:PredicateWithIndex<T>)
		Return Linq().Query(Self, predicate)
	End

	Function Range:List<T>(start:T, count:UInt) Where T Extends INumeric
		Return LinqHelper<List<T>,T>.Range(start, 1, count)
	End

	Function Range:List<T>(start:T, rate:T, count:UInt) Where T Extends INumeric
		Return LinqHelper<List<T>,T>.Range(start, rate, count)
	End
	
	Function Repeat2:List<T>(item:T, count:UInt)
		Return LinqHelper<List<T>,T>.Repeated(item, count)
	End
	
	Method Reverse:List<T>()
		Return Linq().Reverse(Self)
	End
	
	Method Select2<T,TResult>:List<TResult>(selector:Selector<T,TResult>)
		Return Linq().Select2<T,List<TResult>,TResult>(Self, selector)
	End
	
	Method Select2<T,TResult>:List<TResult>(selector:SelectorWithIndex<T,TResult>)
		Return Linq().Select2<T,List<TResult>,TResult>(Self, selector)
	End

	Method SelectMany<T,TResult>:List<TResult>(selector:ListSelector<T,TResult>)
		Return Linq().SelectMany<T,List<TResult>>(Self, Lambda:List<TResult>(item:T)
			Return selector(item)
		End)
	End	

	Method SelectMany<T,TResult>:List<TResult>(selector:ListSelectorWithIndex<T,TResult>)
		Return Linq().SelectMany<T,List<TResult>>(Self, Lambda:List<TResult>(item:T, index:Int)
			Return selector(item, index)
		End)
	End	

	Method SelectMany<T,TIntermediate,TResult>:List<TResult>(listSelector:ListSelector<T,TIntermediate>, resultSelector:Transform<T,TIntermediate,TResult>)
		Return Linq().SelectMany<T,List<TIntermediate>,TIntermediate,List<TResult>,TResult>(Self, Lambda:List<TIntermediate>(item:T)
			Return listSelector(item)
		End, resultSelector)
	End	

	Method SelectMany<T,TIntermediate,TResult>:List<TResult>(listSelector:ListSelectorWithIndex<T,TIntermediate>, resultSelector:Transform<T,TIntermediate,TResult>)
		Return Linq().SelectMany<T,List<TIntermediate>,TIntermediate,List<TResult>,TResult>(Self, Lambda:List<TIntermediate>(item:T, index:Int)
			Return listSelector(item, index)
		End, resultSelector)
	End	

	Method SequenceEqual:Bool(list:List<T>)
		Return SequenceEqual(list, Null)
	End

	Method SequenceEqual:Bool(list:List<T>, comparer:Comparer<T>)
		
		If Count() <> list.Count() Then Return False
		If Empty and list.Empty Then Return True

		Local node := list.FirstNode()
		
		For Local item := EachIn All()
		
			If comparer <> Null
				If Not comparer(item, node.Value) Then Return false
			Else
				If item <> node.Value Then Return False
			End
		
			node = node.Succ
			
		End
		
		Return True
		
	End

	Method Single:T()
		
		Local first:T = Null
		If Not Empty Then first = First
		
		Return Linq().Single("List", Self, Count(), first)
		
	End

	Method Single:T(predicate:Predicate<T>)
		Return Linq().Single(Self, predicate, 
			' Get first match
			Lambda:T(list:List<T>)
				Local first:T = Null
				If Not Empty Then first = list.First
				Return first
			End)
	End

	Method SingleOrDefault:T(defaultValue:T)
		
		Local first:T = Null
		If Not Empty Then first = First
		
		Return Linq().SingleOrDefault("List", Self, defaultValue, Count(), first)
		
	End

	Method SingleOrDefault:T(defaultValue:T, predicate:Predicate<T>)
		Return Linq().SingleOrDefault(Self, defaultValue, predicate, 
			' Get first match
			Lambda:T(list:List<T>)
				Local first:T = Null
				If Not Empty Then first = list.First
				Return first
			End)
	End
	
	Method Skip:List<T>(count:Int)
		Return Linq().Skip(Self, count)
	End

	Method SkipWhile:List<T>(predicate:Predicate<T>)
		Return Linq().SkipWhile(Self, predicate)
	End

	Method SkipWhile:List<T>(predicate:PredicateWithIndex<T>)
		Return Linq().SkipWhile(Self, predicate)
	End

	Method Sum:T() Where T Extends INumeric
		Return Linq().Sum(Self, Null)
	End

	Method Sum:T(transform:NumericTransform<T>) Where T Extends INumeric
		Return Linq().Sum(Self, transform)
	End	

	Method Take:List<T>(count:Int)
		Return Linq().Take(Self, count)
	End

	Method TakeWhile:List<T>(predicate:Predicate<T>)
		Return Linq().TakeWhile(Self, predicate)
	End

	Method TakeWhile:List<T>(predicate:PredicateWithIndex<T>)
		Return Linq().TakeWhile(Self, predicate)
	End

	' ThenBy() not implemented
	
	' ToArray() already exists
	
	' ToDictionary() with comparer not implemented
	
	' ToDictionary() equivalent
	Method ToMap<T,TKey>:Map<TKey,T>(keySelector:Selector<T,TKey>)
		Return Linq().ToMap(Self, keySelector)
	End

	' ToDictionary() equivalent
	Method ToMap<T,TKey,TElement>:Map<TKey,TElement>(keySelector:Selector<T,TKey>, elementSelector:Selector<T,TElement>)
		Return Linq().ToMap(Self, keySelector, elementSelector)
	End

	Method ToStack<T>:Stack<T>()
		Return New Stack<T>(Self)
	End

	' ToList() not required
	' ToLookup() not required

	Method Union:List<T>(list:List<T>)
		Return Linq().Union(Self, list, Null)
	End
	
	Method Union:List<T>(list:List<T>, comparer:Comparer<T>)
		Return Linq().Union(Self, list, comparer)
	End

	Method Zip<T,TSecond,TResult>:List<TResult>(list:List<TSecond>, transform:Transform<T,TSecond,TResult>)

		Local newList := New List<TResult>()
		If Empty Or list.Empty Then Return newList

		Local count:Int = monkey.math.Min(Count(), list.Count())
		Local index:Int = 0
	
		Local node := list.FirstNode()

		For Local item1 := EachIn All()

			Local item2 := node.Value

			newList.Add(transform(item1, item2))			
			
			index += 1
			If index = count Then Return newList
			
			node = node.Succ
			
		End

		Return newList ' should never get here but required to compile

	End

End
