Namespace linq

Class Stack<T> Extension

Private

	Method Linq:LinqHelper<Stack<T>,T>()
		Return LinqHelper<Stack<T>,T>.CreateForStack<T>()
	End

Public

	Method Aggregate:T(accumulator:Accumulator<T>)
		Return Linq().Aggregate(Self, Null, accumulator)
	End

	Method Aggregate:T(seed:T, accumulator:Accumulator<T>)
		Return Linq().Aggregate(Self, seed, accumulator)
	End

	Method All2:Bool(predicate:Predicate<T>)
		Return Linq().All(Self, predicate)
	End

	Method Any:Bool()
		Return Linq().Any(Self)
	End
	
	Method Any:Bool(predicate:Predicate<T>)
		Return Linq().Any(Self, predicate)
	End

	Method Average:T() Where T Extends INumeric
		Return Linq().Average(Self, Null)
	End

	Method Average:T(transform:NumericTransform<T>) Where T Extends INumeric
		Return Linq().Average(Self, transform)
	End

	Method Concat:Stack<T>(stack:Stack<T>)
		Return Linq().Concat(Self, stack)
	End

	Method Contains2:Bool(match:T)
		Return Linq().Contains(Self, match)
	End
	
	Method Contains2:Bool(match:T, comparer:Comparer<T>)
		Return Linq().Contains(Self, match, comparer)
	End

	Method Count:UInt()
		Return Length
	End

	Method Count:UInt(predicate:Predicate<T>)
		Return Linq().Count(Self, predicate)
	End
	
	Method DefaultIfEmpty:Stack<T>(defaultValue:T)
		Return Linq().DefaultIfEmpty(Self, defaultValue)
	End

	Method Distinct:Stack<T>()
		Return Linq().Distinct(Self, Null)
	End

	Method Distinct:Stack<T>(comparer:Comparer<T>)
		Return Linq().Distinct(Self, comparer)
	End

	Method ElementAt:T(index:UInt)
		Return Linq().ElementAtOrDefault(Self, index, Null)
	End	

	Method ElementAtOrDefault:T(index:UInt, defaultValue:T)
		Return Linq().ElementAtOrDefault(Self, index, defaultValue)
	End
	
	Method Except:Stack<T>(stack:Stack<T>)
		Return Linq().Except(Self, stack, Null)
	End

	Method Except:Stack<T>(stack:Stack<T>, comparer:Comparer<T>)
		Return Linq().Except(Self, stack, comparer)
	End
	
	Method First:T()
		If Empty Then Return Null
		Return Get(0)
	End

	Method First:T(predicate:Predicate<T>)
		Return Linq().FirstOrDefault(Self, Null, predicate)
	End

	Method FirstOrDefault:T(defaultValue:T)
		Return Linq().FirstOrDefault(Self, First(), defaultValue)
	End

	Method FirstOrDefault:T(defaultValue:T, predicate:Predicate<T>)
		Return Linq().FirstOrDefault(Self, defaultValue, predicate)
	End
	
	Method Intersect:Stack<T>(stack:Stack<T>)
		Return Linq().Intersect(Self, stack, Null)
	End

	Method Intersect:Stack<T>(stack:Stack<T>, comparer:Comparer<T>)
		Return Linq().Intersect(Self, stack, comparer)
	End

	Method Join2<TOuter, TInner, TKey, TResult>:Stack<TResult>(inner:Stack<TInner>, outerKeySelector:Selector<TOuter,TKey>, innerKeySelector:Selector<TInner,TKey>, resultSelector:TResult(outer:TOuter, inner:TInner))
		Return Linq().Join<T,Stack<TInner>,TInner,TKey,Stack<TResult>,TResult>(Self, inner, outerKeySelector, innerKeySelector, resultSelector)
	End
	
	Method Join2<TOuter, TInner, TKey, TResult>:Stack<TResult>(inner:Stack<TInner>, outerKeySelector:Selector<TOuter,TKey>, innerKeySelector:Selector<TInner,TKey>, resultSelector:TResult(outer:TOuter, inner:TInner), keyComparer:Comparer<TKey>)
		Return Linq().Join<T,Stack<TInner>,TInner,TKey,Stack<TResult>,TResult>(Self, inner, outerKeySelector, innerKeySelector, resultSelector, keyComparer)
	End
	
	Method Last:T()
		If Empty Then Return Null
		Return Get(Length - 1)
	End

	Method Last:T(predicate:Predicate<T>)
		Return Linq().LastOrDefault(Self, Null, predicate)
	End

	Method LastOrDefault:T(defaultValue:T)
		Return Linq().LastOrDefault(Self, Last(), defaultValue)
	End

	Method LastOrDefault:T(defaultValue:T, predicate:Predicate<T>)
		Return Linq().LastOrDefault(Self, defaultValue, predicate)
	End
	
	Method Max:T() Where T Extends INumeric
		Return Linq().Max(Self, Null)
	End

	Method Max:T(transform:NumericTransform<T>) Where T Extends INumeric
		Return Linq().Max(Self, transform)
	End	
	
	Method Min:T() Where T Extends INumeric
		Return Linq().Min(Self, Null)
	End

	Method Min:T(transform:NumericTransform<T>) Where T Extends INumeric
		Return Linq().Min(Self, transform)
	End
	
	Method OrderBy:Stack<T>(sorter:Sorter<T>)
		Return Linq().OrderBy(Self, sorter)
	End	
	
	Method OrderByDescending:Stack<T>(sorter:Sorter<T>)
		Return Linq().OrderByDescending(Self, sorter)
	End	
	
	' Where() equivalent
	Method Query:Stack<T>(predicate:Predicate<T>)
		Return Linq().Query(Self, predicate)
	End

	' Where() equivalent
	Method Query:Stack<T>(predicate:PredicateWithIndex<T>)
		Return Linq().Query(Self, predicate)
	End

	Function Range:Stack<T>(start:T, count:UInt) Where T Extends INumeric
		Return LinqHelper<Stack<T>,T>.Range(start, 1, count)
	End

	Function Range:Stack<T>(start:T, rate:T, count:UInt) Where T Extends INumeric
		Return LinqHelper<Stack<T>,T>.Range(start, rate, count)
	End
	
	Function Repeat2:Stack<T>(item:T, count:UInt)
		Return LinqHelper<Stack<T>,T>.Repeated(item, count)
	End
	
	Method Reverse:Stack<T>()
		Return Linq().Reverse(Self)
	End
	
	Method Select2<T,TResult>:Stack<TResult>(selector:Selector<T,TResult>)
		Return Linq().Select2<T,Stack<TResult>,TResult>(Self, selector)
	End
	
	Method Select2<T,TResult>:Stack<TResult>(selector:SelectorWithIndex<T,TResult>)
		Return Linq().Select2<T,Stack<TResult>,TResult>(Self, selector)
	End

	Method SelectMany<T,TResult>:Stack<TResult>(selector:StackSelector<T,TResult>)
		Return Linq().SelectMany<T,Stack<TResult>>(Self, Lambda:Stack<TResult>(item:T)
			Return selector(item)
		End)
	End	

	Method SelectMany<T,TResult>:Stack<TResult>(selector:StackSelectorWithIndex<T,TResult>)
		Return Linq().SelectMany<T,Stack<TResult>>(Self, Lambda:Stack<TResult>(item:T, index:Int)
			Return selector(item, index)
		End)
	End	

	Method SelectMany<T,TIntermediate,TResult>:Stack<TResult>(stackSelector:StackSelector<T,TIntermediate>, resultSelector:Transform<T,TIntermediate,TResult>)
		Return Linq().SelectMany<T,Stack<TIntermediate>,TIntermediate,Stack<TResult>,TResult>(Self, Lambda:Stack<TIntermediate>(item:T)
			Return stackSelector(item)
		End, resultSelector)
	End	

	Method SelectMany<T,TIntermediate,TResult>:Stack<TResult>(stackSelector:StackSelectorWithIndex<T,TIntermediate>, resultSelector:Transform<T,TIntermediate,TResult>)
		Return Linq().SelectMany<T,Stack<TIntermediate>,TIntermediate,Stack<TResult>,TResult>(Self, Lambda:Stack<TIntermediate>(item:T, index:Int)
			Return stackSelector(item, index)
		End, resultSelector)
	End	

	Method SequenceEqual:Bool(stack:Stack<T>)
		Return SequenceEqual(stack, Null)
	End

	Method SequenceEqual:Bool(stack:Stack<T>, comparer:Comparer<T>)
		
		If Count() <> stack.Count() Then Return False
		If Empty and stack.Empty Then Return True

		Local index:UInt = 0
		
		For Local item := EachIn All()
		
			If comparer <> Null
				If Not comparer(item, stack.Get(index)) Then Return false
			Else
				If item <> stack.Get(index) Then Return False
			End
		
			index += 1
			
		End
		
		Return True
		
	End

	Method Single:T()
		Return Linq().Single("Stack", Self, First())
	End
	
	Method Single:T(predicate:Predicate<T>)
		Return Linq().Single(Self, predicate, 
			' Get first match
			Lambda:T(stack:Stack<T>)
				Local first:T = Null
				If Not Empty Then first = stack.First()
				Return first
			End)
	End

	Method SingleOrDefault:T(defaultValue:T)
		Return Linq().SingleOrDefault("List", Self, defaultValue, First())
	End

	Method SingleOrDefault:T(defaultValue:T, predicate:Predicate<T>)
		Return Linq().SingleOrDefault(Self, defaultValue, predicate, 
			' Get first match
			Lambda:T(stack:Stack<T>)
				Local first:T = Null
				If Not Empty Then first = stack.First()
				Return first
			End)
	End
	
	Method Skip:Stack<T>(count:Int)
		Return Linq().Skip(Self, count)
	End

	Method SkipWhile:Stack<T>(predicate:Predicate<T>)
		Return Linq().SkipWhile(Self, predicate)
	End

	Method SkipWhile:Stack<T>(predicate:PredicateWithIndex<T>)
		Return Linq().SkipWhile(Self, predicate)
	End

	Method Sum:T() Where T Extends INumeric
		Return Linq().Sum(Self, Null)
	End

	Method Sum:T(transform:NumericTransform<T>) Where T Extends INumeric
		Return Linq().Sum(Self, transform)
	End	

	Method Take:Stack<T>(count:Int)
		Return Linq().Take(Self, count)
	End

	Method TakeWhile:Stack<T>(predicate:Predicate<T>)
		Return Linq().TakeWhile(Self, predicate)
	End

	Method TakeWhile:Stack<T>(predicate:PredicateWithIndex<T>)
		Return Linq().TakeWhile(Self, predicate)
	End

	' ThenBy() not implemented
	
	' ToArray() already exists
	
	Method ToList<T>:List<T>()
		Return New List<T>(Self)
	End

	' ToDictionary() with comparer not implemented
	
	' ToDictionary() equivalent
	Method ToMap<T,TKey>:Map<TKey,T>(keySelector:Selector<T,TKey>)
		Return Linq().ToMap(Self, keySelector)
	End

	' ToDictionary() equivalent
	Method ToMap<T,TKey,TElement>:Map<TKey,TElement>(keySelector:Selector<T,TKey>, elementSelector:Selector<T,TElement>)
		Return Linq().ToMap(Self, keySelector, elementSelector)
	End

	' ToLookup() not required

	Method Union:Stack<T>(stack:Stack<T>)
		Return Linq().Union(Self, stack, Null)
	End
	
	Method Union:Stack<T>(stack:Stack<T>, comparer:Comparer<T>)
		Return Linq().Union(Self, stack, comparer)
	End

	Method Zip<T,TSecond,TResult>:Stack<TResult>(stack:Stack<TSecond>, transform:Transform<T,TSecond,TResult>)

		Local newStack := New Stack<TResult>()
		If Empty Or stack.Empty Then Return newStack

		Local count:Int = monkey.math.Min(Count(), stack.Count())
		Local index:Int = 0
	
		For Local item1 := EachIn All()

			Local item2 := stack.Get(index)

			newStack.Add(transform(item1, item2))			
			
			index += 1
			If index = count Then Return newStack
		
		End

		Return newStack ' should never get here but required to compile

	End

End
