#import "<mojo>"
#import "<std>"
#import "game"

Using mojo..
Using std..


Class MyGameWindow Extends Window
	Field game:Game
	
	Method New(title:String, width:Int, height:Int)
		Super.New(title,width,height)
		ClearColor = Color.Black
		SwapInterval =1
		SeedRnd(1798)
		game = New Game
	End

	Method OnWindowEvent(event:WindowEvent) Override
		Select event.Type
			Case EventType.WindowMoved
			Case EventType.WindowResized
				App.RequestRender()
			Case EventType.WindowGainedFocus
			Case EventType.WindowLostFocus
			Default
				Super.OnWindowEvent(event)
		End
	End

	Method OnKeyEvent( event:KeyEvent ) Override
	
		If event.Type = EventType.KeyUp
				
			Select event.Key
				Case Key.Escape
					App.Terminate()
			End
		
		Endif
		
	End
	
	Method OnRender( canvas:Canvas ) Override
		canvas.Scale(1.3,1.3)
		game.Update()
		game.Render(canvas)
		canvas.Flush()
		App.RequestRender()
	End method

End Class


Function Main()
	New AppInstance
	
	New MyGameWindow("patrol",800,600)

	App.Run()
End Function

