Namespace jplib

#import "common.monkey2"
#import "vec2d.monkey2"

'***********************************************************
'*			collision										"
'***********************************************************


Class Collision Abstract
	Field pos:Vec2d
	Field off:Vec2d
	
	Method New()
		off = New Vec2d
	End Method
	
	Method Set:Void(pos:Vec2d,ox:Float,oy:Float,width:Float,height:Float) Virtual
	End Method
	Method Set:Void(pos:Vec2d,ox:Float,oy:Float,radius:Float) Virtual
	End method
	Method Collided:Bool(col:Collision) Abstract
	Method Render(canvas:Canvas) Abstract
	
End Class


Class HitBox Extends Collision
	Field width:Float
	Field height:Float
  
  	Method New()
  		Super.New()
  	End Method
  
	Method New(p:Vec2d,x:Float,y:Float,width:Float,height:Float)
		Super.New()     
		Set(p,x,y,width,height)
	End Method
  
	Method Set:Void(pos:Vec2d,ox:Float,oy:Float,width:float,height:float) Override
		Self.pos = pos
		off.Set(ox,oy)
		Self.width = width
		Self.height = height
	End Method
  
  Method Collided:Bool(bx:Collision) Override
  		Local box := cast<HitBox>(bx)
    	Local b1x1:Float = pos.x + off.x
    	Local b1y1:Float = pos.y + off.y
    	Local b1x2:Float = pos.x + width
    	Local b1y2:Float = pos.y + height
    	Local b2x1:Float = box.pos.x + box.off.x
    	Local b2y1:Float = box.pos.y + box.off.y
    	Local b2x2:Float = box.pos.x + box.width
    	Local b2y2:Float = box.pos.y + box.height
    	If b1x1 > b2x2 Return False
    	If b1x2 < b2x1 Return False
    	If b1y1 > b2y2 Return False
    	If b1y2 < b2y1 Return False 
    Return True
  End Method
    
  Method Render:Void(canvas:Canvas) Override
		gfx.MoveTo(pos.x+off.x,pos.y+off.y)
		gfx.LineTo(canvas,pos.x+off.x+width,pos.y+off.y)
		gfx.LineTo(canvas,pos.x+off.x+width,pos.y+off.y+height)
		gfx.LineTo(canvas,pos.x+off.x,pos.y+off.y+height)
		gfx.Close(canvas)
  End Method
  
End Class


Class HitCircle Extends Collision
	
	Field radius:Float
	
	Method New()
	
	End Method
	
	Method New(pos:Vec2d,ox:Float,oy:Float,radius:Float)
		Set(pos,ox,oy,radius)
	End Method
	
	Method Set(pos:Vec2d,ox:Float,oy:Float,radius:Float=0) Override
		Self.pos = pos
		off.Set(ox,oy)
		Self.radius = radius
    End Method
    
	Method Collided:Bool(bx:Collision) Override
  		Local box := Cast<HitBox>(bx)
		If box Then 
			Return Rectangle(box)
		Endif
		Local cir := Cast<HitCircle>(bx)
		If cir Then 
			Return Circle(cir) 
		Endif
		Return False
	End Method
  
	Method Circle:Bool(cir:HitCircle)
  		Local totRadius:Float
  		Local vx:Float = pos.x - cir.pos.x
  		Local vy:Float = pos.y - cir.pos.y
  		totRadius = Self.radius+cir.radius
  			
  		If (vx*vx+vy*vy) < totRadius*totRadius Return True
  		Return false
	End Method
  
	Method Rectangle:Bool(rect:HitBox)
  		Local vx:Float = rect.width/2
  		Local vy:Float = rect.height/2
		Local radius:Float = Sqrt(vx*vx + vy*vy) 
		Local totRadius := Self.radius + radius
		Local nx:Float = pos.x - rect.pos.x 
		Local ny:Float = pos.y - rect.pos.y
		If totRadius*totRadius < (nx*nx + ny*ny) Return False
		Return True
	End Method
	
	Method Render:void(canvas:Canvas) Override
		gfx.Circle(canvas,off.x+pos.x,off.y+pos.y,radius)
	End Method
End Class

