
Namespace jplib

'*****************************************************
'*			Entity									 *
'*****************************************************

#import "<std>"
#import "<mojo>"

Using std..
Using mojo..

Interface ICollidable
	Method Collided:Bool(entity:Entity)
End Interface

Class Entity Extends StoreObject
	Field pos:Vec2d
	Field dir:Vec2d
	Field vel:Vec2d
	Field dead:Bool
	Field shape:Collision
	Field state:Int
	Field nextState:Int
  	Field target:Vec2d
	Field link:List<Entity>.Node
	Field animation:Animation
	
	Const prefix:String = "Invalid call to virtual method "
	Const suffix:String = " on abstract class Entity"
	Const deadm:String = "'Dead'"
	Const update:String = "'Update'"
	Const render:String = "'Render'"
	Const collided:String = "'Collided'"
	
	Method New()
	End Method
	
	Method Dead:Bool() Virtual
		RuntimeError(prefix+deadm+suffix)
		Return False
	End Method
	
  	Method Update:Bool() Virtual
  		RuntimeError(prefix+update+suffix)
  		Return False
  	End Method
  	
  	Method ShootBullet(entity:Entity) Virtual
  	
  	End Method
  	
	Method Render:Void(canvas:Canvas) virtual
		RuntimeError(prefix+render+suffix)
	End Method
	

	Method Explode(explosionList:List<Explosion>,explosionStore:Store<Explosion>)
		
		Local exp := explosionStore.GetItem()
		Local x:Float = animation.current.Value.image.Width
		Local y:Float = animation.current.Value.image.Height
		exp.Set(animation.current.Value,pos.x-x,pos.y-y)
		explosionList.AddLast(exp)
		exp = explosionStore.GetItem()
		exp.Set(animation.current.Value,pos.x-x,pos.y-y)
		explosionList.AddLast(exp)
		exp = explosionStore.GetItem()
		exp.Set(animation.current.Value,pos.x-x,pos.y-y)
		explosionList.AddLast(exp)
		exp = explosionStore.GetItem()
		exp.Set(animation.current.Value,pos.x-x,pos.y-y)
		explosionList.AddLast(exp)
	End Method
 
End Class

