#import "patrol"

Class Level Abstract
	Field terrain:Terrain
	Field playerManager:PlayerManager
	
	Method New()
	
	End Method
	
	Method Update:int() Virtual
		Return 1
	End Method
	
	Method Render(canvas:Canvas) Virtual
	
	End Method
	
End Class

Class Stage1 Extends Level
	Field ufoManager:UfoManager
	
	Method New(terrain:Terrain,playerManager:PlayerManager)
		Self.terrain = terrain
		Self.playerManager = playerManager
		ufoManager = New UfoManager(playerManager,terrain)
	End Method
	
	Method Update:Int() Override
		playerManager.UpdateExplosions()
		If Not terrain.DoneTraversing()
			terrain.Update()
			playerManager.Update()
			ufoManager.Collided()
		Else
			playerManager.UpdateBullets()
		Endif
		If terrain.DoneTraversing()
			If ufoManager.state = EntityState.UPDATING
				ufoManager.SetNextState()
			Endif
		Endif
		ufoManager.Update()

		Return True
	End Method
	
	Method Render(canvas:Canvas) Override
		terrain.Render(canvas)
		playerManager.Render(canvas)
		ufoManager.Render(canvas)
	End Method
	
End Class


