
'***************************************************************
'* 						vehicle									 *
'***************************************************************

#Import "jp-lib/jp-lib"

Using jplib..

Function GenerateCarTile:Image()
  Local tile:Image = New Image(64,32)
  Local icanvas:Canvas = New Canvas(tile)
  icanvas.Clear(New Color(0,0,0,0))
  icanvas.Color = New Color(.8,.8,.2)
  icanvas.DrawOval(25,11,30,15)
  icanvas.Color = New Color(.8,.4,.0)
  icanvas.DrawRect(10,20,48,5)
  icanvas.DrawRect(20,20,40,10)
  icanvas.DrawOval(15,10,35,40)
  icanvas.Color = New Color(.4,.8,.0)
  icanvas.DrawPoly(New Float[](20,10,40,10,40,20,20,20))
  icanvas.Color = New Color(.8,.1,.1)
  icanvas.DrawRect(22,-10,8,20)
  icanvas.DrawRect(58,23, 6,6)
  tile.Handle = New Vec2f(.5,.5)
#Rem
  icanvas.DrawLine(0,0,63,0)
  icanvas.DrawLine(63,0,63,31)
  icanvas.DrawLine(63,31,0,31)
  icanvas.DrawLine(0,31,0,0)
#End
  icanvas.Flush()
  Return tile
End Function

Class Vehicle Extends Entity
  	Field wheel:Wheel[]
  	Field yy:Float
  	Field jumping:Bool
  	Field gravity:Float
  	Field shift:Float
  	Field speed:Float
  	Field temp:Vec2d
  	
  	Field terrain:Terrain
  	
	Method New ()
	 
	End Method
	
	Method New(animation:Animation,x:float,y:Float)
		wheel = New Wheel[3]
		temp = New Vec2d(x,y)
		pos = New Vec2d(temp)
		wheel[0] = New Wheel(temp,-15,10,5)
		wheel[1] = New Wheel(temp,0,10,5)
		wheel[2] = New Wheel(temp,15,10,5)
		dir = New Vec2d()
		Self.animation = animation
		jumping = False
		shape = New HitBox(pos,-18.0,-8.0,38.0,20.0)
		shift = 5
	End Method

	Method SetTerrain(terr:Terrain)
		terrain = terr
	End Method
	
	Method Jump()
		If jumping = False
			If Keyboard.KeyHit(Key.Up|Key.Raw) 	
'				sfx.PlayJumpSound()
				jumping = True
				dir.Set(0,-3.2)
				gravity = 0
				wheel[0].SetYPosition(15)
				wheel[1].SetYPosition(15)
				wheel[2].SetYPosition(15)
				sfx.PlayJump()
			Endif
		Endif
	End Method
  
 	Method AdjustWheels(ter:Land)
		If jumping
			temp.y += dir.y
			gravity += .010
			dir.y += gravity
			If dir.y >= shift And temp.y >= 400
				temp.y = 400
				jumping = False
			Endif
    	Else
			Local y1:Float = ter.GetHeightAtX(wheel[0].GetXPoisition()) - 21
			Local y2:Float = ter.GetHeightAtX(wheel[1].GetXPoisition()) - 21
			Local y3:Float = ter.GetHeightAtX(wheel[2].GetXPoisition()) - 21
			yy = (y1+y2+y3)/3.0-15
    
			wheel[0].SetYPosition(y1)
			wheel[1].SetYPosition(y2)
			wheel[2].SetYPosition(y3)
    	Endif
  	End Method
  
	Method MoveForward:Void()
		If pos.x < 450
			If jumping = False
				temp.x += shift/3.0
			Else
				temp.x += shift/4.0
			Endif
		Elseif speed < 1.0
 			speed += .05
 		Else
 			speed = 1.0
		Endif
    End Method
    
	Method MoveBackward:Void()
			If temp.x > 80
				If jumping = False
					temp.x -= shift/3.0
				Else
					temp.x -= shift/4.0
				Endif
			Elseif speed > 1.5
				speed -= .05
			Else
				speed = 1.5
			Endif
	End Method
	
	Method Update:Bool() Override
    	Jump()
 		AdjustWheels(terrain.land)	
	    If Keyboard.KeyDown(Key.Right|Key.Raw)
     		MoveForward()
    	Endif
    	If Keyboard.KeyDown(Key.Left|Key.Raw)
    		MoveBackward()
    	Endif
    	If speed < 1.5 speed = 1.5
    	pos.Set(temp.x,temp.y+yy)
    	Return True
	End Method
  
  
	Method CollidedClif:Bool(ter:Terrain)
  		'Local y:Float = ter.GetHeightAtX(wheel[0].GetXPoisition()) - 20
		'If y > 20 Return True
		'y = ter.GetHeightAtX(wheel[1].GetXPoisition()) - 20
      	'If y > 20 Return True
		'y = ter.GetHeightAtX(wheel[2].GetXPoisition()) - 20
		'If y > 20 Return True
		Return False

	End Method
  
	
	Method Render:void(canvas:Canvas) Override
		canvas.Color = Color.White
		animation.Render(canvas,pos.x,pos.y)
		wheel[0].Render(canvas)
		wheel[1].Render(canvas)
		wheel[2].Render(canvas)
		If displayHitBox
			shape.Render(canvas)
		Endif
	End Method
  
End Class


Class Wheel Extends Entity
  Field offset:Vec2d
  Field radius:Float
  
  Method New()
  
  End Method
  
  Method New(p:Vec2d,offx:Float,offy:Float,rad:Float)
    offset = New Vec2d(offx,offy)
    pos = p
    radius = rad
  End 
  
  Method GetXPoisition:Float()
    Return pos.x + offset.x
  End Method
  
  Method SetYPosition(y:Float)
    offset.y = y
  End Method
 
  Method Render:void(canvas:Canvas) Override
    gfx.Circle(canvas,pos.x+offset.x,pos.y+offset.y,radius)
  End Method
End Class

Class PlayerManager Extends Manager
	Field terrain:Terrain
	Field image:Image
	Field time:Int
	Field delay:Int = 500
  	Field hit:Bool
 	
	Method New()
		entityList = New List<Entity>	
	End Method

	Method New(terrain:Terrain)
		Super.New()
		entityList = New List<Entity>
		Self.terrain = terrain
		Self.animation = New Animation()
		Self.animation.AddFrame(New Sprite(GenerateCarTile(),4,4))
		Local vehicle :=  New Vehicle(animation,100,400)
		vehicle.link = entityList.AddLast(vehicle)
		vehicle.SetTerrain(terrain)
    	player = vehicle
    	time = Millisecs()
    	hit = False
	End Method

	Method Update:Bool() Override
		player.Update()
		UpdateBullets()
		Shoot()
		UpdateExplosions()
		Return True
	End Method
	
	Method Shoot:Bool()
		If time + delay < Millisecs() And Keyboard.KeyDown(Key.Space|Key.Raw) Or hit
			hit = False
'			sfx.PlayVShot()
    		Local bullet := bulletStore.GetItem()
    		bullet.Set(player.pos.x-10,player.pos.y-30,Bullet.UP,5)
			bulletList.AddLast(bullet)
    		bullet = bulletStore.GetItem()
    		bullet.Set(player.pos.x+25,player.pos.y+3,Bullet.RIGHT,5)
    		bulletList.AddLast(bullet)
    		time = Millisecs()
    		sfx.PlayShot()
    		Return True
		Endif
		Return False
	End Method
	
	Method Collided(list:List<Entity>,explosionList:List<Explosion>,explosionStore:Store<Explosion>)
		If Not list.Empty
			Local entityLink := list.FirstNode()
			While entityLink.Value
				If Not bulletList.Empty
					Local bulletLink := bulletList.FirstNode()
					While bulletLink.Value
						If bulletLink.Value.Collided(entityLink.Value)
							bulletLink.Remove()
							entityLink.Remove()
							entityLink.Value.Explode(explosionList,explosionStore)
							Exit
						Endif
						bulletLink = bulletLink.Succ
					Wend
				Endif
				entityLink = entityLink.Succ
			Wend
		Endif
	End Method
	
	
	Method Render(canvas:Canvas) Override
		RenderBullets(canvas)
		player.Render(canvas)
		RenderExplosions(canvas)
	End Method
End Class