#import "jp-lib/jp-lib"

Using jplib..

Class Terrain
	Field backHills:Hills
	Field frontHills:Hills
	Field land:Land
	Field stars:Stars
	Field cloud:Cloud[]
	Field texImg:Image
	Method New()
		land = New Land()
		land.Speed =.8
		backHills = New Hills(2,25,120,80,3)
		backHills.speed = 0.4
		frontHills = New Hills(3,20,140,80,5)
 		frontHills.speed = .8
 		stars = New Stars
 		texImg = TextureImage() 
 		cloud = New Cloud[9]
		cloud[0] = New Cloud(texImg,380,115,20,20,.7)
 		cloud[1] = New Cloud(texImg,200,115,25,20,.7)
 		cloud[2] = New Cloud(texImg,600,115,40,20,.7)
 		cloud[3] = New Cloud(texImg,100,100,60,30,1.0)
 		cloud[4] = New Cloud(texImg,450,100,60,30,1.0)
 		cloud[5] = New Cloud(texImg,720,100,60,30,1.0)
 		cloud[6] = New Cloud(texImg,10 ,125,60,15,.5)
 		cloud[7] = New Cloud(texImg,300,125,60,15,.5)
 		cloud[8] = New Cloud(texImg,400,125,60,15,.5)

  	End Method
 	
 	Method Update:Void()
 		backHills.Update()
 		frontHills.Update()
 		For Local i:Int = 0 Until cloud.Length
 			cloud[i].Update()
 		Next
 		land.Update()
 		stars.Update()
 		
 	End Method
 	
 	Property FrontHillSpeed(speed:Float)
 		frontHills.Speed = speed
 	End
 	
 	Property BackHillsSpeed(speed:Float)
 		backHills.Speed = speed
 	End 
 	
 	Method LandSpeed(speed:Float)
 		land.Speed  = speed
 	End
 	
 	Method GetPosition:Int()
 		Return land.GetPosition
 	End Method
 	
 	Method MakeHole(i:Int)
 		land.MakeHole(i)
 	End Method
 	
 	Method GetPercent:Float()
 		Return land.GetPercent
 	End Method
 	Method GetLandHeightAtX:Float(x:Float)
 		Return land.pos.y+land.GetHeightAtX(x)
 	End Method
 	
 	Method DoneTraversing:Bool()
 		Return land.Done
 	End Method
 	
 	Method Render:Void(canvas:Canvas)
 		stars.Render(canvas)
 		canvas.Color = New Color(.2,.3,.2)
 		backHills.Render(canvas)
 		canvas.Color = New Color(1,1,1,1)
 		For Local i:Int = 0 Until cloud.Length
 			cloud[i].Render(canvas)
 		Next
 		canvas.Color = New Color(.2,.4,.2)
 		frontHills.Render(canvas)
 		canvas.Color = New Color(1,1,1,1)
 		land.Render(canvas)
 	End Method
 	
 	Method RenderHills:Void(canvas:Canvas)
 		stars.Render(canvas)
 		canvas.Color = New Color(.2,.3,.2)
 		backHills.Render(canvas)
 		canvas.Color = New Color(1,1,1,1)
 		For Local i:Int = 0 Until cloud.Length
 			cloud[i].Render(canvas)
 		Next
 		canvas.Color = New Color(.2,.4,.2)
 		frontHills.Render(canvas)
 		
	End Method
	
	Method RenderLand:Void(canvas:Canvas)
 		canvas.Color = New Color(1,1,1,1)
 		land.Render(canvas)
	End Method	 	
 	
End Class 	
 	
 	
 Class Stars Extends Entity
 
 	Field list:List<Particle>
 
 	Class Particle
 		Field pos:Vec2d
 		Field color:Color
 		
 		Method New()
 		End Method
 		
 		Method New(x:Float,y:Float)
 		 pos = New Vec2d(x,y)
 		 color = New Color(Rnd(0,1),Rnd(0,1),Rnd(0,1),Rnd(0,1))
 		End Method
 		
 		Method Update()
 			color.R = (color.R + 0.001) Mod 1.0
 			color.G = (color.G + 0.001) Mod 1.0
 			color.B = (color.B + 0.001) Mod 1.0
 			color.A = (color.A + 0.001) Mod 1.0
 		End Method
 		
 		
 		Method Render(canvas:Canvas)
 			canvas.Color = color
 			canvas.DrawRect(pos.x,pos.y,2,2)

 		End Method
 	End Class
 	
 	Method New()
 		list = New List<Particle>
 		For Local i:Int = 0 Until 50
 			 Local particle:Particle = New Particle(Rnd(0,640),Rnd(100,200))
 			 list.AddLast(particle)
 		next
 	End Method
 	
 	Method Update:Bool() Override
 		If list.Empty Return True
 		Local link := list.FirstNode()
 		While link.Value
 			Local particle := Cast<Particle>(link.Value)
 			particle.Update()
 			link = link.Succ
 		Wend	
 		Return True
 	End Method
 	
 	method Render(canvas:Canvas) Override
 		If list.Empty Return
 		Local link := list.FirstNode()
 		While link.Value
 			Local particle := Cast<Particle>(link.Value)
  			particle.Render(canvas)
 			link = link.Succ
 		Wend	
 	End Method
End Class


Class Cloud

	Field pos:Vec2d
	Field vel:Vec2d
	
	Field width:Float
	Field height:Float
	Field midWidth:Float
	Field midHeight:Float
	Field radius:Float
	Field stp:Float
	Field stps:Float
	
	Field min:Float
	Field max:Float
	Field point:Float[]
	Field poly:Float[]
	Field pixelStep:Float = 15.0
	Field image:Image
	
	Method New(image:Image,x:Float,y:Float,width:Float,height:float,speed:Float)
		Self.pos = New Vec2d(x,y)
		Self.width = width
		Self.height = height
		Self.radius = height / 2.0
		Self.vel   = New Vec2d(speed,0)
		Self.stp   = pixelStep/(Pi*radius)
		Self.stps  =  Int(2*Pi / stp+.99)
		Self.point = New Float[stps*2]
		Self.poly  = New Float[stps*2]
		Self.min   = -(Pi/2.0)
		Local index:Float = 0
		Local i:Int
		For i = 0 Until point.Length Step 2
			If index <= Pi
				point[i ] =  width/2.0 + Cos(min+index) * (radius-.5)
				point[i+1] = Sin(min+index) * (radius)
			Else
				point[i ] =  -width/2.0 + Cos(min+index) * (radius-.5)
				point[i+1] = Sin(min+index) * (radius)
			Endif
			index += stp
		Next
		Self.image = image
		
	End Method
	
	Method Update()
			pos.Subtract(vel)
			If pos.x < -200 pos.x = 800
	End Method
	
	Method Render(canvas:Canvas)
		canvas.Color = New Color(.4,.4,.8,.9)
		For Local i:Int = 0 Until point.Length Step 2
			poly[  i] = pos.x + point[i]
			poly[i+1] = pos.y + point[i+1]
		Next
		canvas.DrawPoly(poly)
		Local i:Int 
		For i = 0 Until point.Length-2 Step 2
			DrawGlowLine(canvas,image,poly[i],poly[i+1],poly[i+2],poly[i+3],5)
		Next
		DrawGlowLine(canvas,image,poly[poly.Length-2],poly[poly.Length-1],poly[0],poly[1])
		canvas.Color = New Color(1,1,1,1)
	End Method
	
End Class