'******************************************************
'*				Ufo									   *
'******************************************************

#import "jp-lib/jp-lib"

Using jplib..

Function  GenerateUfo:Image()
    Local img:Image = New Image(48,32)
    Local icanvas:Canvas = New Canvas(img)
    icanvas.Clear(new Color(0,0,0,0)) 
	icanvas.Color = New Color(0,0,1)
	icanvas.DrawOval(0,8,48,14)
	icanvas.Color = New Color(.8,.2,.7)
	icanvas.DrawOval(1,9,46,12)
	icanvas.Color = New Color(0,0,0)
	icanvas.DrawCircle(23,12,10)
	icanvas.Color = New Color(1,1,1,.7)
	icanvas.DrawCircle(23,12,9)
	icanvas.Color = New Color(0,0,0,1)
	icanvas.DrawRect(14,10,20,10)
	icanvas.Color = New Color(1,1,0)
	icanvas.DrawRect(15,11,18,8)
    icanvas.Flush()
    img.Handle = New Vec2f(.5,.5)
    Return img
End Function

Class Ufo Extends Entity
	Field vel:Vec2d
	Field bullet:Bullet  
  	Field offsetY:Float
  	
  	
  	Const dir:Float = 1.0
  	
	Method New()
		pos = New Vec2d(0,0)
		shape = New HitBox(pos,-16,-10,30,14)
		vel = New Vec2d(Rnd(3.0,7.0),0)
		state = EntityState.ENTERING
		offsetY = Rnd(20)
	End Method
	   	
	Method New(animation:Animation,x:Float,y:Float)
		Self.animation = animation
		pos = New Vec2d(x,y)
		shape = New HitBox(pos,-16,-10,30,14)
		vel = New Vec2d(Rnd(2.0,5.0),0)
		state = EntityState.ENTERING
		offsetY = Rnd(20)
	End Method
  
	Method Set(x:Float,y:float)
		pos.Set(x,y)
		state = EntityState.ENTERING
		offsetY = Rnd(20)
	End Method
  
	Method Update:bool()Override
		Select state
			Case   EntityState.ENTERING
				If pos.y < 200+offsetY
					pos.Add(0,1)
				Else
					state = EntityState.UPDATING
				Endif
				If vel.x > 0 
					If 	pos.x >= target.x + 200
						vel.Multiply(-dir)
					Endif
				Else
					If pos.x <= target.x - 200
						vel.Multiply(-dir)
					Endif
				Endif	
			Case EntityState.UPDATING
				If vel.x > 0
					If pos.x > target.x + 200
						vel.Multiply(-dir)
						pos.Subtract(0,3)
					Endif
				Else
					If pos.x < target.x - 200
						vel.Multiply(-dir)
						pos.Add(0,3)
					Endif
				Endif	
		End Select
		If state = EntityState.EXPLODING 
		
		Else
			pos.Add(vel).Add(Rnd(-1,1))
		Endif
		Return true
	End Method

	Method Render:void(canvas:Canvas) Override
		canvas.Color = New Color(1,1,1)
		animation.Render(canvas,pos.x,pos.y)
		If displayHitBox 
			shape.Render(canvas)
		Endif
	End Method
  
End Class

Class UfoManager Extends Manager

	Field startTime:Float
	Field endTime:Float
	Field millisec:float
	Field shootDelay:Float
	Field shootTime:Float
	Field terrain:Terrain
	Field playerManager:Manager
	Field rockManager:RockManager
	Field UfoStore:Store<Ufo>
	Field explodeTime:Int
	Field delay:Int
	
	Const MIN_START_TIME:Int = 3000
	Const MAX_START_TIME:Int = 10000
	
	Method New()
	
	End Method
	
	Method New(playerManager:Manager,terrain:Terrain)
		Super.New()
		Self.playerManager = playerManager
		Self.player = playerManager.player
		Self.terrain = terrain
		Self.UfoStore = New Store<Ufo>(100)
		Self.animation = New Animation
		Self.rockManager = New RockManager(playerManager,terrain)
		animation.AddFrame(New Sprite(GenerateUfo(),4,2))
		startTime = 5000+Millisecs()
		millisec = Millisecs()
		shootDelay = 500
		shootTime = Millisecs() + shootDelay
		state = EntityState.ENTERING
		Self.delay = 100
		explodeTime = Millisecs()
	End Method
	
	Method SetNextState()
		state = nextState
	End Method
	
	Method Update:bool()Override
		
		Select state
			Case EntityState.ENTERING
				nextState = EntityState.UPDATING
				SetNextState()
			Case EntityState.UPDATING
				If startTime <= Millisecs()
				    Local ufo :=  UfoStore.GetItem()
					ufo.animation = animation
					ufo.target =  player.pos
					ufo.Set(Rnd(20,600),10)
					ufo.link = entityList.AddLast(ufo)
					startTime = Millisecs() + Rnd(MIN_START_TIME,MAX_START_TIME)
				End
				If Not entityList.Empty
					Local link := entityList.FirstNode()
					While link.Value
						link.Value.Update()
						link = link.Succ
					Wend
				Endif
				rockManager.Update()
				ShootBullet()
				UpdateBullets()
				UpdateExplosions()
				nextState = EntityState.EXPLODING
			Case EntityState.EXPLODING
				If Not entityList.Empty
					If explodeTime+delay < Millisecs()
						Local entity := entityList.RemoveLast()
						entity.Explode(explosionList,explosionStore)
						explodeTime = Millisecs()
					Endif
				Endif
				UpdateBullets()
				UpdateExplosions()
			Case EntityState.ENDING
		End select
		Return True
	End Method
	
	Method Collided()
		If Not entityList.Empty
			Local entityLink := entityList.FirstNode()
			While entityLink.Value
				If entityLink.Value.Collided(player)
					entityLink.Value.Explode(explosionList,explosionStore)
					entityLink.Remove()
					player.Explode(explosionList,explosionStore)
				ElseIf Not playerManager.bulletList.Empty
					Local bulletLink := playerManager.bulletList.FirstNode()
					While bulletLink.Value
						If bulletLink.Value.Collided(entityLink.Value)
							bulletLink.Remove()
							entityLink.Remove()
							entityLink.Value.Explode(explosionList,explosionStore)
							Exit
						Endif
						bulletLink = bulletLink.Succ
					Wend
				Endif
				entityLink = entityLink.Succ
			Wend
		Endif
		
		If Not bulletList.Empty
			Local bulletLink := bulletList.FirstNode()
			While bulletLink.Value
				If bulletLink.Value.Collided(player)
					bulletLink.Remove()
					player.Explode(explosionList,explosionStore)
				Endif
				bulletLink = bulletLink.Succ
			Wend
		Endif
		If Not rockManager.rockList.Empty
			Local rockLink := rockManager.rockList.FirstNode()
			While rockLink.Value
				If player.Collided(rockLink.Value)
					player.Explode(explosionList,explosionStore)
					rockLink.Remove()
					Exit
				Elseif Not playerManager.bulletList.Empty
					Local bulletLink := playerManager.bulletList.FirstNode()
					While bulletLink.Value
						If bulletLink.Value.Collided(rockLink.Value)
							rockLink.Value.life -= 1
							If rockLink.Value.life < 1
								rockLink.Remove()
								rockLink.Value.Explode(explosionList,explosionStore)
								bulletLink.Remove()
							Else
								bulletLink.Remove()
							Endif
						Endif
						bulletLink = bulletLink.Succ
					Wend
				Endif
				rockLink = rockLink.Succ
			Wend
		Endif
	End method
	
	Method ShootBullet()
		If entityList.Empty Return
		Local link := entityList.FirstNode()
		While link.Value
	 		If link.Value.state = EntityState.UPDATING
				If shootTime < Millisecs()
					Local ufo := Cast<Ufo>(link.Value)
					If ufo.pos.x > (player.pos.x - 5) And ufo.pos.x < (player.pos.x + 5)
						Local bullet := bulletStore.GetItem()
						bullet.Set(ufo.pos.x,ufo.pos.y+40,Bullet.DOWN,7)
						bulletList.AddLast(bullet)
						shootTime = Millisecs() + 500
					Endif
				Endif
			Endif
			link = link.Succ
		Wend
	End Method	
		
	Method Render(canvas:Canvas)Override
		If Not entityList.Empty
			Local link := entityList.FirstNode()
			While link.Value
				Cast <Ufo>(link.Value).Render(canvas)
				link = link.Succ
			Wend
		Endif
		If Not bulletList.Empty
			Local blink := bulletList.FirstNode()
			While blink.Value
				Cast <Bullet>(blink.Value).Render(canvas)
				blink = blink.Succ
			Wend
		Endif
		canvas.Color = New Color(1,1,1,1)
		rockManager.Render(canvas)
		RenderExplosions(canvas)
		
		If Not rockManager.rockList.Empty
			Local rockLink := rockManager.rockList.FirstNode()
			While rockLink.Value
				If player.Collided(rockLink.Value)
					player.Explode(explosionList,explosionStore)
				Endif
				rockLink = rockLink.Succ
			Wend
		Endif




	End Method

End Class

