#import "jp-lib/jp-lib"

Using jplib..

'*****************************************************************************
'*						aliens												   *
'*****************************************************************************


Function GenerateAlienTiles:Image[]()
	Local img:Image[] = New Image[2]
	img[0] = GenerateSpiderTile2()
	img[1] = GenerateSpiderTile3()
	Return img
End Function

Function GenerateDroneTile:Image()
	Local img:Image = New Image(32,32)
	Local icanvas:Canvas = New Canvas(img)
	icanvas.Clear(New Color(0,0,0,0))
	icanvas.Color = New Color(1,1,1,.5)
	icanvas.DrawCircle(16,17,8)
	icanvas.Color = New Color(1,.1,0,1)
	icanvas.DrawOval(2,15,28,10)
	icanvas.Color = New Color(.5,.5,.5)
	icanvas.DrawRect(1,20,30,2)
	icanvas.DrawLine(2,28,10,25)
	icanvas.DrawLine(3,28,11,25)
	icanvas.DrawLine(30,28,22,25)
	icanvas.DrawLine(29,28,21,25)
	icanvas.DrawLine(7,8,10,10)
	icanvas.DrawLine(24,8,21,10)
	icanvas.Flush()
	img.Handle = New Vec2f(.5,.5)
	Return img
End Function

Function GenerateMissileTile:Image()
	Local img:Image = New Image(16,16)
	Local icanvas:Canvas = New Canvas(img)
	icanvas.Clear(New Color(0,0,0,0))
	icanvas.Color = New Color(.5,0,.5)
	icanvas.DrawPoly(New Float[](1.0,0,14,0,8,15,1,0))
	icanvas.Color= New Color(.2,.8,.2)
	icanvas.DrawOval(4,1,8,15)
	icanvas.Color = New Color(1,0,0)
	icanvas.DrawLine(4,11,12,11)
	icanvas.Flush()
	img.Handle = New Vec2f(.5,0)
	Return img
End Function


Class Missile Extends Entity
	field attachedPos:Vec2d
	Field entity:DroneInterface
	Field image:Image
	Field list:List<Missile>
	
	Method New()
		pos = New Vec2d
		vel = New Vec2d	
		attachedPos = New Vec2d
	End Method
	
	Method New(entity:DroneInterface,animation:Animation,offsetx:Float=0,offsety:Float=0 )
		pos = New Vec2d
		vel = New Vec2d
		attachedPos = New Vec2d
		Set(entity,animation,offsetx,offsety)
	End Method
	
	Method Set(entity:DroneInterface,animation:Animation,offsetx:Float=0,offsety:Float=0 )
		attachedPos = New Vec2d(offsetx,offsety)
		Self.animation = animation
		Self.entity = entity
		list = entity.GetMissileList()
		pos.Set(entity.GetPosition())
		shape = New HitBox(pos,-4,3,6,12)
		Self.image = image
	End Method
	
	Method Update:Bool() Override
		If  list.Empty
			pos.Set(entity.GetPosition()).Add(attachedPos)
		Else
			vel.Multiply(0,1.04)
			pos.Add(vel)
		Endif
		Return True
	End Method
	
	Method Render(canvas:Canvas) Override
		animation.Render(canvas,pos.x,pos.y)
		If displayHitBox
			shape.Render(canvas)
		Endif
	End Method
	
End Class

Interface DroneInterface
	Method GetPosition:Vec2d()
	Method GetMissileList:List<Missile>()
End Interface

Class Drone Extends Entity Implements DroneInterface
	Field speed:Float
	Field time:Int
	Field delay:Int
	Field paused:Bool
	Field offsetx:Float
	Field angle:Float
	Field done:Bool
	Field missile:Missile
	Field link:List<Missile>.Node
	Field shot:Bool
	Field missileList:List<Missile>
	Method New()
	End Method
	
	Method New(image:Image,missileList:List<Missile>)
		pos = New Vec2d(-50,120)
		dir = New Vec2d(-1,0)
		vel = New Vec2d(dir).Multiply(1.5)
		shape = New HitBox(pos,-14,-4,28,14)
		Local sprite:Sprite = New Sprite(image,4,4)
		Self.animation = New Animation
		Self.animation.AddFrame(sprite)
		delay = 2000
		sprite = New Sprite(GenerateMissileTile(),2,2)
		Local missileAnimation := New Animation
		missileAnimation.AddFrame(sprite)
		Self.missileList = missileList
		missile = New Missile(Self,missileAnimation,0,10)
		Reset()
	End Method
	
	Method GetPosition:Vec2d()
		Return pos
	End Method
	
	Method GetMissileList:List<Missile>()
		Return missileList
	End Method
	
	Method Reset()
		pos.Set(900,130)
		offsetx = Rnd(10,400)
		paused = False
		dead = False
		done = False
		missile.pos.Set(pos)
		missile.vel.Set(0,.1)
		shot = False
	End Method
	
	Method Update:bool()Override
		If dead = False
			If pos.x < -200
				dead = True
				link.Remove()
			Else
				If pos.x < 100+offsetx
					If Not paused
						paused = True
						time = Millisecs()
					Elseif time+delay < Millisecs()
						pos.Add(vel)
						If Not shot
							link = missileList.AddLast(missile)
							shot = True
						Endif
					Endif
					angle =(angle + .1)Mod 6.282
					pos.Add(0,Sin(angle)/6.0)
				Else
					angle =(angle + .1)Mod 6.282
					pos.Add(vel).Add(0,Sin(angle)/6.0)
				Endif
			Endif
			If missileList.Empty  missile.Update()
		Endif
		Return True
	End Method
	
	Method Render(canvas:Canvas) Override
		animation.Render(canvas,pos.x,pos.y)
		If shot = False missile.Render(canvas)
		If displayHitBox
			shape.Render(canvas)
		Endif
	End Method

End Class

Class Alien Extends Entity
	Field moveLeft:Vec2d
	Field moveRight:Vec2d
	Field moveDown:Vec2d
	Field done:Bool
	Global direction:Vec2d
	
	
	Const LEFT_SPEED:Int = -10
	Const RIGHT_SPEED:Int = 10
	Const DOWN_SPEED:Int = 8
	
	
	Method New()
	
	End Method
	
	Method New(animation:Animation,x:Float,y:Float)
		Self.animation = animation
		pos = New Vec2d(x,y)
		moveLeft = New Vec2d(LEFT_SPEED,0)
		moveRight = New Vec2d(RIGHT_SPEED,0)
		moveDown = New Vec2d(0,DOWN_SPEED)
		direction = moveRight
		shape = New HitBox(pos,-10.0,-10.0,20.0,20.0)
	End Method
	
	
	Method Set(animation:Animation,x:Float,y:Float)
		Self.animation = animation
		pos = New Vec2d(x,y)
		moveLeft  = New Vec2d(LEFT_SPEED,0)
		moveRight = New Vec2d(RIGHT_SPEED,0)
		moveDown  = New Vec2d(0,DOWN_SPEED)
		direction = moveRight
		shape = New HitBox(pos,-10.0,-10.0,20.0,20.0)
	End Method
	
	Method Update:Bool() Override
		done = False
		If pos.x > 500 And direction.x = moveRight.x 
			direction = moveLeft
			done = True
		Elseif pos.x < 90 And direction.x = moveLeft.x			
			direction = moveRight
			done = True
		Endif
		Return done
	End Method
	
	Method Move()
		animation.NextFrame()
		pos.Add(direction)
	End Method
	
	Method DropDown()
		pos.Add(moveDown)
	End Method
	
	Method Render(canvas:Canvas) Override
		animation.Render(canvas,pos.x,pos.y)
		If displayHitBox = True 
			shape.Render(canvas)
		Endif
	End Method
End Class
	
Class AlienManager Extends Manager

	Field time:Int
	Field delay:Int
	Field shootTime:Int
	Field shootDelay:Int
	Field stp:Float = .005
	Field alpha:Float
	Field done:Bool
	Field exploding:Bool
	Field explodeTime:Int
	Field explodeDelay:Int
	Field sprite:Sprite[]
	Field alienStore:Store<Alien>
	Field missileList:List<Missile>
	Field droneList:List<Drone>
	Field playerManager:PlayerManager
	Field terrain:Terrain
	
	Const ENTERING:Int = 1
	Const UPDATING:Int = 2
	Const EXPLODING:Int = 3
	Const DONE:Int = 4
	Const WAITING:Int = 5
	
	Method New()
	
	End Method	
	
	Method New(playerManager:PlayerManager,terrain:Terrain)
		Super.New()
		Self.playerManager = playerManager
		Self.player = playerManager.player
		Self.terrain = terrain
		Local alienImg:Image[] = GenerateAlienTiles()
		sprite = New Sprite[2]
		sprite[0] = New Sprite(alienImg[0],4,4)
		sprite[1] = New Sprite(alienImg[1],4,4)
		alienStore = New Store<Alien>(50)
		SetAliens()
		time = Millisecs()
		bulletList = New List<Bullet>
		bulletStore = New Store<Bullet>(50)
		done = False
		explodeTime= Millisecs()
		explodeDelay = 50
		state = WAITING
		Print "STATE WAITING"
		shootTime = Millisecs()
		shootDelay = 6000
		missileList = New List<Missile>
    	droneList = New List<Drone>
    	Local drone := New Drone(GenerateDroneTile(),missileList)
    	droneList.AddLast(drone)
	End Method
	
	Method SetAliens()
		For Local n:Int = 0 Until 5
			For Local i:int = 0 Until 8
				Local alien := alienStore.GetItem()
				animation = New Animation()
				animation.AddFrame(sprite[0])
				animation.AddFrame(sprite[1])
				alien.Set(animation,100+i*50, 150+n*30)
				alien.link = entityList.AddLast(alien)				
			Next
		Next
		shootTime = Millisecs()
		shootDelay = 6000
		delay  = 400
		alpha = 0
	End Method
	
	Method Update:Bool() Override
		
		select state
		 	Case WAITING
				If (shootTime +3000)<Millisecs()
					 state = ENTERING
					 Print "STATE ENTERING"
		 		Endif
				If Not droneList.Empty
					Local link := droneList.LastNode()
					While link.Value
						Local drone := link.Value
						If drone.pos.x < 620 drone.Update()
						If drone.dead drone.Reset()
						If Not missileList.Empty
							Local link := missileList.FirstNode()
							While link.Value
								Local nlink := link.Succ
								link.Value.Update()
								link = nlink
							Wend
						Endif
						link = link.Succ
					Wend
				Endif
		 	Case ENTERING
		 		If Not terrain.DoneTraversing()
					alpha += stp
					If alpha >= 1.0 
						alpha = 1.0
						state = UPDATING
						Print "STATE UPDATING"
					Endif
				Endif
				If Not droneList.Empty
					Local link := droneList.LastNode()
					While link.Value
						Local drone := link.Value
						If drone.pos.x < 620 drone.Update()
						If drone.dead drone.Reset()
						If Not missileList.Empty
							Local link := missileList.FirstNode()
							While link.Value
								Local nlink := link.Succ
								link.Value.Update()
								link = nlink
							Wend
						Endif
						link = link.Succ
					Wend
				Endif
			Case UPDATING
				If Not entityList.Empty
					If time + delay < Millisecs()
						Local alienLink := entityList.FirstNode()
						While alienLink.Value
							If alienLink.Value.Update() = True
								DropDown()
							Endif
							alienLink = alienLink.Succ
						Wend 
						alienLink = entityList.FirstNode()
						While alienLink.Value
							time = Millisecs()
							Cast<Alien>(alienLink.Value).Move()
							alienLink = alienLink.Succ
						Wend
					Endif
				Endif
				If Not droneList.Empty
					Local link := droneList.LastNode()
					While link.Value
						Local drone := link.Value
						drone.Update()
						If drone.dead drone.Reset()
						If Not missileList.Empty
							Local link := missileList.FirstNode()
							While link.Value
								Local nlink := link.Succ
								link.Value.Update()
								link = nlink
							Wend
						Endif
						link = link.Succ
					Wend
				Endif
				If entityList.Empty And explosionList.Empty
					SetAliens()
					state =WAITING
				Endif
				ShootBullet()
			Case EXPLODING
				If Not entityList.Empty
					If explodeTime+explodeDelay < Millisecs()
						Local alien := entityList.Last
						Local exp:Explosion = explosionStore.GetItem()
						exp.Set(animation.current.Value,alien.pos.x,alien.pos.y)
						explosionList.AddLast(exp)
						entityList.RemoveLast()
						explodeTime = Millisecs()
					Endif 
				Endif
		End Select
		If Not bulletList.Empty
			Local blink := bulletList.FirstNode()
			While blink.Value
				Local nlink := blink.Succ
				blink.Value.Update()
				If blink.Value.pos.y > 400
					blink.Remove()
				Endif
				blink = nlink
			Wend
		Endif
		UpdateExplosions()
		Return True
	End Method
	
	Method ShootBullet()
		If state = ENTERING  Return
		If Not entityList.Empty
			If shootTime + shootDelay > Millisecs() Return
			Local alienLink := entityList.LastNode()
			Local length:int = entityList.Count()
			Local shooter:Int
			If length > 16
				shooter = Rnd(16)
			Else
				shooter = Rnd(length)
			Endif
			Local count:Int = 0
			While alienLink.Value
				If count = shooter
					Local alien := Cast<Alien>(alienLink.Value)
					Local bullet := bulletStore.GetItem()
					bullet.Set(alien.pos.x,alien.pos.y+40,Bullet.DOWN,7)
					bulletList.AddLast(bullet)	
					shootDelay = 800
					Exit
				Endif
				count += 1
				alienLink = alienLink.Pred
				
			Wend
			shootTime = Millisecs()
		Endif
		If Not droneList.Empty
			Local link := droneList.FirstNode()
			While link.Value
				Local drone := link.Value
				If Not drone.dead
					If drone.paused
						If Not drone.done
							'shoot bullet
							drone.done = True
						Endif
					Endif
				Endif
				link = link.Succ
			Wend
		Endif
	End Method
	
	Method Remove()
		
	End Method	
	
	Method DropDown()
		If entityList.Empty Return
		Local link := entityList.LastNode()
		While link.Value
			Local alien := link.Value
			If alien.pos.y < 390
				Cast<Alien>(alien).DropDown()
				link = link.Pred
			Else
				Exit
			endif
		Wend
	End Method
	
	Method Collided()
		If state = UPDATING
			If Not playerManager.bulletList.Empty
				Local bulletLink := playerManager.bulletList.FirstNode()
				While bulletLink.Value
					If Not entityList.Empty
						Local entityLink := entityList.FirstNode()
						While entityLink.Value
							If bulletLink.Value.Collided(entityLink.Value)
								bulletLink.Remove()
								entityLink.Remove()
								delay += -9
								entityLink.Value.Explode(explosionList,explosionStore)
								Exit
							Endif
							entityLink = entityLink.Succ
						Wend
					Endif	
					bulletLink = bulletLink.Succ
				Wend
			Endif
		Endif
		If Not droneList.Empty
			If Not playerManager.bulletList.Empty
				Local droneLink := droneList.FirstNode()
				While droneLink.Value
					Local bulletLink := playerManager.bulletList.FirstNode()
					While bulletLink.Value
						If bulletLink.Value.Collided(droneLink.Value)
							droneLink.Value.Explode(explosionList,explosionStore)
							bulletLink.Remove()
							droneLink.Value.pos.x = -20
						Endif
						bulletLink = bulletLink.Succ
					Wend
					droneLink = droneLink.Succ
				Wend
			Endif
		Endif
		If Not missileList.Empty
			Local missileLink := missileList.FirstNode()
			While missileLink.Value
				Local y:Float = 384+terrain.land.GetHeightAtX(missileLink.Value.pos.x)
				If missileLink.Value.pos.y> y
					terrain.land.MakeHole(missileLink.Value.pos.x)
					missileLink.Remove()
				Elseif missileLink.Value.Collided(player)
					missileLink.Remove()
					player.Explode(explosionList,explosionStore)
					
				Endif
				missileLink = missileLink.Succ
			Wend
		Endif	
		If Not bulletList.Empty
			 Local bulletLink := bulletList.FirstNode()
			 While bulletLink.Value
			 	If bulletLink.Value.Collided(player)
			 		player.Explode(explosionList,explosionStore)
			 	endif	
			 	bulletLink = bulletLink.Succ
			 Wend
		Endif
	End method
	
	Method Render(canvas:Canvas) Override
		If Not entityList.Empty
			canvas.Color= New Color(1,1,1,alpha)
			Local alienLink := entityList.FirstNode()
			While alienLink.Value
				alienLink.Value.Render(canvas)
				alienLink = alienLink.Succ
			wend 
			If Not bulletList.Empty
				Local blink:List<Bullet>.Node = bulletList.FirstNode()
				While blink.Value
					blink.Value.Render(canvas)
					blink = blink.Succ
				Wend
			Endif
		Endif
		RenderExplosions(canvas)
		canvas.Color = New Color(1,1,1,1)
		If Not droneList.Empty
			Local link := droneList.FirstNode()
			While link.Value
				link.Value.Render(canvas)
				link = link.Succ
			Wend
		Endif
		If Not missileList.Empty
			Local link := missileList.FirstNode()
			While link.Value
				link.Value.Render(canvas)
				link = link.Succ
			Wend
		Endif
	End Method
	
End Class
	