

Class MotherShip Extends Entity

	Field destructible:Destructible
	Field rotator:Rotator
	
	Class Destructible
		Field pos:Vec2d
		Field strip:Deque<Int>
		Field offset:Vec2d
		Field width:Int
		Field hit1:Sprite
		Field y:Int[][]
	
		Const DAMAGE:Int = 6
		Const PW:Int = 2
		
		Method New(pos:Vec2d,width:int)
			Self.pos = pos
			strip = New Deque<Int>()
			For Local x:Int = -width/2+11 Until width/2-10 Step PW
				Local y:Float = Sqrt((400*400) - (x*x))*2 - 765
				If y > 64 y = 64
				strip.PushLast(y)
			Next
			offset = New Vec2d(-118,29)
			Self.width = width - 21
			Local img := New Image(16,16)
			img.Handle = New Vec2f(.5,.5)
			Local c := New Canvas(img)
			c.Color = New Color(1,1,0)
			c.DrawRect(0,0,16,16)
			c.Flush()
			hit1 = New Sprite(img,4,4)
			y = New Int[3][]
			y[0] = New Int[2]
			y[1] = New Int[2]
			y[2] = New Int[2]
		End Method
		
		Method Collision:Bool(bulletLink:List<Bullet>.Node,explosionList:List<Explosion>,explosionStore:Store<Explosion>)
			
			Local bulletPos := bulletLink.Value.pos
			Local index:Int = bulletPos.x - pos.x - offset.x+2
			If index >= 0 And index < width
				If bulletPos.y < (pos.y+offset.y+32) And bulletPos.y > (pos.y+offset.y-20)
					y[0][0] = -1
					y[0][1] = -1
					y[1][0] = -1
					y[1][1] = 0
					y[2][0] = -1
					y[2][1] = 1
					Local i:Int = index/PW
					If i > 0 y[0][0] = strip.Get(i+y[0][1])
					If i < (width/PW-1) y[2][0] = strip.Get(i+y[2][1])
					y[1][0] = strip.Get(i+y[1][1])
					For Local n := 1 To 3
						If y[2][0] < y[1][0] Then
							Local temp:Int[] = y[2]
							y[2] = y[1]
							y[1] = temp   	
							If y[1][0] < y[0][0]
								temp = y[1]
								y[1] = y[0]
								y[0] = temp
							Endif
						ElseIf y[1][0] < y[0][0]
							Local temp:Int[]= y[1]
							y[1] = y[0]
							y[0] = temp
						Endif
					Next
					Local ii:Int = 0
					If y[0][0] > 0 
						If bulletPos.y < (pos.y+offset.y + y[ii+2][0]) 
							y[ii+2][0] -= DAMAGE
							If y[ii+2][0] < 0 y[ii+2][0] = 0
							If (y[ii+2][0] - y[ii+1][0]) < DAMAGE  y[ii+1][0] = y[ii+2][0]
							If (y[ii+2][0] - y[ii  ][0]) < DAMAGE  y[ii+0][0] = y[ii+2][0]
							strip.Set(i+y[ii  ][1],y[ii  ][0])
							strip.Set(i+y[ii+1][1],y[ii+1][0])
							strip.Set(i+y[ii+2][1],y[ii+2][0])
							Local ex:=explosionStore.GetItem()
							ex.Set(hit1,bulletPos.x,bulletPos.y)
							explosionList.AddLast(ex)
							ex = explosionStore.GetItem()
							ex.Set(hit1,bulletPos.x,bulletPos.y)
							explosionList.AddLast(ex)
							ex = explosionStore.GetItem()
							ex.Set(hit1,bulletPos.x,bulletPos.y)
							explosionList.AddLast(ex)
							bulletLink.Remove()							
						Endif
					Elseif y[1][0] >0
						ii = 1
						If bulletPos.y < (pos.y+offset.y + y[ii+1][0])
							y[ii+1][0] -= DAMAGE
							If y[ii+1][0] < 0 y[ii+1][0] = 0
							If (y[ii+1][0] - y[ii][0]) < DAMAGE  y[ii][0] = y[ii+1][0]
							strip.Set(i+y[ii  ][1],y[ii  ][0])
							strip.Set(i+y[ii+1][1],y[ii+1][0])
							Local ex:=explosionStore.GetItem()
							ex.Set(hit1,bulletPos.x,bulletPos.y)
							explosionList.AddLast(ex)
							ex = explosionStore.GetItem()
							ex.Set(hit1,bulletPos.x,bulletPos.y)
							explosionList.AddLast(ex)
							ex = explosionStore.GetItem()
							ex.Set(hit1,bulletPos.x,bulletPos.y)
							explosionList.AddLast(ex)
							bulletLink.Remove()							
						Endif
					Elseif y[2][0] > 0
						ii = 2
						If bulletPos.y < (pos.y+offset.y + y[ii][0])
							y[ii][0] -= DAMAGE
							If y[ii][0] < 0 y[ii][0] = 0
							strip.Set(i+y[ii][1],y[ii][0])
							Local ex:=explosionStore.GetItem()
							ex.Set(hit1,bulletPos.x,bulletPos.y)
							explosionList.AddLast(ex)
							ex = explosionStore.GetItem()
							ex.Set(hit1,bulletPos.x,bulletPos.y)
							explosionList.AddLast(ex)
							ex = explosionStore.GetItem()
							ex.Set(hit1,bulletPos.x,bulletPos.y)
							explosionList.AddLast(ex)
							bulletLink.Remove()							
						Endif

					Endif	
				Endif
			Endif 
			Return False
		End Method
		
		Method Render(canvas:Canvas)
			Local x:Int = 0
			For Local y := Eachin strip
				canvas.DrawRect(x*PW+pos.x+offset.x,pos.y+offset.y,PW,y)
				x+=1
			Next		
		End method
	End Class
	
	Class Tris
		Field sides:Int
		Field y:Float
		
		Method New()
			sides = 2
			y = 12
		End Method
	End Class
	
	Class Rotator
		Field pos:Vec2d
		Field offset:Vec2d
		Field segs:Deque<Tris>
		
		Const PW:Int = 4
		
		Method New(pos:Vec2d)
			Self.pos = pos
			segs = New Deque<Tris>
			offset = New Vec2d(-116,16)
			For Local i := 0 until 232 Step PW
				segs.PushLast(New Tris())
			Next
		End Method
		
		Method Update()
			Local tris := segs.PopLast()
			segs.PushFirst(tris)
		End Method
		
		Method Collision(bulletLink:List<Bullet>.Node,explosionList:List<Explosion>,explosionStore:Store<Explosion>)
			
		End Method
		
		Method Render(canvas:Canvas)
			Local i:Int = 0
			For Local tris := Eachin segs
				canvas.Color = New Color(.2,.2,.5,1)
				canvas.DrawRect(pos.x+offset.x+i,pos.y+offset.y,PW,tris.y)
				If tris.sides = 2
					canvas.Color = New Color(.5,.5,0,1)
					canvas.DrawRect(pos.x+offset.x+i,pos.y+offset.y,PW,PW)
					canvas.DrawRect(pos.y+offset.x+i,pos.y+offset.y+PW*2,PW,PW)
				ElseIf tris.sides = 1
					canvas.DrawRect(pos.x+offset.x+i,pos.y+offset.y,PW,PW)
				Endif
				i += PW
			Next
		End Method
	End Class

	Method New()
		pos = New Vec2d(200,200)
		animation = New Animation()
		Local img:Image = GenerateMotherShipTile()
		animation.AddFrame(New Sprite(img,4,4))
		destructible = New Destructible(pos,img.Width)
		rotator = New Rotator(pos)
	End Method
	
	Function GenerateMotherShipTile:Image()
		Local img := New Image(256,128)
		img.Handle = New Vec2f(.5,.5)
		Local icanvas :=New Canvas(img)
		icanvas.Clear(New Color(0,0,.3,.0001))
		Local stps:Int = 20
		Local q:Float = Pi/stps
		Local poly:Float[] = New Float[stps*2-14]
		Local n:Int = 0
		For Local i:Int = 0 Until poly.Length Step 2
			poly[i]   = Cos(Pi+q*4+q*n) * 60+img.Width/2
			poly[i+1] = Sin(Pi+q*4+q*n) * 60+85
			n += 1
		Next
		icanvas.Color = New Color(1,1,1,.3)
		icanvas.DrawPoly(poly)
		icanvas.Color = New Color(0,1,1,.5)
		icanvas.DrawPoly(New Float[](80,50, 176,50, 176,60,80,60))
		icanvas.Color = New Color(0,0,1)
		icanvas.DrawPoly(New Float[](8,64+15, 40,48+15, 80,40+15, 176,40+15, 216,48+15, 248,64+15))
		icanvas.Color = New Color(1,0,0,.5)
'		icanvas.DrawPoly(New Float[](8,66+15,248,66+15,248,76+15,8,76+15))
	 	icanvas.Color = New Color(1,1,0,1)
		icanvas.Flush()
		Return img
	End Function
	
	Method Collision(bulletLink:List<Bullet>.Node,explosionList:List<Explosion>,explosionStore:Store<Explosion>)
		destructible.Collision(bulletLink,explosionList,explosionStore)
	End Method

	Method Update:Bool() Override
		Return True
	End Method
	
	Method Render(canvas:Canvas) Override
		animation.Render(canvas,pos.x,pos.y)
		canvas.Color = New Color(.7,.7,0,1)
		destructible.Render(canvas)
		rotator.Render(canvas)
	End Method

End Class

Class BossManager Extends Manager
	Field meteorManager:MeteorManager
	Field motherShip:MotherShip
	Field playerManager:PlayerManager
	
	Method New(terrain:Terrain,playerManager:PlayerManager)
		meteorManager = New MeteorManager(terrain)
		motherShip = New MotherShip()
		Self.playerManager = playerManager
	End Method
	
	Method Update:Bool() Override
		meteorManager.Update()
		UpdateExplosions()
		Local bulletList := playerManager.bulletList
		If Not bulletList.Empty
			Local bulletLink := bulletList.FirstNode()
			While bulletLink.Value
				motherShip.Collision(bulletLink,explosionList,explosionStore)
				
				bulletLink = bulletLink.Succ
			Wend
		End If
		Return True
	End Method
	
	Method Render(canvas:Canvas) Override
		meteorManager.Render(canvas)
		canvas.Color = New Color(1,1,1)
		motherShip.Render(canvas)
		RenderExplosions(canvas)
	End Method
	
End Class