'************************************************************************
'*						bullet											  *
'************************************************************************
#import "jp-lib/jp-lib"

Using jplib..

Class Bullet Extends Entity
  Field speed:Float
  Field direction:Int
  Field time:Int
  Field delay:int
  
  Const UP:Int   =1
  Const DOWN:Int =2
  Const LEFT:Int =3
  Const RIGHT:Int=4
  
  Method New()
    shape = New HitBox 
    Init()
  End Method

  Method New(x:Float,y:Float,direc:Int,speed:Float)
    Init()
    shape = New HitBox()
    Local angle:Float
    Select direc
    	Case DOWN
    		dir.Set(Cos(90.0*ATR),Sin(90*ATR))
    	Case LEFT
    		dir.Set(Cos(180.0*ATR),Sin(180.0*ATR))
    	Case RIGHT
    		dir.Set(Cos(0.0),Sin(0.0))
    	Case UP
    		dir.Set(Cos(270.0*ATR),Sin(180.0*ATR))
    End Select
   Self.direction = direc 
   time = Millisecs()
   delay = 400
  End Method

  Method Set(x:Float,y:Float,direc:Int,speed:Float)
    pos.Set(x,y)
    Local angle:Float
     Select direc
    	Case DOWN
    		dir.Set(Cos(90.0*ATR),Sin(90*ATR))
    	Case LEFT
    		dir.Set(Cos(180.0*ATR),Sin(180.0*ATR))
    	Case RIGHT
    		dir.Set(Cos(0.0),Sin(0.0))
    	Case UP
    		dir.Set(Cos(270.0*ATR),Sin(270.0*ATR))
    End Select
   
    vel.Set( dir.Multiply(speed))
    shape.Set(pos,-1,-1,6,6)
    Self.direction = direc
    time = Millisecs()
    delay = 400
  End Method
 
  Method Init()
    pos = New Vec2d
    vel = New Vec2d
    dir = New Vec2d
    
  End Method
  
  Method Time:Int()
  	Return Millisecs() - time
  End Method
  
  Method Update:Bool()Override
    pos.Add(vel)
    Return True
  End Method
  
  
  Method Render:void(canvas:Canvas) Override
    canvas.Color = New Color(195/255.0,93/255.0,87/255.0)
    Select direction
    	Case DOWN
    		canvas.DrawPoly(New Float[](pos.x,pos.y,pos.x+3,pos.y-30,pos.x+7,pos.y))
   		Case LEFT
   			canvas.DrawPoly(New Float[](pos.x+7,pos.y,pos.x+40,pos.y+3,pos.x+7,pos.y+7))
   		Case RIGHT
   			canvas.DrawPoly(New Float[](pos.x+3,pos.y,pos.x-30,pos.y+3,pos.x+3,pos.y+7))
   		Case UP 		
   			canvas.DrawPoly(New Float[](pos.x,pos.y+7,pos.x+3,pos.y+40,pos.x+7,pos.y+7))
	End Select
	canvas.Color = New Color(253/255.0,240/255.0,99/255.0)
   	canvas.DrawOval(pos.x,pos.y,7,7)
    canvas.Color = New Color(0,0,0)
    If displayHitBox shape.Render(canvas)
    canvas.Flush()
  End Method
  
  
End Class
