#import "jp-lib/jp-lib"

Using jplib..

Global particleStore:Store<Particle> = New Store<Particle>(100)

Class Particle  extends Entity
	Field speed:Float
	Field angle:Float
	Field time:Int
	Field delay:Int
	Field counter:Int
	Field duration:Int
	Field image:Image
	
	Method New()
		pos = New Vec2d()
		dir = New Vec2d()
		vel = New Vec2d()
	End Method
	
	Method New(image:Image,xi:Float,yi:Float,xp:Float,yp:Float)
		Self.pos = New Vec2d(xi,yi).Add(xp,yp)
		Self.speed = Rnd(1,5)
		Self.angle = Rnd(6.28)
		Self.duration = Rnd(5,50)
		Self.dir = New Vec2d(Cos(angle),Sin(angle))
		Self.vel = New Vec2d(dir).Multiply(speed)
		Self.image = image
		Self.counter = 0
	End Method
		
	Method Set(image:Image,xi:Float,yi:Float,xp:Float,yp:Float)
		Self.pos.Set(xi,yi).Add(xp,yp)
		Self.speed = Rnd(1,5)
		Self.angle = Rnd(6.28)
		Self.duration = Rnd(5,50)
		Self.dir.Set(Cos(angle),Sin(angle))
		Self.vel.Set(dir).Multiply(speed)
		Self.image = image
		Self.counter = 0		
	End Method
	
	Method Set2(image:Image,xi:Float,yi:Float,xp:Float,yp:Float)
		Self.pos.Set(xi,yi).Add(xp,yp)
		Self.speed = Rnd(1,5)
		Self.angle = Rnd(3.3,6.0)
		Self.duration = Rnd(5,50)
		Self.dir.Set(Cos(angle),Sin(angle))
		Self.vel.Set(dir).Multiply(speed)
		Self.image = image
		Self.counter = 0		
	End Method
	
	Method Update:Bool() Override
		If (time + delay) <= Millisecs()
			If counter < duration 
				pos.Add(vel)
				counter += 1
			Endif
		Endif
		Return True
	End Method
	
	Method Done:Bool()
		Return counter >= duration
	End Method
	
	Method Render:Void(canvas:Canvas)Override
		If counter < duration
			canvas.DrawImage(image,pos.x,pos.y)
		Endif
	End Method
	
End Class

Class Explosion Extends Entity

	Field frames:Int
	Field list:List<Particle> = New List<Particle>()
	
	Method New()
	End Method
	
	Method New(sprite:Sprite,x:Float,y:Float)
		For Local j:Int = 0 Until sprite.piecesDown
			Local idy:Int = j * sprite.piecesAcross
			For Local i:Int = 0 Until sprite.piecesAcross
				Local part:Particle = particleStore.GetItem()
				Local index:Int = idy+i
				part.Set(sprite.pieces[index],x,y,i*sprite.pieces[index].Width,j*sprite.pieces[index].Height)
				list.AddLast(part)
			Next
		Next
		Self.frames = frames
	End Method
	
	Method Set(sprite:Sprite,x:float,y:Float)
		For Local j:Int = 0 Until sprite.piecesDown
			Local idy:Int = j * sprite.piecesAcross
			For Local i:Int = 0 Until sprite.piecesAcross
				Local part:Particle = particleStore.GetItem()
				Local index:Int = idy+i
				part.Set(sprite.pieces[index],x,y,i*sprite.pieces[index].Width,j*sprite.pieces[index].Height)
				list.AddLast(part)
			Next
		Next
		Self.frames = frames
	End Method
	
	Method Set2(sprite:Sprite,x:float,y:Float)
		For Local j:Int = 0 Until sprite.piecesDown
			Local idy:Int = j * sprite.piecesAcross
			For Local i:Int = 0 Until sprite.piecesAcross
				Local part:Particle = particleStore.GetItem()
				Local index:Int = idy+i
				part.Set2(sprite.pieces[index],x,y,i*sprite.pieces[index].Width,j*sprite.pieces[index].Height)
				list.AddLast(part)
			Next
		Next
		Self.frames = frames
	End Method
	
	
'	Method Reset()
'		Local link := list.FirstNode()
'		While link 
'			Local anim:AnimationFrame
'			anim.Reset()
'			link = link.NextNode()
'		Wend
'	End Method
	
	Method Update:Bool()Override
		If list.Empty  Return False
		Local link := list.FirstNode()
		While link.Value	
			Local part := Cast<Particle>(link.Value)
			part.Update()
			Local ln := link.Succ
			If part.Done()
				link.Remove()
				particleStore.ReturnItem(part)
			Endif
			link = ln
		Wend
		Return True
	End Method
		
	Method Render:void(canvas:Canvas) Override
		If list.Empty Return
		Local link := list.FirstNode()
		canvas.Color = New Color(1,1,1,1)
		While link.Value
			Local part:Particle = Cast<Particle>(link.Value)
			part.Render(canvas)
			link = link.Succ
		Wend
	End Method
End Class	

