
'******************************************************************************
'*						Hills											   	  *
'******************************************************************************

Class Hills
	Field hillWidth:Float
	Field hillSlices:Int
	Field point:Float[]
	Field numHills:Int
	Field poly:Float[]
	Field offsetx:Float
	Field shiftx:Float
	Field pixShift:Float
	Field pixStep:Float
	Field speed:Float
	Field texImg:Image
	Field width:float
	
	Method New()
	
	End Method
    
	Method New(numberOfHills:int,pixelStep:Int,y:Float,v:Float,width:Float=3)
    pixStep = pixelStep
    numHills = numberOfHills
 		Local hillStartY:Float=100+y+Rnd(v)
		hillWidth=(680.0+pixelStep*2)/numberOfHills
		hillSlices=hillWidth/pixelStep
		point = New Float[numberOfHills*hillSlices]
		For Local i:int=0 until numberOfHills
			Local randomHeight:float=Rnd(v)
			If(i<>0) hillStartY -= randomHeight
			For Local j:Int = 0 until hillSlices
				point[(i*hillSlices)+j] = hillStartY+randomHeight*Cos(2*Pi/hillSlices*j)
			Next
			hillStartY = hillStartY+randomHeight
		Next
		offsetx = 0.0 
		poly = New Float[8] 
		texImg = TextureImage()
		Self.width = width
	End
  
	property Speed:Void(spd:Float)
  		speed = spd
	End
 
	Method Update:void()
		offsetx = (offsetx + speed) Mod (hillSlices * numHills * pixStep)
		shiftx = Int(offsetx/pixStep)
		pixShift = offsetx Mod pixStep
	End Method
 
	Method Render:Void(canvas:Canvas)
		Local b := canvas.Color.B
		Local g := canvas.Color.G
		Local r := canvas.Color.R
		Local a := canvas.Color.A
    	Local x:Float = 0
    	For Local j:Int = 0 to hillSlices* numHills
			poly[0] = x - pixShift
			poly[1] = point[(j+shiftx) Mod (hillSlices*numHills)]
			poly[2] = (x + pixStep) - pixShift
			poly[3] = point[((j+shiftx)+1) Mod (hillSlices*numHills)]
			poly[4] = (x + pixStep) -pixShift
			poly[5] = 480.0
			poly[6] = x - pixShift
			poly[7] = 480.0
			x = x+pixStep
			canvas.DrawPoly(poly)
			canvas.Color = New Color(0,1,.2)
			canvas.Alpha = .3
			DrawGlowLine(canvas,texImg,poly[0],poly[1]+1,poly[2],poly[3]+1,width)
			canvas.Alpha = 1.0
			canvas.Color = New Color(r,g,b,a)			
			canvas.BlendMode = BlendMode.Alpha
		Next
	End Method
End
