
#import "<mojo>"
#import "<std>"

Using mojo..
Using std..

' Globals And Constants
' ======================================================================
Const nP_MAX:Int = 32			' Maximum number of vertices For a poly

' ======================================================================
' Different objects
' ======================================================================
Class Vector
	Field x:Float
	Field y:Float
	
	Method New()
	
	End Method
	
	Method New(x:float,y:float)
		Self.x = x
		Self.y = y
	End Method
	
	Method Set(x:Float,y:Float)
		Self.x = x
		Self.y =y
	End Method
End Class


Class Point Extends Vector 
	Field off:Vector
	Field d:Vector
	Field angle:Float
	Field radius:Float
	Field red:Int
	Field green:Int
	Field blue:Int
	Field dir:Float
	Field life:Float
	Field DLife:Int
	
	
	Method New()
		off = New Vector()
		d = New Vector()
	End Method
	
	Method New(x:Float,y:Float)
		off = New Vector()
		d = New Vector()
		Self.x = x
		Self.y = y
	End Method
	
End Class

' Polygon

Class Poly
	Field x:Float
	Field y:float
	Field iN:Vector[]			' Vertices X position Y position
	Field fX:Vector[]			' Scaled And rotated X and Y position
	Field iVertexCount:Int		' Number of vertices
	Field fScale:Vector			' Scale
	Field fAngle:Float			' Angle rotation
	Field iMin:Vector			' Bounding box
	Field iMax:Vector			' Bounding box
	Field lateBoundingBoxCheck:Int =False
	' ======================================================================
	' Functions
	' ======================================================================

	' Creates a New empty polygon
	Method New ()
		fScale = New Vector(1,1)
		iMin = New Vector
		iMax = New Vector
		iN = New Vector[nP_MAX]	' Vertices X position Y position
		fX = New Vector[nP_MAX]	' Scaled And rotated X and Y position
		iVertexCount = 0
	End Method

	' ----------------------------------------------------------------------
	
	' Adds a vertex To a polygon
	Method AddVertex(x:Float, y:Float, bUpdate:Float = True)
		If iVertexCount > nP_MAX Then
			RuntimeError("Cannot add one more vertex to polygon!")
		Else
			iN[iVertexCount] = New Vector(x,y)
			fX[iVertexCount] = New Vector
			iVertexCount += 1
			If bUpdate Then
				Update()
			End If
		End If
	End Method

	Method returnvertices:Point[]()
		
		Local point := New Point[iVertexCount]
		For Local c:Int = 0 To iVertexCount-1
			point[c] = New Point(fX[c].x,fX[c].y) 
		Next
		Return point
		
	End Method

	' ----------------------------------------------------------------------
	' Checks If 2 polygons overlap each other
	
	Method Overlap:Int(poly2:Poly, bCheckBounding:Int = True)
	
		'Temp positions
		Local tx1:Float, ty1:Float, tx2:Float, ty2:Float, tx3:Float, ty3:Float, tx4:Float, ty4:Float
		Local xi:Float,yi:Float,xj:Float,yj:Float,nx:Float,ny:Float
		Local i:Int, j:Int, k:Int, c:Int
		' Checks bounding box first (If specified)
		If bCheckBounding Then	
			tx1 = x + iMin.x
			ty1 = y + iMin.y
			tx2 = x + iMax.x
			ty2 = y + iMax.y
			tx3 = poly2.x + poly2.iMin.x
			ty3 = poly2.y + poly2.iMin.y
			tx4 = poly2.x + poly2.iMax.x
			ty4 = poly2.y + poly2.iMax.y
			If Not (tx3 >= tx1 And ty3 >= ty1 And tx3 <= tx2 And ty3 <= ty2) Then
				If Not (tx4 >= tx1 And ty4 >= ty1 And tx4 <= tx2 And ty4 <= ty2) Then
					If Not (tx3 >= tx1 And ty4 >= ty1 And tx3 <= tx2 And ty4 <= ty2) Then
						If Not (tx4 >= tx1 And ty3 >= ty1 And tx4 <= tx2 And ty3 <= ty2) Then
							Return False
						End If
					End If
				End If
			End If
		End If
		For k = 0 To poly2.iVertexCount -1
			nx = poly2.fX[k].x+poly2.x
			ny = poly2.fX[k].y+poly2.y
			j = iVertexCount -1
			For i = 0 To iVertexCount - 1
   	    		xi = fX[i].x + x
				yi = fX[i].y + y
				xj = fX[j].x + x
				yj = fX[j].y + y
				If ((((yi<=ny) And (ny<yj)) Or ((yj<=ny) And (ny<yi))) And (nx < (xj - xi) * (ny - yi) / (yj - yi) + xi))
					c = Not c
				Endif
				j = i
   		 	Next
   		 	If c Return c
		Next
		For k=0 To iVertexCount -1
			nx = fX[k].x+x
			ny = fX[k].y+y
			j = poly2.iVertexCount - 1
			For i = 0 To poly2.iVertexCount - 1
    	   		xi = poly2.fX[i].x + poly2.x
				yi = poly2.fX[i].y + poly2.y
				xj = poly2.fX[j].x + poly2.x
				yj = poly2.fX[j].y + poly2.y
				If ((((yi<=ny) And (ny<yj)) Or ((yj<=ny) And (ny<yi))) And (nx < (xj - xi) * (ny - yi) / (yj - yi) + xi)) c = Not c
				j = i
    		Next
    		If c Return c
		Next
		Return False
	End Method

	' ----------------------------------------------------------------------

	Method OverlapsCircle:Int( iCircleX:Float, iCircleY:Float, iCircleRadius:Float, bCheckBounding:Float = True)
		' Temp positions
		Local tx1:Float, ty1:Float, tx2:Float, ty2:Float, tx3:Float, ty3:Float, tx4:Float, ty4:Float
		Local CX1:Float, CY1:Float, CX2:Float, CY2:Float, pX1:Float, pY1:Float, pX2:Float, pY2:Float, pXT:Float, pYT:Float
		' Delta calculations
		Local d1:Float, d2:Float, dX:Float, dY:Float, dSqr:Float
		' Checks bounding box first (If specified)
		If bCheckBounding Then
			tx1 = x + iMin.x
			ty1 = y + iMin.y
			tx2 = x + iMax.x
			ty2 = y + iMax.y
			tx3 = iCircleX - iCircleRadius
			ty3 = iCircleY - iCircleRadius
			tx4 = iCircleX + iCircleRadius
			ty4 = iCircleY + iCircleRadius
			If Not (tx3 >= tx1 And ty3 >= ty1 And tx3 <= tx2 And ty3 <= ty2) Then
				If Not (tx4 >= tx1 And ty4 >= ty1 And tx4 <= tx2 And ty4 <= ty2) Then
					If Not (tx3 >= tx1 And ty4 >= ty1 And tx3 <= tx2 And ty4 <= ty2) Then
						If Not (tx4 >= tx1 And ty3 >= ty1 And tx4 <= tx2 And ty3 <= ty2) Then
							Return False
						End If
					End If
				End If
			End If
		End If
		' Store the last vertex & circle
		Local lx:Float = fX[0].x + x
		Local ly:Float = fX[0].y + y
		CX2 = iCircleX
		CY2 = iCircleY
		' Cycle through all other vertices
		For Local i:Int = 0 To iVertexCount - 1	
			CX1 = fX[i].x + x
			CY1 = fX[i].y + y
			pX1 = lx - CX1
			pY1 = ly - CY1
			pX2 = CX2 - CX1
			pY2 = CY2 - CY1
			d1 = pX1 * pX2 + pY1 * pY2
			If d1 <= 0 Then
				dX = CX2 - CX1
				dY = CY2 - CY1
				dSqr = dX * dX + dY * dY
			Else
				d2 = pX1 * pX1 + pY1 * pY1
				If (d2 <= d1) Then
					dX = CX2 - lx
					dY = CY2 - ly
					dSqr = dX * dX + dY * dY
				Else
					d1 = d1 / d2
					pXT = CX1 + d1 * pX1
					pYT = CY1 + d1 * pY1
					dX = CX2 - pXT
					dY = CY2 - pYT
					dSqr = dX * dX + dY * dY
				End If
			End If
			If dSqr < iCircleRadius * iCircleRadius Then
				Return True
			End If
			lx = CX1
			ly = CY1
		Next
		Return False	
	End Method

' ----------------------------------------------------------------------
	Method  PointInPoly:Int(pointx:Float,pointy:Float,bCheckBounding:Int = True)
      
      	Local tx1:Float, ty1:Float, tx2:Float, ty2:Float
		Local xi:Float,yi:Float,xj:Float,yj:Float,nx:Float,ny:Float
		Local i:Int, j:Int, k:Int
		' Checks bounding box first (If specified)
		If bCheckBounding Then	
			tx1 = x + iMin.x
			ty1 = y + iMin.y
			tx2 = x + iMax.x
			ty2 = y + iMax.y
			If Not (pointx >= tx1 And pointy >= ty1 And pointx <= tx2 And pointy <= ty2) Then
				If Not (pointx >= tx1 And pointy >= ty1 And pointx <= tx2 And pointy <= ty2) Then
					If Not (pointx >= tx1 And pointy >= ty1 And pointx <= tx2 And pointy <= ty2) Then
						If Not (pointx >= tx1 And pointy >= ty1 And pointx <= tx2 And pointy <= ty2) Then
							Return False
						End If
					End If
				End If
			End If
		End If
		j = iVertexCount -1
		Local collided:Int = False
		For i = 0 To iVertexCount - 1
      	   	xi = fX[i].x + x
			yi = fX[i].y + y
			xj = fX[j].x + x
			yj = fX[j].y + y    
			If ((((yi<=pointy) And (pointy<yj)) Or ((yj<=pointy) And (pointy<yi))) And (pointx < (xj - xi) * (pointy - yi) / (yj - yi) + xi)) collided = Not collided
			j = i
      	Next
      	Return collided
		
	End Method
	
	' Scales the polygon by the specified scale
	Method Scale(sx:Float, sy:Float, bUpdate:Float = True)
		fScale.Set(fScale.x * sx, fScale.y * sy)
		If bUpdate Then
			Update()
		End If
	End Method
	
	' ----------------------------------------------------------------------
	
	' Resizes the polygon To the specieid scale
	Method Resize(sx:Float, sy:Float, bUpdate:Float = True)
		fScale.x = sx
		fScale.y = sy
		If bUpdate Then
			Update()
		End If
	End Method

	' ----------------------------------------------------------------------
	
	' Rotates the polygon by the specified rotation angle
	Method Rotate(fRot:Float, bUpdate:Float = True)
		fAngle += fRot
		If bUpdate Then
			Update()
		End If
	End Method

	' ----------------------------------------------------------------------
	
	' Turns the polygon To the specified angle
	Method FreeRotate(fAngle:Float, bUpdate:Float = True)
		Self.fAngle = fAngle
		If bUpdate Then
			Update()
		End If
	End Method
	
	' ----------------------------------------------------------------------
	
	' Updates the polygon according To scale And rotation
	Method Update()
		
		Local fX:Float, fY:Float, f1:Float, f2:Float
		Local i:Int
		' Set up big extremums
		iMin.Set( 9999999, 9999999)
		iMax.Set(-9999999,-9999999)
		' Find a valid collision setting
		For i = 0 To iVertexCount - 1
			' Standard data
			fX = iN[i].x
			fY = iN[i].y
			' Scale
			fX = fX * fScale.x
			fY = fY * fScale.y
			' Rotation
			If fAngle <> 0 Then
				f1 = Cos(fAngle) * fX - Sin(fAngle) * fY
				f2 = Sin(fAngle) * fX + Cos(fAngle) * fY
				fX = f1
				fY = f2
			End If
			' Final Values
			Self.fX[i].x = fX
			Self.fX[i].y = fY
			' Check For bounding box
			If fX < iMin.x Then iMin.x = fX
			If fY < iMin.y Then iMin.y = fY
			If fX > iMax.x Then iMax.x = fX
			If fY > iMax.y Then iMax.y = fY
			
		Next
	End Method
	
	' ----------------------------------------------------------------------
	
	' Draws the polygon on screen at the specified location
	Method Draw(canvas:Canvas,x:Float, y:Float, r:Int=255, g:Int=255, b:Int=255, bDrawBoundingBox:Int = True, br:Int=255, bg:Int=255, bb:Int=255)
		Local i:Int, lx:Float, ly:Float
		' Draw bounding box (If specified)
		If bDrawBoundingBox Then
			canvas.Color = New Color( br, bg, bb)
			Local x1:Int = iMin.x + x
			Local y1:Int = iMin.y + y
			Local x2:Int = iMax.x + x
			Local y2:Int = iMax.y + y
			canvas.DrawLine(x1,y1,x2,y1)
			canvas.DrawLine(x1,y1,x1,y2)
			canvas.DrawLine(x1,y2,x2,y2)
			canvas.DrawLine(x2,y1,x2,y2)
	'		DrawRect poly.iMinX + x, poly.iMinY + y, poly.iMaxX - poly.iMinX + 1, poly.iMaxY - poly.iMinY + 1
		End If	
		' Draw all the lines	
		canvas.Color = New Color( r, g, b)
		lx = fX[0].x + x
		ly = fX[0].y + y
		For i = 1 To iVertexCount - 1
			canvas.DrawLine(lx, ly, fX[i].x + x, fX[i].y + y)
			lx = fX[i].x + x
			ly = fX[i].y + y
		Next
	End Method
	
	' ----------------------------------------------------------------------
	
	' Copies a polygon And Return the newly created poly
	Method Copy:Poly()
		Local newPoly:Poly = New Poly
		Local i:Float
		' Copy point data
		For i = 0 To iVertexCount - 1
			newPoly.iN[i] = New Vector
			newPoly.fX[i] = New Vector
			newPoly.iN[i].x = iN[i].x
			newPoly.iN[i].y = iN[i].y
			newPoly.fX[i].x = fX[i].x
			newPoly.fX[i].y = fX[i].y
		
		Next
		' Copy all data
		newPoly.iVertexCount = iVertexCount
		newPoly.fScale.x = fScale.x
		newPoly.fScale.y = fScale.y
		newPoly.fAngle = fAngle
		newPoly.iMin.x = iMin.x
		newPoly.iMin.y = iMin.y
		newPoly.iMax.x = iMax.x
		newPoly.iMax.y = iMax.y
		Return newPoly
	End Method
	
	
End Class

' ----------------------------------------------------------------------
' Returns True If both circles overlap

Function CirclesOverlap:Int(x1:Float, y1:Float, rad1:Float, x2:Float, y2:Float, rad2:Float)
	
	Local dx:Float = x2 - x1
	Local dy:Float = y2 - y1
	Local rsqr:Float = rad1 + rad2
	rsqr = rsqr*rsqr
	Return (dx*dx+dy*dy < rsqr)

End Function
	
Function BouncePhysics(source:Vector,d1:Vector,radius1:Float,mass1:Float,dest:Vector,d2:Vector,radius2:Float,mass2:Float)

	'------------------------------------------
	' This is the main physics Function For the
	' circles. It contains the very basic
	' movement physics as well as the collision
	' response code.
	'------------------------------------------
	
	'------------------------------------------	
	'COLLISION CHECKING
	'------------------------------------------
	' Check each circle in the loop against every other (c against c2)
	
	Local collisionDistance:Float = radius1+radius2
	Local actualDistance:Float = Sqrt((dest.x-source.x)*(dest.x-source.x)+(dest.y-source.y)*(dest.y-source.y))

	'Collided Or Not?
	If actualDistance >= collisionDistance Then Return 

	Local collNormalAngle:Float=ATan2(dest.y-source.y, dest.x-source.x)
	
	'Position exactly touching, no intersection
	
	Local moveDist1:Float=(collisionDistance-actualDistance)*(mass1/(mass1+mass2))
	Local moveDist2:Float=(collisionDistance-actualDistance)*(mass1/(mass1+mass2))
	
	source.x += moveDist1*Cos(collNormalAngle+Pi)
	source.y += moveDist1*Sin(collNormalAngle+Pi)
	dest.x   += moveDist2*Cos(collNormalAngle)
	dest.y   += moveDist2*Sin(collNormalAngle)				
	
	'------------------------------------------	
	'COLLISION RESPONSE
	'------------------------------------------
	'n = vector connecting the centers of the circles.
	'we are finding the components of the normalised vector n
	
	Local nX:Float=Cos(collNormalAngle)
	Local nY:Float=Sin(collNormalAngle)
		
	'now find the length of the components of each movement vectors
	'along n, by using dot product.
	
	Local a1:Float = d1.x*nX + d1.y*nY
	Local a2:Float = d2.x*nX + d2.y*nY			
	
	'optimisedP = 2(a1 - a2)
	'             ----------
	'              m1 + m2
	
	Local optimisedP:Float = (2.0 * (a1-a2)) / (mass1 + mass2)
	
	'now find out the resultant vectors
	'r1 = v1 - optimisedP * mass2 * n
	
	d1.x -= (optimisedP*mass2*nX)
	d1.y -= (optimisedP*mass2*nY)
	
	'r2 = v2 - optimisedP * mass1 * n
	
	d2.x += (optimisedP*mass1*nX)
	d2.y += (optimisedP*mass1*nY)
	
End Function

Const Dlife:Int = 255
	
Class Debry
	Field point:Point
	Global pointList:List<Point>
	
	Method New()
		pointList = New List<Point>
	End Method
	
	Method addline(offx:Float,offy:Float,p:Point,p2:Point ,r:Int,g:Int,b:Int)

		point = New Point
		point.off.Set(offx,offy)
		point.Set( p.x,p.y)
		point.red = r
		point.green = g
		point.blue = b
		Local a:Float = Rnd(2*Pi)
		Local ra:Float = Rnd(3)
		point.d.x = Cos(a)*ra
		point.d.y = Sin(a)*ra
		Local width:Float = p.x - p2.x
		Local height:Float = p.y - p2.y
		point.angle = ATan2(height,width)
		point.DLife = Dlife
		point.radius = Sqrt(height*height+width*width)
		If Int(Rnd(0,1)+.5) Then point.dir = .5 Else point.dir = -.5
		pointList.AddLast(point)
		
	End Method 
	
	Method move()

		For Local d:Point = EachIn pointList
			If d.life > d.DLife 
				pointList.Remove(d)
			Else	
				d.x = d.x+d.d.x
				d.y = d.y+d.d.y
				d.angle += d.dir
				d.life+=2.0
			EndIf
		Next
	
	End Method
	
	Method draw(canvas:Canvas)
		
		For Local p:Point = EachIn pointList
			Local x2:Float = Cos(p.angle) * p.radius + p.x
			Local y2:Float = Sin(p.angle) * p.radius + p.y
			canvas.Alpha = ((p.DLife-p.life)/p.DLife)
			canvas.Color = New Color(10,10,10)
			canvas.DrawLine(p.off.x+p.x+5,p.off.y+p.y+5,p.off.x+x2+5,p.off.y+y2+5)
			canvas.Color = New Color(p.red, p.green,p.blue)
			canvas.DrawLine(p.off.x+p.x,p.off.y+p.y,p.off.x+x2,p.off.y+y2)
		Next
		
	End Method
		
End Class