Namespace jplib


Class Sprite Extends StoreObject
	Field image:Image
	Field pieces:Image[]
	Field piecesAcross:Int
	Field piecesDown:Int
	Field delay:Int = 300
	Field time:Int
	Field link:List<Sprite>.Node
	
	Global store:Store<Sprite>
	
	Method New()
	End Method
	
	Method New(image:Image,w:Int=2,h:Int=2)
		Set(image,w,h)
	End Method
	
	Method Set(image:Image,w:Int=2, h:Int=2)
		Self.image = image
		CutOut(w,h)
	End Method
	
	Method FrameDelay(delay:Int)
		Self.delay = delay
	End Method
	
	Method SetTime()
		time = Millisecs()
	End Method
	
	Method TimeExpired:Bool()
		Return (time + delay) < Millisecs()
	End Method
	
	Method CutOut(partWidth:Float=2,partHeight:Float=2)	
		piecesAcross = image.Width/partWidth
		piecesDown =image.Height/partHeight
		pieces = New Image[piecesAcross*piecesDown]
		For Local j:Int = 0 Until piecesDown
			Local y:Int = j*partHeight
			For Local i:Int = 0 Until piecesAcross
				Local x:Int = i*partWidth
				pieces[j*piecesAcross+i] = New Image(image,New Recti(x,y,x+partWidth, y+partHeight))
			Next
		Next
	End Method

End Class

class Animation Extends StoreObject
	Field frameList:List<Sprite>
	Field current:List<Sprite>.Node
	Field sprite:Sprite
	
	Global animationStore:Store<Animation>
	
	Method New()
		frameList = New List<Sprite>
		current = Null
	End Method
	
	Method AddFrame(sprite:Sprite,delay:Int=0)
		sprite.link = frameList.AddLast(sprite)
		sprite.FrameDelay(delay)
		If current = Null 
			current = sprite.link
			Self.sprite = sprite
		Endif
	End Method
	
	Method firstFrame:Sprite()
		Return Self.sprite
	End Method
	
	Method Init()
		current = frameList.FirstNode()
		current.Value.SetTime()
	End Method
	
	Method Update()
		If current.Value.TimeExpired()
			If current.Succ.Value
				current = current.Succ
				current.Value.SetTime()
			Else
				Init()
			Endif	
		Endif
	End Method
	
	Method GetFrameImage:Image()
		Return current.Value.image
	End Method
	
	Method GetFrameImagePieces:Image[]()
		Return current.Value.pieces
	End Method
	
	Method NextFrame()
		If current.Succ.Value
			current = current.Succ
		Else
			current = frameList.FirstNode()
		Endif
	End Method 
	
	Property CurrentFrame:Sprite()
		Return current.Value
	End Method
	
	Method Render(canvas:Canvas,x:float,y:Float,angle:Float=0)
		canvas.DrawImage(current.Value.image,x,y,angle)
	End Method
End Class
