
Namespace jplib

'*********************************************************
'*														 *
'* 			2d	Vector class 							 *
'*														 *
'*********************************************************

Class Vec2d
	Field x:Float
	Field y:Float
	
	Method New()
	
	End Method
	
	Method New(x:Float,y:Float)
		Set(x,y)
	End Method
	
	Method New(x1:Float,y1:Float,x2:Float,y2:Float)
		Set(x2-x1,y2-y1)
	End Method
	
	Method New(v:Vec2d)
		Set(v)
	End Method
	
	Method Set:Vec2d(v:Vec2d)
		x = v.x
		y = v.y
		Return Self
	End Method

	Method Set:Vec2d(x:Float,y:Float)
		Self.x = x
		Self.y = y
		Return Self
	End Method
		
	Method Add:Vec2d(x:Float,y:Float)
		Self.x += x
		Self.y += y
		Return Self
	End Method
	
	Method Add:Vec2d(v:Vec2d)
		Self.x += v.x
		Self.y += v.y
		Return Self
	End Method
	
	Method Add:Vec2d(value:Float)
		Self.x += value
		Self.y += value
		Return Self
	End Method
	
	Method Subtract:Vec2d(x:Float,y:Float)
		Self.x -= x
		Self.y -= y
		Return Self
	End Method
	
	Method Subtract:Vec2d(v:Vec2d)
		Self.x -= v.x
		Self.y -= v.y
		Return Self
	End Method
	
	Method Subtract:Vec2d(value:Float)
		Self.x -= value
		Self.y -= value
		Return Self
	End Method
	
	Method Multiply:Vec2d(x:Float,y:Float)
		Self.x *= x
		Self.y *= y
		Return Self
	End Method
	
	Method Multiply:Vec2d(v:Vec2d)
		Self.x *= v.x
		Self.y *= v.y
		Return Self
	End Method
	
	Method Multiply:Vec2d(value:Float)
		Self.x *= value
		Self.y *= value
		Return Self
	End Method
	
	Method Divide:Vec2d(x:Float,y:Float)
		Self.x /= x
		Self.y /= y
		Return Self
	End Method
	
	Method Divide:Vec2d(v:Vec2d)
		Self.x /= v.x
		Self.y /= v.y
		Return Self
	End Method
	
	Method Divide:Vec2d(value:Float)
		Self.x /= value
		Self.y /= value
		Return Self
	End Method
	
	Method DotProduct:Float(x:Float,y:Float)
		Return Self.x * x + Self.y * y
	End Method
	
	Method DotProduct:Float(v:Vec2d)
		Return Self.x * v.x + Self.y * v.y
	End Method
	
	Method PerpDotProduct:Float(x:Float,y:Float)
		Return Self.x * y - Self.y * x
	End Method
	
	Method PerpDotProduct:Float(v:Vec2d)
		Return Self.x * v.y - Self.y * v.x
	End Method
	
	Method MagnitudeSquare:Float()
		Return Self.x * Self.x + Self.y * Self.y
	End Method
	
	Method Magnitude:Float()
		Return Sqrt(MagnitudeSquare())
	End Method
	
	Method LeftNormal:Void()
		Local n:Float = y
		y = -x 
		x = n
	End Method
	
	Method RightNormal:Void()
		Local n:Float = y
		y = x
		x = -n
	End Method
	
	Method Normalize:Vec2d()
		Divide(Magnitude())
		Return Self
	End Method
		
	Method GetAngle:Float()
		Return ATan2(y,x)
	End Method
	
	Method SetAngle:Void(angle:Float)
		Local length:float = Magnitude()
		Local ang:Float =  ATan2(y,x) - angle
		
		x = length*Cos(angle+ang)
		y = length*Sin(angle+ang)
	End Method
	
	Method Rotate(angle:Float)
		Local cs:Float = Cos(angle)
		Local sn:Float = Sin(angle)
		
		Local tx:Float
		tx = x * cs - y * sn
		y =  x * sn + y * cs
		x = tx
	End Method
	
	Method ReverseX()
		x = -x
	End 
	
	Method ReverseY()
		y= -y
	End Method
	
	Method Reverse()
		x = -x
		y = -y
	End Method
	
	
	Method ToString:String()
		Return x+"  "+y
	End Method
	
	Method Draw:Void(x:Float,y:Float)
		'canvas.DrawLine(x,y,x+Self.x,y+Self.y)
	End Method
	
End Class

Function Projection:Vec2d(this:Vec2d,into:Vec2d,destination:Vec2d=Null)
	
	If destination = Null then destination = New Vec2d()
		
	Return destination.Set(into).Normalize().Multiply(destination.DotProduct(this))
	
End Function

Function CrossProjection:Vec2d(this:Vec2d,into:Vec2d,destination:Vec2d=Null)
	
	If destination = Null Then destination = New Vec2d()
	
	Return destination.Set(into.y,-into.x).Normalize().Multiply(destination.DotProduct(this))
		
End Function

