#import "jp-lib/jp-lib"


'*************************************************************
'*				terrain										   *
'*************************************************************

Function GenerateTerrainTile:Image()
    Local tile:Image = New Image(64,64)
    Local icanvas:Canvas = New Canvas(tile)
    icanvas.Clear(new Color(0,0,0,0))
    For Local x:Int = 0 Until tile.Width
      icanvas.Color = New Color(0,$78/Float($ff),0)
      For Local y:Int = 0 Until x
        icanvas.DrawPoint(y,x)
      Next
    Next
    icanvas.Flush()
    Return tile
End Function

Class Land
	Field pos:Vec2d
	Field land:Deque<Float>
	Field n:Int = 0
	Field dir:Float = Rnd(-2,2)
	Field dur:Int = Rnd(1,2)
	Field stp:Float = Rnd(-2,2)
	Field posy:Float = 32.0
	
	Field index:Float = 0
  
	Field terrainWidth:Float = 4017 
  	Field stripWidth:Float = 4
	Field viewWidth:Float = 160
  	Field minHeight:Float = 28
	
	Field terrainOffset:Float
	
	

	Field shift:Float = 20.0
	Field speed:Float
	
	Field tile:Image
	
	Field counter:Int
	
	Field done:Bool
	Field temp:float
	
	
	Method New()
		pos = New Vec2d
    	land = New Deque<Float>(terrainWidth)
    	tile = GenerateTerrainTile()
    
    	terrainOffset = terrainWidth - shift
        Init()
	End Method
	
	Method Init()
   		terrainOffset = terrainWidth - shift
    	pos.Set(0,384)
    	posy = 32.0    
		For Local i:Int = 0 Until terrainWidth
			If i < terrainOffset
				posy+=stp
				If posy < minHeight posy = minHeight
				If posy > (tile.Height-minHeight) posy = (tile.Height - minHeight)
				dur -= 1.0
				If dur <= 0.0
					dir = Rnd(-3,3)
					dur = Rnd(1,5)
					stp = Rnd(-1,1)
				Endif
			Else
				If stp > 0
					If posy < 32.0
						posy += stp
					Else
						posy -= stp
           			Endif
               	Elseif stp < 0
					If posy > 32.0
						posy += stp
					Else
						posy -= stp
					Endif
				Endif
			Endif
				land.Set(i,posy)
		Next
		done = False
		speed = 0
	
	End method
	
	Property Speed:Void(spd:Float)
		speed = spd
	End

	Method Update:void()
      	index = (index + speed)
      	If index >= land.Length
			done = True
      	Else
      		done = False
      	Endif 
      	index = index Mod land.Length
  		
  	End Method
  	
  	Method Start:Void()
  		index = 0
  		done = False
  	End Method
  
  
  	Method MakeHole(x:Float)
  		Local px:Int = (x/stripWidth)
  		If px < viewWidth
  			px = index + px
  			If index < land.Length-200 And index > 60
  				Local width:Float = Rnd(10,15)
  				Local radius:Float = width/2.0
  				For x = (-radius+1) Until radius
  					Local  y:Float = Sqrt((radius*radius) - (x*x))*stripWidth
  					land.Set(px+x,20+width+y)
  				Next
  			Endif
  		Endif
  	End Method
  	
  	Property  Done:Bool()
  		Return done
  	End Method
  	
  	Property  GetPosition:Int()
  		Return index
  	End 
  	
  	Property GetPercent:Float()
  		If done Return 1
  		Return index/land.Length
  	End
  	
	Method GetHeightAtX:Float(x:Float)
		Return land.Get(Int(index+(x/stripWidth)) Mod land.Length )
	End Method
  
  	Method Render:Void(canvas:Canvas)
    	For Local i:Float = 0 Until viewWidth
   			Local n:Float = land.Get((index+i) Mod land.Length)
      		canvas.DrawRect(i*stripWidth,pos.y,stripWidth,tile.Width,tile,n,0,1,tile.Height)
      		If n>=viewWidth 
 				Exit
	  		Endif
   		Next
   		canvas.Color= New Color(0,$78/Float($ff),0)
   		canvas.DrawRect(0,pos.y+64,640,32)
   		canvas.Color = New Color(1,1,1,1)
	End Method
  
End Class
