#import "patrol"

Class Level Abstract
	Field terrain:Terrain
	Field playerManager:PlayerManager
	
	Method New()
	
	End Method
	
	Method Update:int() Virtual
		Return 1
	End Method
	
	Method Render(canvas:Canvas) Virtual
	
	End Method
	
End Class

Class Stage1 Extends Level
	Field ufoManager:UfoManager
	
	Method New(terrain:Terrain,playerManager:PlayerManager)
		Self.terrain = terrain
		Self.playerManager = playerManager
		ufoManager = New UfoManager(playerManager,terrain)
	End Method
	
	Method Update:Int() Override
		playerManager.UpdateExplosions()
		If Not terrain.DoneTraversing()
			terrain.Update()
			playerManager.Update()
			ufoManager.Collided()
		Else
			playerManager.UpdateBullets()
		Endif
		If terrain.DoneTraversing()
			If ufoManager.state = EntityState.UPDATING
				ufoManager.SetNextState()
			Endif
		Endif
		ufoManager.Update()

		Return True
	End Method
	
	Method Render(canvas:Canvas) Override
		terrain.Render(canvas)
		playerManager.Render(canvas)
		ufoManager.Render(canvas)
	End Method
	
End Class


Class Stage2 Extends Level
	Field alienManager:AlienManager
	
	Method New(terrain:Terrain,playerManager:PlayerManager)
		Self.terrain = terrain
		Self.playerManager = playerManager
		alienManager = New AlienManager(playerManager,terrain)
	End Method
	
	Method Update:Int() Override
		playerManager.UpdateExplosions()
		If Not terrain.DoneTraversing()
			terrain.Update()
			playerManager.Update()
		Else
			playerManager.UpdateBullets()
			If alienManager.state = alienManager.UPDATING
				alienManager.state = alienManager.EXPLODING
			Endif
		Endif
		alienManager.Update()
		alienManager.Collided()
	
		Return True
	End Method
	
	Method Render(canvas:Canvas) Override
		terrain.Render(canvas)
		playerManager.Render(canvas)
		alienManager.Render(canvas)	
	End Method
	
End Class


Class Stage3 Extends Level
	Field spiderManager:SpiderManager

	Method New(terrain:Terrain,playerManager:PlayerManager)
		Self.terrain = terrain
		Self.playerManager = playerManager
		spiderManager = New SpiderManager(playerManager)
	End Method
	
	Method Update:Int()Override
		If Not terrain.DoneTraversing()
			terrain.Update()
			playerManager.Update()
			spiderManager.Update()
			spiderManager.Collided()
		Else
			playerManager.UpdateBullets()
		Endif
	
		Return 1
	End Method
	
	Method Render(canvas:Canvas) Override
		terrain.Render(canvas)
		playerManager.Render(canvas)
		spiderManager.Render(canvas)
	End Method

End Class


Class Stage4 Extends Level
	Field snakeManager:SnakeManager
	
	Method New(terrain:Terrain,playerManager:PlayerManager)
		Self.terrain = terrain
		Self.playerManager = playerManager
		snakeManager = New SnakeManager(playerManager,terrain)
	End Method
	
	Method Update:int() Override
		If Not terrain.DoneTraversing()
			terrain.Update()
			playerManager.Update()
			snakeManager.Update()
			snakeManager.Collided()
		Else
			playerManager.UpdateBullets()
		Endif
		Return 1
	End Method
	
	Method Render(canvas:Canvas)Override
		terrain.RenderHills(canvas)
		playerManager.Render(canvas)
		snakeManager.Render(canvas)
		terrain.RenderLand(canvas)
	End method	

End Class


Class BossStage Extends Level
	Field bossManager:BossManager
	Field playerManager:PlayerManager
	Field terrain:Terrain
	
	Method New(terrain:Terrain,playerManager:PlayerManager)
		Self.bossManager = New BossManager(terrain,playerManager)
		Self.playerManager = playerManager
		Self.terrain = terrain
	End Method
	
	Method Update:Int() Override
		If Not terrain.DoneTraversing()
			terrain.Update()
			bossManager.Update()
			playerManager.Update()
		Else
		
		Endif
	
		Return 1
	End Method
	
	Method Render(canvas:Canvas) Override
		terrain.RenderHills(canvas)
		bossManager.Render(canvas)
		playerManager.Render(canvas)
		terrain.RenderLand(canvas)
	End Method
	
End Class
