Interface CollideInterface
	
End Interface

Class Manager Abstract
	Field explosionList:List<Explosion>
	Field explosionStore:Store<Explosion>
 	Field bulletList:List<Bullet>
 	Field bulletStore:Store<Bullet>
 	Field entityList:List<Entity>
	Field state:Int
	Field nextState:int
	Field animation:Animation
	Field player:Entity
	
	Method New()
		Self.explosionList = New List<Explosion>
		Self.explosionStore = New Store<Explosion>
		Self.bulletList = New List<Bullet>
		Self.bulletStore = New Store<Bullet>(100)
		Self.entityList = New List<Entity>
	End Method
	
	
	
	Method Update:Bool() Virtual
		Return True
	End Method
	
	Method UpdateExplosions()
		If explosionList.Empty Return 
		Local link := explosionList.FirstNode()
		While link.Value
			If link.Value.Update() = False
				link.Remove()
			Endif
			link = link.Succ
		Wend
	End Method
	
	Method UpdateBullets()
		If bulletList.Empty Return
		Local link := bulletList.FirstNode()
 		While  link.Value <> Null
 			Local nlink := link.Succ
 			Local bullet:Bullet = link.Value
 			bullet.Update()
 			Select bullet.direction
 				Case bullet.DOWN
 					If bullet.pos.y > 400
						link.Remove()
						bulletStore.ReturnItem(bullet)
 					Endif
 				Case bullet.UP
 					If bullet.pos.y < 100
						link.Remove()
						bulletStore.ReturnItem(bullet)
 					Endif
 				Case bullet.RIGHT
 					If bullet.Time() > bullet.delay
 						link.Remove()
 						bulletStore.ReturnItem(bullet)
 					Endif
 			End Select
			link = nlink
		Wend
	End Method
	
		
	Method Render:void(canvas:Canvas) Abstract

	Method RenderBullets(canvas:Canvas)
		If bulletList.Empty return
		Local link := bulletList.FirstNode()
		While link.Value <> Null
			Local bullet := Cast<Bullet>(link.Value)
			bullet.Render(canvas)
			link  = link.Succ
		Wend
	End Method
	
	Method RenderExplosions(canvas:Canvas)
		If explosionList.Empty Return 
		Local link := explosionList.FirstNode()
		While link.Value
			Local exp:Explosion = link.Value
			exp.Render(canvas)
			link = link.Succ
		Wend	
	End Method

	
End Class

