#import "jp-lib/jp-lib"
Using jplib..

Function GenerateAsteroidTile:Image(frame:Int)
	Local tile1:Int = 0
	Local tile2:Int = 1
	Local tile3:Int = 2
	Local tile4:Int = 3
	Local img1:Float[] = New Float[](4.0,5, 21,1, 28,10, 30,16, 29,22, 23,30, 17,30, 9,28, 9,30, 7,30,	2,24, 7,18, 2,11, 2,8,3,6)
	Local img2:Float[] = New Float[](6.0,3, 11,6, 20,6, 25,9, 28,12, 30, 17, 29,25, 21,30, 6,30, 2,20, 3,7, 5,4)
	Local img3:Float[] = New Float[](10.0,7, 13,5, 23,4, 30,10, 30,23, 24,29, 6,28, 3,25, 3,19, 10,15, 10,12, 8,11, 9,7)
	Local img4:float[] = New Float[](6.0,5, 13,11, 21,5,24,5, 29,10, 26,14, 28,26, 23,29, 15,29, 10,27, 8,20, 6,20, 5,21, 4,21, 2,12) 
	Local tile:Image = New Image(32,32)
  	Local icanvas:Canvas = New Canvas(tile)
	icanvas.Clear(new Color(0,0,0,0))
	icanvas.Color= New Color(.4/255,.2,.2,1)
	Select frame
		Case tile1
			icanvas.DrawPoly(img1)
		Case tile2
			icanvas.DrawPoly(img2)
		Case tile3
			icanvas.DrawPoly(img3)
		Case tile4
			icanvas.DrawPoly(img4)
	 End Select
	icanvas.Flush()
	tile.Handle = new Vec2f(.5,.5)
	Return tile

End Function

Class Meteor extends Entity
	
	Field time:Int
	Field delay:Int
	
	Method New()
	
	End method
	
	Method New(animation:Animation,x:Float,y:Float)
		Set(animation,x,y)
	End Method
	
	Method Set(animation:Animation,x:Float,y:Float)
		Self.animation = animation
		pos = New Vec2d(x,y)  
		shape = New HitBox(pos,-14,-14,28,28)
	End Method
	
	Method Update:Bool() Override
		pos.Add(0,8)
		Return True
	End Method
	
	 Method Render:Void(canvas:Canvas) Override
		animation.Render(canvas,pos.x,pos.y)
		'If displayHitBox 
		shape.Render(canvas)
	End Method
End Class

Class MeteorManager Extends Manager
	Field time:Int
	Field delay:Int
	
	Const MIN_DELAY:Int = 500
	Const MAX_DELAY:Int = 1500
	
	Field meteorList:List<Meteor>
	Field meteorStore:Store<Meteor>
	Field terrain:Terrain
	Field animations:Animation[]
	
	Method New(terrain:Terrain)
		Super.New()
		meteorList = New List<Meteor>
		meteorStore = New Store<Meteor>(50)
		delay = Rnd(MIN_DELAY,MAX_DELAY)
		time = Millisecs()
		Self.terrain = terrain
		delay = Rnd(MIN_DELAY,MAX_DELAY)
		animations = New Animation[4]
		For Local i:int = 0 To 3
			animations[i] = New Animation
			animations[i].AddFrame(New Sprite(GenerateAsteroidTile(i),4,4))
		Next
		
	End Method
	
	Method Update:Bool() Override
		Local n:Int = terrain.GetPosition()
		If n > 800 and n < 3800
			If time+delay < Millisecs()
				Local meteor := meteorStore.GetItem()
				Local x:Int = 50+Int(Rnd(0,16))*32
				meteor.Set(animations[Rnd(0,3.99)],x,100)
				meteorList.AddLast(meteor)
				time = Millisecs()
				delay = Rnd(MIN_DELAY,MAX_DELAY)
			Endif
		Endif
		
		If Not meteorList.Empty
			Local link := meteorList.FirstNode()	
			While link.Value
				Local meteor := link.Value
				meteor.Update()
				Local nextLink := link.Succ
				If meteor.pos.y > 400
					link.Remove()
					terrain.MakeHole(meteor.pos.x)
					meteor.Explode(explosionList,explosionStore)
				Endif
				link = nextLink
			Wend	
		Endif
		UpdateExplosions()
		Return True
	End Method
	
	Method Collided:Bool()
			Local hit:Bool = False
			Local linkb := bulletList.FirstNode()
			While linkb
				Local bullet := linkb.Value
				Local linkNextb := linkb.Succ
				Local linkm := meteorList.FirstNode()
				While linkm
					Local meteor := Cast<Meteor>(linkm.Value)
					Local linkNextm := linkm.Succ
					If bullet.shape.Collided(meteor.shape)
						linkm.Remove()
						linkb.Remove()
						meteor.Explode(explosionList,explosionStore)
						Local exp:Explosion = explosionStore.GetItem()
						Exit
					Endif
					linkm = linkNextm
				Wend
				linkb = linkNextb
			Wend
			Return hit
	End Method
	
	Method Render:void(canvas:Canvas) Override
		If Not meteorList.Empty
			Local link := meteorList.FirstNode()
			While link.Value
				Local meteor := link.Value
				meteor.Render(canvas)
				link = link.Succ
			Wend	
		Endif
		RenderExplosions(canvas)
	End Method
	
		
		
End Class