
#import "jp-lib/jp-lib"

Using jplib..

Function GenerateRockTile:Image()
	Local img:Image = New Image(32,32)
	Local icanvas:Canvas = New Canvas(img)
	icanvas.Clear(New Color(0,0,0,0))
	icanvas.Color=New Color(.3,0,0)
	icanvas.DrawPoly(New Float[](5.0,27,4,17,5,15,6,12,7,12,8,8,11,5,18,5,23,9,23,10,25,12,25,15,26,16,26,18,29,19,28,30,27,31,7,31,6,30))
	icanvas.Flush()
	img.Handle = New Vec2f(0.5,0.5)
	Return img
End Function

Class Rock Extends Entity
	Field terrain:Terrain
	Field position:Int
	Field life:Int

	Method New()
		pos = New Vec2d
	End Method
	
	Method New(animation:Animation,x:Float,y:Float,offx:Float,offy:Float,width:Float,height:float,ter:Terrain)
		Set(animation,x,y,offx,offy,width,height,ter)
	End Method
	
	Method Set(animation:Animation,x:Float,y:Float,offx:float,offy:float,width:float,height:Float,ter:Terrain)
		Self.animation = animation
		pos.Set(x,y)
		terrain = ter
		position = terrain.land.GetPosition
		shape = New HitBox(pos, -offx, -offy,width,height)
		life = 2
	End Method 
	
	Method Update:Bool() Override
		Local newPosition := terrain.land.GetPosition
		pos.x -= (newPosition - position)* 4
		position = newPosition
		Return True
	End Method
	
	Method Render:void(canvas:Canvas)Override
		animation.Render(canvas,pos.x,pos.y)
		If life = 1
			Local a := canvas.BlendMode
			canvas.BlendMode = BlendMode.Additive
			animation.Render(canvas,pos.x,pos.y)
			canvas.BlendMode = a
		Endif	
		
		If displayHitBox shape.Render(canvas)
	End Method
	
End Class

Class RockManager Extends Manager
	Field rockList:List<Rock>
	Field rockStore:Store<Rock>
	Field terrain:Terrain
	Field time:Int
	Field delay:Int
	Field manager:Manager
	
	Method New()
	End method
	
	Method New(manager:Manager,terrain:Terrain)
		Super.New()
		rockList = New List<Rock>
		rockStore = New Store<Rock>(20)
		time = Millisecs()
		delay = 15000
		Self.terrain = terrain
		Self.animation = New Animation
		Self.animation.AddFrame(New Sprite(GenerateRockTile(),4,4))
		Self.manager = manager
	End Method
	
	Method Update:bool() Override
		If Not rockList.Empty
			Local link := rockList.FirstNode()
			While link.Value
				Local rock := Cast <Rock>(link.Value)
				rock.Update()
				link = link.Succ
			Wend
		Endif
		If time + delay < Millisecs()
			Local rock := rockStore.GetItem()
			Local y:Float = 370+terrain.land.GetHeightAtX(656)
			
			rock.Set(animation,656,y,10,8,16,22,terrain)
			rockList.AddLast(rock)
			delay = Rnd(800,3000)
			time = Millisecs()
		Endif
		If Not rockList.Empty
			Local link := rockList.FirstNode()
			While link.Value
				Local rock := Cast<Rock>(link.Value)
				Local nextLink := link.Succ
				If rock.pos.x < -32 Then
					link.Remove()
					rockStore.ReturnItem(rock)
				Endif
				link = nextLink
			Wend
		Endif
		UpdateExplosions()
		Return True
	End Method
	
	
	Method Render:void(canvas:Canvas)Override
		If Not rockList.Empty
			Local link := rockList.FirstNode()
			While link.Value
				Local rock := Cast<Rock>(link.Value)
				rock.Render(canvas)
				link = link.Succ
			Wend
		Endif
		RenderExplosions(canvas)
	End Method
	
End Class