'**************************************************************
'*				Snake									 	   *
'**************************************************************
#import "jp-lib/jp-lib"

Using jplib..

Function GenerateSnakeTile:Image()
	Local tile:Image = New Image(32,32)
	Local icanvas:Canvas = New Canvas(tile)
	icanvas.Clear(new Color(0,0,0,0))
	icanvas.Color =New Color(.1,.1,.1)
	tile.Handle = new Vec2f(0,0)
	icanvas.DrawCircle(16,16,13)
	icanvas.Color = New Color (.9,.1,.1)
	icanvas.DrawOval(16-13,16-8,26,16)
	icanvas.Color = New Color(0.1,.4,.9)
	icanvas.DrawPoly(New Float[](10.0,1, 15,1, 25,16, 15,32,10,32))
	icanvas.Color = New Color(0.1,.1,.9)
	icanvas.DrawPoly(New Float[](11.0,1, 16,1, 24,16, 16,31,11,31))
	tile.Handle = New Vec2f(.5,.5)
	icanvas.Flush()
	Return tile
End Function

Function GenerateEggTile2:Image()
	Local tile:Image = New Image(16,16)
	Local icanvas:Canvas = New Canvas(tile)
	icanvas.Clear(new Color(0,0,0,0))
	icanvas.Color =New Color(.1,.1,.1)
	icanvas.Color = New Color(0.8,.8,.6)
	icanvas.DrawOval(0,0,16,12)
	tile.Handle = New Vec2f(.5,.5)
	icanvas.Flush()
	Return tile
End Function

Global eggStore:Store<Egg> = New Store<Egg>(50)
Global eggList:List<Egg> = New List<Egg>

Class Egg Extends Entity
	Field vel:Vec2d
	Field angle:Float
	
	Method New()
		pos = New Vec2d()
		dir = New Vec2d()
		vel = New Vec2d()
	End Method

	Method Set(animation:Animation,x:float,y:Float)
	 	Self.animation = animation
	 	pos.Set(x,y)
	 	angle = 4.0 + Rnd(2)
	 	dir.Set(Cos(angle),Sin(angle))
	 	vel.Set(dir).Multiply(3)
	 	shape = New HitBox(pos,-6,-6,11,6)
		
	End Method

	Method New(animation:Animation,x:float,y:Float)
		pos = New Vec2d
		dir = New Vec2d
		vel = New Vec2d
		Set(animation,x,y)
	End Method
	 
	Method Update:Bool() Override
	 	vel.Add(0,.1)
	 	pos.Add(vel)
	 	Return True
	End Method
	 
	 Method Render(canvas:Canvas) Override
	 	animation.Render(canvas,pos.x,pos.y)
	 	If displayHitBox
	 		shape.Render(canvas)
	 	Endif
	 End Method
	 
End Class

Class Segment Extends Entity
	Field angle:Float
	
	Method New()
	End Method

	Method New(animation:Animation,x:Float,y:Float,ang:Float=0)
		Set(animation,x,y,angle)
	End Method
	
	Method Set(animation:Animation,x:Float,y:Float,ang:Float=0)
		Self.animation = animation
		pos = New Vec2d(x,y)
		shape = New HitBox(pos,-8,-8,16,16)
		angle = ang
	End Method

	Method Set(x:Float,y:Float,ang:Float)
		pos = New Vec2d(x,y)
		shape = New HitBox(pos,-8,-8,16,16)
		angle = ang
	End Method

	Method SetAngle(ang:Float)
		angle = ang
	End Method
	
	Method Render:void(canvas:Canvas) Override
		canvas.Color = New Color(1,1,1)
		animation.Render(canvas,pos.x,pos.y,angle)
		If displayHitBox
			shape.Render(canvas)
		Endif
	End Method
End Class

Global segmentStore:Store<Segment> = New Store<Segment>(50)

Class Snake Extends Entity
	Field dir1:Int
  	Field vel:Vec2d
  	Field dur:Int
	Field angle:Float
	Field distance:Float
	Field dir:Int = 1
	Field segmentList:List<Segment>
	
	Field active:Int
	Field Tint:Float
	Field XS:Float,YS:Float
	Field direction:Float
	Field turnSpeed:Float
	Field x:Float,y:Float
	Field tint:Float
	Field nx:Float,ny:Float
	Field time:Int
	Field delay:Int
	Field shootTime:Int
	Field shootDelay:Int
	Field eggAnimation:Animation

	Const MaxPoints:Float			= 20.0
	Const Acceleration:Float 		= 01.0
	Const TopSpeed:Float 			= 5.0
	Const TurnAcceleration:Float	= 0.1
	Const TurnMax:Float 			= 0.1
	Const SEGMENT_DISTANCE:Int 		= 10
	
	
	
	Method New()
		segmentList = New List<Segment>
		nx = 80 + Rnd(480)
		ny = 150 + Rnd(100)
		time = Millisecs()
		delay = Rnd(1000,3000)
		shootTime = Millisecs()
		shootDelay = Rnd(1000,2000)
	End Method
	
	Method New(x:Float,y:Float,animation:Animation,segments:Int,ang:Float)
		Set(x,y,animation,segments,ang)
	End Method
	
	Method Set(x:Float,y:Float,animation:Animation,segments:Int,ang:Float)
		segmentList = New List<Segment>
		For Local i:int = 0 Until segments
			Local segment:Segment = segmentStore.GetItem()
			segment.Set(animation,x+i*20,y,ang)
			segmentList.AddFirst(segment)
		Next
		angle = 0
		Self.animation = New Animation
		nx = 80 + Rnd(480)
		ny = 150 + Rnd(100)
		time = Millisecs()
		delay = Rnd(1000,3000)
		shootTime = Millisecs()
		shootDelay = Rnd(3000,5000)
	End Method
	
	Method Update:Bool() Override
		If segmentList.Empty Return True
		If delay+time < Millisecs()
			nx = 80 + Rnd(480)
			ny = 150 + Rnd(300)
			delay = Rnd(500,1000)
			time = Millisecs()
		Endif
		XS += Cos(direction)*Acceleration
		YS += Sin(direction)*Acceleration
		
		Local CurrentSpeed:Float = Sqrt(XS*XS + YS*YS)
		
		If CurrentSpeed > TopSpeed 
			XS += (XS/CurrentSpeed)*(TopSpeed - CurrentSpeed)
			YS += (YS/CurrentSpeed)*(TopSpeed - CurrentSpeed)
		Endif
		
		x += XS 
		y += YS 
				
		'Set Rotation
										
		Local distance:Float = Sqrt((x-nx)*(x-nx)+(y-ny)*(y-ny)) '
		Local TargetAngle:Float = (ATan2(y-ny,x-nx)+Pi) Mod TwoPi 		
		Local difference:Float = Abs(TargetAngle-direction)

		'turn toward target

		If TargetAngle < direction				
			If difference > Pi turnSpeed += TurnAcceleration Else turnSpeed -= TurnAcceleration
		ElseIf TargetAngle > direction
			If difference > Pi turnSpeed -= TurnAcceleration Else turnSpeed += TurnAcceleration
		Endif
		
		'If found stop turning
		
		If difference < 0.5 turnSpeed = 0.0			
				
		'Limit TurnSpeed

		If turnSpeed >  TurnMax turnSpeed =  TurnMax
		If turnSpeed < -TurnMax turnSpeed = -TurnMax
		direction = (direction+turnSpeed+TwoPi) Mod TwoPi
		local seg := segmentList.First
		Local vx:float = seg.pos.x - x
		Local vy:Float = seg.pos.y - y
		If Sqrt(vx*vx+vy*vy) > SEGMENT_DISTANCE
			seg =  segmentList.RemoveLast()
			seg.pos.Set(x,y)
			seg.SetAngle(ATan2(vx,vy)+1.7)
			segmentList.AddFirst(seg)
		Endif
		
		If Not segmentList.Empty
			If shootTime+shootDelay < Millisecs()
				seg = segmentList.Last
				Local eg := eggStore.GetItem()
				eg.Set(eggAnimation,seg.pos.x,seg.pos.y)
				eg.animation = eggAnimation
				eggList.AddLast(eg)
				shootTime = Millisecs()
			Endif
		Endif
		Return true
	End Method
	
	Method Render:void(canvas:Canvas) Override
		If segmentList.Empty Return
		Local link:List<Segment>.Node = segmentList.FirstNode()
		While link.Value
			Cast<Segment>(link.Value).Render(canvas)
			If displayHitBox Cast<Segment>(link.Value).shape.Render(canvas)
			link = link.Succ
		Wend
	End Method
	
	
	
End Class

Class SnakeManager Extends Manager
	Field snakeList:List<Snake>
	Field snakeStore:Store<Snake>
	Field time:Int
	Field delay:Int
	Field snakeAnimation:Animation
	Field count:Int
	Field eggAnimation:Animation
	Field exploding:Bool
	Field doneExploding:Bool
	Field playerManager:PlayerManager
	Field terrain:Terrain
		
	Const ENTERING:Int = 1
	Const UPDATING:Int = 2
	Const EXPLODING:Int = 3
	Const DONE:Int = 4
	Const WAITING:Int = 5

	
	Method New(playerManager:PlayerManager,terrain:Terrain)
		Super.New()
		Self.terrain = terrain
		snakeList = New List<Snake>
		snakeStore = New Store<Snake>
		Self.explosionList = explosionList
		Self.explosionStore = explosionStore
		Local sprite:Sprite  = New Sprite(GenerateSnakeTile(),4,4)
		Self.playerManager = playerManager
		snakeAnimation = New Animation
		snakeAnimation.AddFrame(sprite)
		time = Millisecs()
		sprite = New Sprite(GenerateEggTile2())
		eggAnimation = New Animation
		eggAnimation.AddFrame(sprite)
		state = WAITING
		delay = 5000
		count = 0
	End Method
	
	
	Method Update:Bool() Override
	
	
	
		Select state
			Case WAITING
				If time + delay < Millisecs()
					state = ENTERING
				Endif
			Case ENTERING
				Local snake:Snake = New Snake(-350.0,50.0,snakeAnimation,18,45)
				snake.eggAnimation = eggAnimation
				snakeList.AddLast(snake)
				state = UPDATING
			Case UPDATING
				If not snakeList.Empty
					Local snakeLink := snakeList.FirstNode()
					While snakeLink.Value
						snakeLink.Value.Update()
						snakeLink = snakeLink.Succ
					Wend
				Else
					time = Millisecs()
					state = WAITING
				Endif

			Case EXPLODING
				If Not snakeList.Empty
					If time + delay < Millisecs()
						Local snake := snakeList.Last
					Endif
				Endif
				
		End Select
		
		If Not eggList.Empty
			Local linke := eggList.FirstNode()
			While linke.Value
				linke.Value.Update()
				linke = linke.Succ
			Wend
		Endif
		
		UpdateExplosions()					
		Return True
	End Method
	

	Method Collided()
		If Not playerManager.bulletList.Empty
			Local bulletLink := playerManager.bulletList.FirstNode()
			While bulletLink.Value
				Local bullet := bulletLink.Value
				If CollidedSegment(bullet)
					bulletLink.Remove()
				Elseif Not eggList.Empty
					Local eggLink := eggList.FirstNode()
					While eggLink.Value
						If bullet.Collided(eggLink.Value)
							eggLink.Remove()
							bulletLink.Remove()
							eggLink.Value.Explode(explosionList,explosionStore)
						Endif
						eggLink = eggLink.Succ
					Wend					
				Endif
				bulletLink = bulletLink.Succ
			Wend
		Endif
		If Not eggList.Empty
			Local eggLink := eggList.FirstNode()
			While eggLink.Value
				Local egg := eggLink.Value
				Local y:Float = terrain.GetLandHeightAtX(egg.pos.x)
				If egg.pos.y > y
					eggLink.Remove()
					egg.Explode(explosionList,explosionStore)
				Elseif egg.Collided(playerManager.player)
					eggLink.Remove()
					egg.Explode(explosionList,explosionStore)
					playerManager.player.Explode(playerManager.explosionList,playerManager.explosionStore)
				Endif
				eggLink = eggLink.Succ
			Wend
		Endif
	End Method
	
	Method CollidedSegment:Bool(bullet:Bullet)
				If Not snakeList.Empty
					Local snakeLink := snakeList.FirstNode()
					While snakeLink.Value
						if Not snakeLink.Value.segmentList.Empty
							Local segmentLink := snakeLink.Value.segmentList.FirstNode()
							While segmentLink.Value
								If bullet.Collided(segmentLink.Value)
									segmentLink.Remove()
									segmentLink.Value.Explode(explosionList,explosionStore)
									segmentLink = segmentLink.Succ
									sfx.PlayExplosion1()
									If segmentLink.Value
										Local snake := New Snake
										snake.animation = snakeAnimation
										snake.eggAnimation = eggAnimation
										snake.x = segmentLink.Value.pos.x
										snake.y = segmentLink.Value.pos.y								
										While segmentLink.Value
											segmentLink.Remove()
											snake.segmentList.AddLast(segmentLink.Value)
											segmentLink = segmentLink.Succ
										Wend

										If Not snake.segmentList.Empty
											snakeList.AddLast(snake)
										Endif
									Endif
									If snakeLink.Value.segmentList.Empty
										snakeLink.Remove()
									Endif
									Return True
								Endif
								segmentLink = segmentLink.Succ
							Wend
						Endif
						snakeLink = snakeLink.Succ
					Wend
				Endif
			Return False
	End Method
	
	Method Render:void(canvas:Canvas) Override
		If Not snakeList.Empty
			Local link := snakeList.FirstNode()
			While link.Value
				link.Value.Render(canvas)
				link= link.Succ
			Wend
		Endif
		If Not eggList.Empty
			Local link := eggList.FirstNode()
			While link.Value
				link.Value.Render(canvas)
				link = link.Succ
			Wend
		Endif
		RenderExplosions(canvas)
	End Method
	
End Class
