#import "jp-lib/jp-lib"

Using jplib..

Function GenerateMotherTile:Image()
  Local tile:Image = New Image(32,32)
  Local icanvas:Canvas = New Canvas(tile)
  icanvas.Clear(new Color(0,0,0,0))
  icanvas.Color = New Color(253.0/255,253.0/255.0,253.0/255)
  icanvas.DrawRect(9,1,4,3)
  icanvas.DrawRect(20,1,4,3)
  icanvas.Color = New Color(189.0/255,43.0/255,198.0/255)
  icanvas.DrawRect(13,4,7,3)
  icanvas.DrawRect(2,14,28,4)
  icanvas.DrawRect(13,4,7,3)
  icanvas.Color = New Color(82.0/255,134.0/255,154.0/255)
  icanvas.DrawRect(5,7,22,2)
  icanvas.DrawRect(5,23,22,2)
  icanvas.Color = New Color(43.0/255,198.0/255,131.0/255)
  icanvas.DrawRect(2,9,28,3)
  icanvas.DrawRect(2,20,28,3)
  icanvas.Color = New Color(217.0/255,93.0/255,10.0/255)
  icanvas.DrawRect( 5,12,3,2)
  icanvas.DrawRect(13,12,3,2)
  icanvas.DrawRect(20,12,3,2)
 
  icanvas.Color = New Color(217.0/255,93.0/255,10.0/255)
  icanvas.DrawRect(8,18,4,2)
  icanvas.DrawRect(15,18,4,2)
  icanvas.DrawRect(23,18,4,2)
  icanvas.Color = new Color(189.0/255,43.0/255,198.0/255)
  icanvas.DrawRect(13,25,7,3)
  icanvas.Color = new Color(174.0/255,198.0/255,43.0/255)
  icanvas.DrawRect(9,28,4,3)
  icanvas.DrawRect(20,28,4,3)
  tile.Handle = New Vec2f(.5,.5)
  icanvas.Flush()
  Return tile
End Function

Function GenerateSpiderTile1:Image()
  Local tile:Image = New Image(32,32)
  Local icanvas:Canvas = New Canvas(tile)
  icanvas.Clear(new Color(0,0,0,0))
  icanvas.Color = new Color(243.0/255,240.0/255.0,8.0/255)
  icanvas.DrawRect(2,5,4,2)
  icanvas.DrawRect(26,6,4,2)
  icanvas.Color = new Color(120.0/255,172.0/255,82.0/255)
  icanvas.DrawRect(6,7,3,2)
  icanvas.DrawRect(23,7,3,2)
  icanvas.DrawRect(9,9,3,4)
  icanvas.DrawRect(20,9,3,4)
  icanvas.Color = new Color(174.0/255,198.0/255,43.0/255)
  icanvas.DrawRect(12,13,8,2)
  icanvas.Color = new Color(82.0/255,134.0/255,154.0/255)
  icanvas.DrawRect(9,15,14,2)
  icanvas.Color = new Color(48.0/255,176.0/255,184.0/255)
  icanvas.DrawRect(9,17,14,2)
  icanvas.DrawRect(12,19,8,2)
  icanvas.Color = new Color(120.0/255,172.0/255,82.0/255)
  icanvas.DrawRect( 9,21,3,4)
  icanvas.DrawRect(20,21,3,4)
  icanvas.DrawRect(6,25,3,2)
  icanvas.DrawRect(23,25,3,2)
  icanvas.Color = new Color(217.0/255,93.0/255,10.0/255)
  icanvas.DrawRect(2,27,4,2)
  icanvas.DrawRect(26,27,4,2)
  tile.Handle=New Vec2f(.5,.5)
  icanvas.Flush()
  Return tile
End Function

Function GenerateSpiderTile2:Image()
  Local tile:Image = New Image(32,32)
  tile.Handle = New  Vec2f(.5,.5)
  Local icanvas:Canvas = New Canvas(tile)
  icanvas.Clear(new Color(0,0,0,0))
  icanvas.Color = new Color(274.0/255,198.0/255.0,43.0/255)
  icanvas.DrawRect(0,3,8,2)
  icanvas.DrawRect(24,3,8,2)
  icanvas.Color = new Color(253.0/255,253.0/255.0,253.0/255)
  icanvas.DrawRect(8,5,4,3)
  icanvas.DrawRect(20,5,4,3)
  icanvas.Color = new Color(174.0/255,198.0/255.0,43.0/255)
  icanvas.DrawRect(12,8,8,3)
  icanvas.DrawRect(4,11,24,2)
  icanvas.Color = new Color(198.0/255,43.0/255,94.0/255)
  icanvas.DrawRect(0,13,4,2)
  icanvas.DrawRect(12,13,8,2)
  icanvas.DrawRect(28,13,4,2)
  icanvas.DrawRect(8,15,16,3)
  icanvas.Color = new Color(274.0/255,198.0/255.0,43.0/255)
  icanvas.DrawRect(4,18,4,3)
  icanvas.DrawRect(12,18,8,3)
  icanvas.DrawRect(24,18,4,3)
  icanvas.DrawRect( 0,21,4,3)
  icanvas.DrawRect(8,21,4,3)
  icanvas.DrawRect(20,21,4,3)
  icanvas.DrawRect(28,21,4,3)
  icanvas.DrawRect(4,24,4,3)
  icanvas.DrawRect(24,24,4,3)
  icanvas.Color = new Color(43.0/255,198.0/255.0,131.0/255)
  icanvas.DrawRect(8,27,4,3)
  icanvas.DrawRect(20,27,4,3)
  icanvas.Flush()
  Return tile
	
End Function

Function GenerateSpiderTile3:Image()
  Local tile:Image = New Image(32,32)
  Local icanvas:Canvas = New Canvas(tile)
  icanvas.Clear(New Color(0,0,0,0))
  icanvas.Color = new Color(274.0/255,198.0/255.0,43.0/255)
  icanvas.DrawRect(0,1,2,2)
  icanvas.DrawRect(30,1,2,2)
  icanvas.DrawRect(2,3,4,2)
  icanvas.DrawRect(26,3,4,2)
  icanvas.DrawRect(6,5,4,2)
  icanvas.DrawRect(22,5,4,2)
  icanvas.Color = new Color(253.0/255,253.0/255,253.0/255)
  icanvas.DrawRect(10,7,3,3)
  icanvas.DrawRect(19,7,3,3)
  icanvas.Color = new Color(174.0/255,198.0/255.0,43.0/255)
  icanvas.DrawRect(13,10,6,3)
  icanvas.DrawRect(0,13,32,2)
  icanvas.Color = new Color(198.0/255,43.0/255.0,94.0/255)
  icanvas.DrawRect(10,15,12,3)
  icanvas.DrawRect(2,18,28,2)
  icanvas.Color = new Color(274.0/255,198.0/255.0,43.0/255)
  icanvas.DrawRect(0,20,2,2)
  icanvas.DrawRect(13,20,6,3)
  icanvas.DrawRect(30,20,2,2)
  icanvas.DrawRect(10,23,3,2)
  icanvas.DrawRect(19,23,3,2)
  icanvas.DrawRect(6,25,4,2)
  icanvas.DrawRect(22,25,4,3)
  icanvas.Color = new Color(43.0/255,198.0/255.0,131.0/255)
  icanvas.DrawRect(3,27,3,4)
  icanvas.DrawRect(26,27,3,4)
  tile.Handle = New Vec2f(.5,.5)
  icanvas.Flush()
  Return tile
	
End Function

Function GenerateEggTile:Image()
  Local tile:Image = New Image(32,32)
  Local icanvas:Canvas = New Canvas(tile)
  icanvas.Clear(new Color(0,0,0,0))
  icanvas.Color = new Color(189.0/255,43.0/255.0,198.0/255)
  icanvas.DrawRect(11,6,10,2)
  icanvas.DrawRect(8,8,16,3)
  icanvas.DrawRect(8,20,16,3)
  icanvas.DrawRect(11,23,10,2)
  icanvas.Color = new Color(198.0/255,43.0/255,94.0/255)
  icanvas.DrawRect(4,11,4,9)
  icanvas.DrawRect(10,13,13,5)
  icanvas.DrawRect(24,11,4,9)
  icanvas.Flush()
  Return tile
	
End Function


Class Spider Extends Entity
	
	Field time:Int
	Field delay:Int
	Field stime:Int
	Field sdelay:Int
	Field speed:Float
	
	Const BOTTOM:Float = 350
	Const LEFT:Float = 50
	Const RIGHT:Float = 600
	Const TOP:Float = 100

	Const MAX_SPEED:Float = 5
	Const FRAME_DELAY:Int = 300
	
	Method New()
	
	End Method
	
	Method New(animation:Animation,x:Float,y:Float)
		Set(animation,x,y)
	End Method
	
	Method Set(animation:Animation,x:Float,y:Float)
		pos = New Vec2d(x,y)
		speed = MAX_SPEED
		Local angle:Float = 40
		dir = New Vec2d(Cos(angle)*speed,Sin(angle)*speed)
		Self.animation =  animation
		shape = New HitBox(pos,-10,-10,20,20)		
		sdelay = 1000
	End Method
		
	Method Update:Bool() Override
		If time + delay < Millisecs()
			Local n:Int = Rnd(0,2)
			Select n
				 Case 0
				 	dir.ReverseX()
				 Case 1
				 	dir.ReverseY()
				 Default
				 	dir.Reverse()
			End Select
			time = Millisecs()
			delay = Rnd(50,1000)
		Endif
		If pos.y > BOTTOM And dir.y > 0
			dir.ReverseY()
		Elseif pos.y < TOP And dir.y < 0
			dir.ReverseY()
		Endif
		If pos.x > RIGHT And dir.x > 0
			dir.ReverseX()
		Elseif pos.x < LEFT And dir.x < 0
			dir.ReverseX()
		Endif
		
		pos.Add(dir)
		animation.Update()
		Return True
	End Method
	
	Method Shoot(bulletList:List<Bullet>,bulletStore:Store<Bullet>)
		If stime + sdelay < Millisecs()
		
			Local b := bulletStore.GetItem()
			b.Set(pos.x,pos.y,Bullet.DOWN,5)
			bulletList.AddLast(b)
			sdelay = Rnd(500,1500)
			stime = Millisecs()
		Endif
	End Method
	
	
	Method Render:void(canvas:Canvas) Override
		animation.Render(canvas,pos.x,pos.y)
		If displayHitBox
			 shape.Render(canvas)
		Endif
	End Method

End Class


Class Mother Extends Entity
	
	Field time:Int
	Field speed:Float
	Field delay:Int
	Field shootTime:Int
	Field shootDelay:Int
	Field spiderTime:Int
	Field spiderDelay:Int
	Field count:Int
	Field spiderList:List<Spider>
	Field spiderStore:Store<Spider>
	Field motherBulletList:List<Bullet>
	Field motherBulletStore:Store<Bullet>
	Field spiderImg:Image[]	
	Field spiderAnimation:Animation

	Const BOTTOM:Float = 350
	Const LEFT:Float = 50
	Const RIGHT:Float = 600
	Const TOP:Float = 100	
	
	
	Method New()
	End Method
	
	Method New(animation:Animation,x:Float,y:Float,spiderList:List<Spider>,spiderStore:Store<Spider>)
		Self.animation = animation
		pos = New Vec2d(x,y)
		dir = New Vec2d(.8,.9)
		speed = 5
		dir.Multiply(speed)
		time = Millisecs()
		delay = Rnd(50,1000)
		spiderDelay = Rnd(300,3000)
		spiderTime = time
		count = 5
		spiderImg = New Image[2]
		shape = New HitBox(pos,-10,-10,20,20)
		Self.spiderList = spiderList
		Self.spiderStore = spiderStore
		motherBulletList = New List<Bullet>
		motherBulletStore = New Store<Bullet>(50)
	End Method
	
	
	Method Update:Bool()Override
		If time + delay < Millisecs()
			Local n:Int = Rnd(0,2)
			Select n
				 Case 0
				 	dir.ReverseX()
				 Case 1
				 	dir.ReverseY()
				 Default
				 	dir.Reverse()
			End Select
			time = Millisecs()
			delay = Rnd(50,1000)
		Endif
		If pos.y > BOTTOM And dir.y > 0
			dir.ReverseY()
		Elseif pos.y < TOP And dir.y < 0
			dir.ReverseY()
		Endif
		If pos.x > RIGHT And dir.x > 0
			dir.ReverseX()
		Elseif pos.x < LEFT And dir.x < 0
			dir.ReverseX()
		Endif
		
		pos.Add(dir)
		If count > 0 
			If spiderTime + spiderDelay < Millisecs()
			 	Local spider:Spider = spiderStore.GetItem()
			 	spiderAnimation = New Animation
			 	spiderAnimation.AddFrame(New Sprite(spiderImg[0],2,2),300)
			 	spiderAnimation.AddFrame(New Sprite(spiderImg[1],2,2),300)
			 	spider.Set(spiderAnimation,pos.x,pos.y)
				spiderList.AddLast(spider)
				count -= 1
				spiderTime = Millisecs()
			Endif
		Endif
		
		If count = 0 Then
			If spiderList.Empty
				count = 5
			Endif
		Endif
		Return True
	End Method
	
	Method AddChildAnimation(image:Image[])
		Self.spiderImg = image
	End Method 
	
	Method ShootBullet(player:Entity) Override
			If shootTime < Millisecs()
				If pos.x > (player.pos.x - 5) And pos.x < (player.pos.x + 5)
					Local bullet := motherBulletStore.GetItem()
					bullet.Set(pos.x,pos.y,Bullet.DOWN,5)
					motherBulletList.AddLast(bullet)	
				Else
					Local bullet := motherBulletStore.GetItem()
					bullet.Set(pos.x,pos.y,Bullet.DOWN,5)
					motherBulletList.AddLast(bullet)	
				Endif
				shootTime = Millisecs() + 500
			Endif
			
			
	End Method	
		
	Method Render(canvas:Canvas) Override
		animation.Render(canvas,pos.x,pos.y)
		If displayHitBox 
			 shape.Render(canvas)
		Endif
	End method

End Class

Class SpiderManager Extends Manager
	Field motherList:List<Entity>
	Field motherStore:Store<Mother>
	Field spiderStore:Store<Spider>
	Field spiderList:List<Spider>

	
	Field spiderImg:Image[]
	Field motherAnimation:Animation
		
	Field done:Bool
	Field playerManager:PlayerManager
		
	Field waitTime:Int
	Field waitDelay:Int
		
	Field enteringTime:Int
	Field enteringDelay:Int
		
	Const ENTERING:Int = 1
	Const UPDATING:Int = 2
	Const EXPLODING:Int = 3
	Const DONE:Int = 4
	Const WAITING:Int = 5
		
		
	Method New(player:PlayerManager)
		Super.New()
		spiderStore = New Store<Spider>(50)
		spiderList = New List<Spider>
		motherList = New List<Entity>
		motherStore = New Store<Mother>(10) 

		motherAnimation = New Animation
		motherAnimation.AddFrame(New Sprite(GenerateMotherTile(),2,2))

		spiderImg = New Image[2]
		spiderImg[0] = GenerateSpiderTile2()
		spiderImg[1] = GenerateSpiderTile3()
				
		Self.playerManager = player
		done = False
		InitEntities()
	End Method
	
	Method InitEntities()
		For Local i:Int = 0 Until 6
			Local mother := New Mother(motherAnimation,50+40*i,50,spiderList,spiderStore)
			mother.AddChildAnimation(spiderImg)
			mother.link = motherList.AddLast(mother)
		Next
		state = WAITING
		waitTime = Millisecs()
		waitDelay = 3000
				
	End Method
	
	Method Update:Bool() Override
		Select state
		
			Case WAITING
				If waitTime + waitDelay < Millisecs()
					enteringTime = Millisecs()
					enteringDelay = 2000
					state = ENTERING
				Endif
			Case ENTERING
				If enteringTime + enteringDelay < Millisecs()
					state = UPDATING
				Endif
			Case UPDATING
				If Not motherList.Empty
					Local mother:= motherList.Last
					If mother 
						mother.Update()
					Endif
				Endif
				If Not spiderList.Empty
					Local link := spiderList.FirstNode()
					While link.Value
						Local spider := link.Value
						spider.Update()
						link = link.Succ
					Wend
				Endif
				If motherList.Empty And spiderList.Empty And done = False
					InitEntities()
					
				Endif
				ShootBullet()
			Case EXPLODING
			
		End Select
		If Not bulletList.Empty
			Local bulletLink := bulletList.FirstNode()
			While bulletLink.Value
				bulletLink.Value.Update()
				bulletLink = bulletLink.Succ
			Wend
		Endif
		UpdateExplosions()
		Return True
	End Method
	

	Method Collided()
		If state <> UPDATING return
		Local bList := playerManager.bulletList
		If Not bList.Empty
			Local done:Bool = False
			Local bulletLink := bList.FirstNode()
			While bulletLink.Value
				If Not motherList.Empty
					Local mother := motherList.Last
					If mother.shape.Collided(bulletLink.Value.shape)
						bulletLink.Remove()
						motherList.RemoveLast()
						Local exp:Explosion = explosionStore.GetItem()
						exp.Set(mother.animation.current.Value,mother.pos.x,mother.pos.y)
						explosionList.AddLast(exp)
						exp = explosionStore.GetItem()
						exp.Set(mother.animation.current.Value,mother.pos.x,mother.pos.y)
						explosionList.AddLast(exp)
						done = True
					Endif
				Endif
				If done = false
					if Not spiderList.Empty
						Local spiderLink := spiderList.FirstNode()
						While spiderLink.Value
							If bulletLink.Value.shape.Collided(spiderLink.Value.shape)
								spiderLink.Remove()
								bulletLink.Remove()
								Local exp:Explosion = explosionStore.GetItem()
								exp.Set(spiderLink.Value.animation.current.Value,spiderLink.Value.pos.x,spiderLink.Value.pos.y)
								explosionList.AddLast(exp)
								exp = explosionStore.GetItem()
								exp.Set(spiderLink.Value.animation.current.Value,spiderLink.Value.pos.x,spiderLink.Value.pos.y)
								explosionList.AddLast(exp)
							Endif 
							spiderLink = spiderLink.Succ
						Wend
					Endif
				Endif
				bulletLink = bulletLink.Succ
			Wend
		Endif
		If Not bulletList.Empty
			Local bulletLink := bulletList.FirstNode()
			While bulletLink.Value
				If bulletLink.Value.pos.y > 400
					bulletLink.Remove()
					bulletStore.ReturnItem(bulletLink.Value)
				Elseif bulletLink.Value.shape.Collided(playerManager.player.shape)
					Local player := playerManager.player
					bulletLink.Remove()
					Local exp:Explosion = explosionStore.GetItem()
					exp.Set2(player.animation.current.Value,player.pos.x-20,player.pos.y)
					explosionList.AddLast(exp)
					exp = explosionStore.GetItem()
					exp.Set2(player.animation.current.Value,player.pos.x-20,player.pos.y)
					explosionList.AddLast(exp)
					exp = explosionStore.GetItem()
					exp.Set2(player.animation.current.Value,player.pos.x-20,player.pos.y)
					explosionList.AddLast(exp)
					exp = explosionStore.GetItem()
					exp.Set2(player.animation.current.Value,player.pos.x-20,player.pos.y)
					explosionList.AddLast(exp)
				Endif
				bulletLink = bulletLink.Succ
			Wend
		Endif
	End Method
	
	Method ShootBullet()
		If Not motherList.Empty
			Local mother:= motherList.Last
			If mother
				mother.ShootBullet(playerManager.player)
			Endif
		Endif
	
		If Not spiderList.Empty
			Local link := spiderList.FirstNode()
			While link.Value
				Local spider := link.Value
				spider.Shoot(bulletList,bulletStore)
				link = link.Succ
			Wend
		Endif
		
	End Method
	
	
	Method Render:void(canvas:Canvas) Override
		If Not motherList.Empty
			Local link := motherList.FirstNode()
			While link.Value
				Local mother:= link.Value
				mother.Render(canvas)
				link = link.Succ
			Wend
		Endif
		If Not spiderList.Empty
			Local link2 := spiderList.FirstNode()
			canvas.Color = new Color(1,1,1)
			While link2.Value
				Local spider := Cast<Spider>(link2.Value)
				spider.Render(canvas)
				link2 = link2.Succ
			Wend
		Endif
		If Not bulletList.Empty
			Local bulletLink := bulletList.FirstNode()
			While bulletLink.Value
				bulletLink.Value.Render(canvas)
				bulletLink = bulletLink.Succ
			Wend
		Endif
		RenderExplosions(canvas)
	End Method
	

End Class