
Namespace myapp

#Import "<std>"
#Import "<mojo>"
#Import "radiation_box.png"

Using std..
Using mojo..
Using gles20..

Class MyWindow Extends GLWindow

	Global g_bBlending:Int = True
	Global g_bSortUsingCullModeTrick:Int = True
	Global ptLastMousePosit:point = New point
	Global ptCurrentMousePosit:point = New point
	Global bMousing:Int
	Global oldx:Int,oldy:Int
	Global g_fDistance:Float = -4.5
	Global g_fSpinX:Float    = 0.0
	Global g_fSpinY:Float    = 0.0
	Global Checkimage:Byte[,,] '[256,256,4]
	Global Texname:GLuint
	Global g_textureID:Int = -1
	Global g_cubeVertices:Float[] = new Float[](
		 0.0, 0.0, -1.0, -1.0, 1.0,       ' Bottom Left Of The Texture And Quad
		 1.0, 0.0,  1.0, -1.0, 1.0,       ' Bottom Right Of The Texture And Quad
		 1.0, 1.0,  1.0,  1.0, 1.0,       ' Top Right Of The Texture And Quad
		 0.0, 1.0, -1.0,  1.0, 1.0,       ' Top Left Of The Texture And Quad
				' Back Face
		 1.0, 0.0, -1.0, -1.0, -1.0,      ' Bottom Right Of The Texture And Quad
		 1.0, 1.0, -1.0,  1.0, -1.0,      ' Top Right Of The Texture And Quad
		 0.0, 1.0,  1.0,  1.0, -1.0,      ' Top Left Of The Texture And Quad
		 0.0, 0.0,  1.0, -1.0, -1.0,      ' Bottom Left Of The Texture And Quad
				' Top Face
		 0.0, 1.0, -1.0,  1.0, -1.0,      ' Top Left Of The Texture And Quad
		 0.0, 0.0, -1.0,  1.0,  1.0,      ' Bottom Left Of The Texture And Quad
		 1.0, 0.0,  1.0,  1.0,  1.0,      ' Bottom Right Of The Texture And Quad
		 1.0, 1.0,  1.0,  1.0, -1.0,      ' Top Right Of The Texture And Quad
				' Bottom Face
		 1.0, 1.0, -1.0, -1.0, -1.0,      ' Top Right Of The Texture And Quad
		 0.0, 1.0,  1.0, -1.0, -1.0,      ' Top Left Of The Texture And Quad
		 0.0, 0.0,  1.0, -1.0,  1.0,      ' Bottom Left Of The Texture And Quad
		 1.0, 0.0, -1.0, -1.0,  1.0,      ' Bottom Right Of The Texture And Quad
				' Right face
		 1.0, 0.0,  1.0, -1.0, -1.0,      ' Bottom Right Of The Texture And Quad
		 1.0, 1.0,  1.0,  1.0, -1.0,      ' Top Right Of The Texture And Quad
		 0.0, 1.0,  1.0,  1.0,  1.0,      ' Top Left Of The Texture And Quad
		 0.0, 0.0,  1.0, -1.0,  1.0,      ' Bottom Left Of The Texture And Quad
				' Left Face
		 0.0, 0.0, -1.0, -1.0, -1.0,      ' Bottom Left Of The Texture And Quad
		 1.0, 0.0, -1.0, -1.0,  1.0,      ' Bottom Right Of The Texture And Quad
		 1.0, 1.0, -1.0,  1.0,  1.0,      ' Top Right Of The Texture And Quad
		 0.0, 1.0, -1.0,  1.0, -1.0)      ' Top Left Of The Texture And Quad
		




	Method New( title:String="Simple mojo app",width:Int=640,height:Int=480,flags:WindowFlags=Null )

		Super.New( title,width,height,flags )
		oldx = Mouse.X
		oldy = Mouse.Y
		init()

	End

	Method init()
		loadTexture()
		glClearColor( 0.35, 0.53, 0.7, 1.0 )
		glEnable( GL_TEXTURE_2D )
		glMatrixMode( GL_PROJECTION )
		glLoadIdentity()
		gluPerspective( 45.0, 640.0 / 480.0, 0.1, 100.0)
	End Method
	
	Method OnRender( canvas:Canvas ) Override
	
		App.RequestRender()
		
		Super.OnRender( canvas )
	
		canvas.DrawText( "Hello World!",Width/2,Height/2,.5,.5 )
		callback()
		render()
		canvas.DrawText("B - blending ",10,1)
		canvas.DrawText("s - cull sorting",10,15)
		canvas.DrawText("up/down arrow - aproach",10,30)
		canvas.DrawText("(esc) to Exit",10,45)
	End
	Method OnRenderGL() Override

		'Clear window ourselves...
		'	
		glClearColor( 0,0,1,1 )
		
		glClearDepthf( 0 )
		
		glClearStencil( 0 )
		
		glClear( GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT|GL_STENCIL_BUFFER_BIT )


		'Drawing area. You're always drawing to the entire window in GL regardless of Layout.
		'
		'Don't really need this for this example is it only affects glDrawBlah, but nice to know...
		'
		glViewport( 0,0,Frame.Width,Frame.Height )

		
		'Shader-less rect
		'
		glEnable( GL_SCISSOR_TEST )

		glScissor( Mouse.X-32,Frame.Height-Mouse.Y-32,64,64 )

		glClearColor( 1,0,0,1 )

		glClear( GL_COLOR_BUFFER_BIT )

		glDisable( GL_SCISSOR_TEST )
		
	End
	
	Function CALLBACK:Int()
			
	    Select True
			Case Keyboard.KeyHit(Key.B) 
	            g_bBlending = Not g_bBlending
	        Case Keyboard.KeyHit(key.S)
	            g_bSortUsingCullModeTrick = Not g_bSortUsingCullModeTrick
	        Case Keyboard.KeyDown(Key.Escape)
				 App.Terminate()
	        Case Keyboard.KeyDown(Key.Up) ' Up Arrow Key
	             g_fDistance -= 0.1
	        Case Keyboard.KeyDown(Key.Down)'  Down Arrow Key
	            g_fDistance += 0.1
		End Select
		Select PollEvent()
			
	        Case EVENT_MOUSEDOWN 
				ptLastMousePosit.x = ptCurrentMousePosit.x = MouseX()
	            ptLastMousePosit.y = ptCurrentMousePosit.y = MouseY()
				bMousing = True
			Case EVENT_MOUSEMOVE
				
				ptCurrentMousePosit.x = MouseX()
				ptCurrentMousePosit.y = MouseY()
	
				If( bMousing )
				
					g_fSpinX -= (ptCurrentMousePosit.x - ptLastMousePosit.x)
					g_fSpinY -= (ptCurrentMousePosit.y - ptLastMousePosit.y)
				EndIf
				
				ptLastMousePosit.x = ptCurrentMousePosit.x
	            ptLastMousePosit.y = ptCurrentMousePosit.y
		End Select
		If Not Mouse.ButtonDown(MOuseButton.Left) bMousing = False
	
	End Function 
		
	Function loadTexture( )	
		Local PointeurImg:Byte Ptr
		Local TexWidth:Int
		Local TexHeight:Int
		Local tex01 := Pixmap.Load("asset::radiation_box.png",PixelFormat.RGBA32)
		TexWidth=tex01.Width
		TexHeight=tex01.Height
		glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, tex01.Width, tex01.Height, 0,
							 GL_RGBA, GL_UNSIGNED_BYTE, tex01.Data)
		'PointeurImg=PixmapPixelPtr(tex01,0,0)
		Local pp:Int=0
		For Local y:Int=TexHeight-1 To 0 Step -1
			For Local x:Int=0 To TexWidth-1
				If x> 28 And x< (TexWidth-29) And y > 28 And y<(TexHeight-29)
					Checkimage[y,x,0]=PointeurImg[pp]
					Checkimage[y,x,1]=PointeurImg[pp+1]
					Checkimage[y,x,2]=PointeurImg[pp+2]
					Checkimage[y,x,3]=160
				Else
					Checkimage[y,x,0]=PointeurImg[pp]
					Checkimage[y,x,1]=PointeurImg[pp+1]
					Checkimage[y,x,2]=PointeurImg[pp+2]
					Checkimage[y,x,3]=255
				EndIf	
				pp=pp+3
			Next
		Next
		tex01=Null
		glPixelStorei(GL_UNPACK_ALIGNMENT,1)
		glGenTextures(1, Varptr Texname)
		glBindTexture(GL_TEXTURE_2D, Texname)
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT)
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT)
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST)
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST)
		glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, TexWidth, TexHeight, 0, GL_RGBA, GL_UNSIGNED_BYTE, Checkimage)
	End Function
	
	Function render( )
	
	    glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT )
	
	    'glMatrixMode(GL_MODELVIEW )
	    'glLoadIdentity()
	    'glTranslatef( 0.0, 0.0, g_fDistance )
	    'glRotatef( -g_fSpinY, 1.0, 0.0, 0.0 )
	    'glRotatef( -g_fSpinX, 0.0, 1.0, 0.0 )
		
	#Rem
	    
	     Transparency sorting For our cube...
	    
	     If you have a single transparent Object, Or multiple transparent objects 
	     which do Not overlap in screen space (i.e., each screen pixel is touched 
	     by at most one of the transparent objects), there's a sorting short-cut 
	     which can be used under certain conditions.
	    
	     If your transparent objects are closed, convex, And viewed from the 
	     outside, culling may be used To draw the back-facing polygons prior To 
	     the front-facing polygons. This will accomplish the same thing
	     as sorting your objects Or polygons into back-To-front order.
	     Fortunately For us, our cube is a perfect candidate For this sorting 
	     trick.
	     
	     On the other hand, If we can't use the cull-mode sorting trick, we would 
	     need To sort our objects manually, which would require us To transform 
	     the geometry into eye-space so we could compare their Final position 
	     along the z axis. Only Then, could we could render them in the proper 
	     back-To-front order For alpha blending.
	    
	     Also, If transparent objects intersect in any way, the individual 
	     triangles of the objects touching will have To be sorted And drawn 
	     individually from back-To-front. And is some rare cases, triangles that 
	     intersect each other may have To be broken into smaller triangles so they
	     no longer intersect Or blending artifacts will persist regardless of our
	     sorting efforts.
	    
	     It’s plain To see, transparency sorting can become a big, hairy mess real quick.
	    
	     http:www.opengl.org/resources/tutorials/sig99/advanced99/notes/node204.html
	    
	#End Rem
		If( g_bBlending = True )
		
	'        
	'         Use the texture's alpha channel to blend it with whatever’s already 
	'         in the frame-buffer.
	'        
	
			glDisable( GL_DEPTH_TEST )
	
	        glEnable( GL_BLEND )
	        glBlendFunc( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA )
	
	        glBindTexture( GL_TEXTURE_2D, Texname)
	
	       If( g_bSortUsingCullModeTrick = True )
					    
	'            
	'             Use the cull-mode sorting trick For convex non-overlapping 
	'             geometry.
	'            
	
	            glEnable( GL_CULL_FACE )
	
	'            
	'             Render the cube but only render the back-facing polygons.
	'            
	
	            glCullFace( GL_FRONT )
				
	            'glInterleavedArrays( GL_T2F_V3F, 0, g_cubeVertices )
				glDrawArrays( GL_QUADS, 0, 24 )
	
	'            
	'             Render the cube again, but this time we only render the 
	'             front-facing polygons.
	'            
	
	            glCullFace( GL_BACK )
	
	           glInterleavedArrays( GL_T2F_V3F, 0, g_cubeVertices )
	           glDrawArrays( GL_QUADS, 0, 24 )
	
	           glDisable( GL_CULL_FACE )
	       
	        Else
	'        
	'            
	'             Do no sorting And hope For the best. From certain viewing 
	'             positions the cube's sides will appear sorted correctly, but this
	'             is typically rare And the cube will Not look Right most of the 
	'             time.
	'            
	
	            glInterleavedArrays( GL_T2F_V3F, 0, g_cubeVertices )
	            glDrawArrays( GL_QUADS, 0, 24 )
	        EndIf'
	'
		Else
	'	
	'        
	'         Render the cube, but do no blending...
	'        
	
			glDisable( GL_BLEND )
			glEnable( GL_DEPTH_TEST )
	
	        glBindTexture( GL_TEXTURE_2D, Texname)
	        glInterleavedArrays( GL_T2F_V3F, 0, g_cubeVertices )
	        glDrawArrays( GL_QUADS, 0, 24 )
		EndIf
	
	End Function
		

End


Class Vertex
    Field tu:Double, tv:double
    Field x:Double, y:Double, z:Double
End Class 

Class  point
	Field x:int,y:Int
End Class


Function Main()

	New AppInstance
	
	New MyWindow
	
	App.Run()
End
