Namespace myapp

#Import "<std>"
#Import "<mojo>"
#Import "assets/solidblock.png"

Using std..
Using mojo..

Class MyWindow Extends Window

	Field tile:tlShape

	Method New( title:String="Simple mojo app",width:Int=800,height:Int=600,flags:WindowFlags=Null )
		Super.New( title,width,height,flags )
		
		tile = LoadShape("asset::solidblock.png",32 ,32 , 16)
	End

	Method OnRender( canvas:Canvas ) Override
	
		App.RequestRender()
		canvas.Clear( New Color(0,0,0,1) )
		
		For Local c:=0 To 15
			canvas.DrawImage(tile.GetImage(c), c*32+0.5, c*32+0.5)
		Next
	
	End
	
End

Class tlShape
	
	Private

	Field width:Int
	Field height:Int
	Field url:String
	Field frames:Int
	Field smallindex:Int
	Field largeindex:Int
	Field maxradius:Float
	Field name:String
	
	Public
	
	Field image:Image[]
	
	Property Url:String()
		Return url
	Setter (value:String)
		url = value
	End
	
	Property Name:String() 
		Return name
	Setter (value:String)
		name = value
	End
	
	Method GetImage:Image(frame:int)
		Return image[frame]
	End
	
	Property Width:Int()
		Return width
	Setter (value:Int)
		width = value
	End
	
	Property Height:Int()
		Return height
	Setter (value:Int)
		height = value
	End
	
	Property MaxRadius:Float()
		Return maxradius
	Setter (value:Float)
		maxradius = value
	End
	
	Property LargeIndex:Int()
		Return largeindex
	Setter (value:Int)
		largeindex = value
	End
	
	Property Frames:Int()
		Return frames
	Setter (value:Int)
		frames = value
	End
	
	Function LoadFrames:Image[] (path:String, numFrames:Int, cellWidth:Int, cellHeight:Int, padded:Bool = False)
		Local material:=Image.Load( path, null )
		If Not material Return New Image[0]
		
		If cellWidth * cellHeight * numFrames > material.Width * material.Height Return New Image[0]
		
		Local frames:= New Image[numFrames]
		
		If cellHeight = material.Height
			Local x:=0
			local width:=cellWidth
			If padded 
				x += 1
				width -= 2
			End if

			For Local i:=0 Until numFrames
				local rect:= New Recti(i * cellWidth + x, 0, i * cellWidth + x + width, cellHeight)
				frames[i] = New Image(material, rect)
			Next
		Else
			Local x:= 0, width:= cellWidth, y:= 0, height:= cellHeight
			Local columns:= material.Width / width
			If padded
				x += 1
				y += 1
				width -= 2
				height -= 2
			End If
			
			For Local i:= 0 Until numFrames
				Local fx:Int = i Mod columns * cellWidth
				Local fy:Int = Int(i / columns) * cellHeight

				local rect:= New Recti(fx + x, fy + y, fx + x + width, fy + y + height)
				frames[i] = New Image(material, rect)
				frames[i].TextureFilter = TextureFilter.Nearest
			Next
		End If
		
		Return frames
		
	End

End

Function LoadShape:tlShape(url:String, width:Int = 0, height:Int = 0, frames:Int = 1, padding:int = false)
	Local shape:tlShape = New tlShape
	If frames = 1
		shape.image = New Image[1]
		shape.image[0] = Image.Load(url)
	Else
		shape.image = tlShape.LoadFrames(url, frames, width, height, padding)
	EndIf

	shape.Width = width
	shape.Height = height
	shape.Frames = frames
	shape.Url = url
	
	Return shape

End

Function Main()

	New AppInstance
	
	New MyWindow
	
	App.Run()
End
