#Import "images/"

#Import "<std>"
#Import "<mojo>"
#Import "<mojox>"

Using std..
Using mojo..
Using mojox..

Global virtualResolution:=New Vec2i( 640,480 )

Class APD_Shape 
	Field tv:=New Vec2f (0.0)
	Field Width:Float = 0.0
	Field Height:Float = 0.0
	Field active:Bool = True
	Field imgIdle:Image
	Field imgDown:Image
	Field anim:Image[]
	Method setLocation(location:Vec2f)
		tv=location
		'Print "shape x:"+tv.X+ " y:"+tv.Y
	End
	Method setHandle(handle:Vec2f)
		If imgIdle <> Null 
			imgIdle.Handle=handle
		Else
			Throw New CustomException ("imgIdle is Null or no Loaded")
		End
		If imgDown <> Null 
			imgDown.Handle=handle
'		Else	' Commenting this out makes imgDown optional
'			Throw New CustomException ("imgDown is Null or no Loaded")
		End
	End
	Method setSize()
		If imgIdle <> Null 
			Width=imgIdle.Width
			Height=imgIdle.Height
		Else 
			Throw New CustomException ("imgIdle is Null or no Loaded")
		Endif
		'Print "shape Width:"+Width+" Height:"+Height
	End
	
End
 
Class APD_Button Extends APD_Shape
	Field down:Int = 0
End

Class MyWindow Extends Window 
	Field mloc:Vec2i
	Field mevent:String
	Field mbleft:Bool
	Field mbRight:Bool
	Field mbMiddle:Bool
	
	'Sprites and Images
	Global sprites:Image
	Global sprites2:Image
	Global mouseWheelAnim:Image[]
	Global mouseWheelAnim2:Image[]
	Global animFrame:Float=5.0
	Global mouse:APD_Shape
	Global mouseLB:APD_Button
	Global mouseMB:APD_Button
	Global mouseRB:APD_Button
	Global mouseWheel:APD_Button
	Field mwheel:Vec2i
	Field wheelmove:Bool=false
	Field wmem:Int=0
	
	' Screen Title
	Field titlemsg:String
	Field title_y:Int
	Field title_x:Float
	
	Method New( title:String,width:Int,height:Int,flags:WindowFlags=WindowFlags.Resizable )
		
		Super.New( title,width,height,flags )

		LoadSprites()
		InitAssets()
		titlemsg = "Move the mouse, press the buttons and turn the wheel!"
	End
	
	Method OnMouseEvent( event:MouseEvent ) Override
		Select event.Type
			Case EventType.MouseDown
				'Print "Mouse Down"
'				If Mouse.ButtonDown(MouseButton.Left)
'
'					mouseLB.down=Mouse.ButtonDown(MouseButton.Left)
'				Endif
				
'				mouseMB.down=Mouse.ButtonDown(MouseButton.Middle)
'				mouseRB.down=Mouse.ButtonDown(MouseButton.Right)
				' Print "Mouse Down "+ Int(mouseLB.down)
			Case EventType.MouseClick
'				Print "Mouse Click"+ Int(mouseLB.down)
'				mouseLB.down=Mouse.ButtonDown(MouseButton.Left)
'				mloc=Mouse.Location
'				mbleft=Mouse.ButtonDown(MouseButton.Left)
'				mbMiddle=Mouse.ButtonDown(MouseButton.Middle)
'				mbRight=Mouse.ButtonDown(MouseButton.Right)
			Case EventType.MouseRightClick
				'Print "Mouse Right Click"
			Case EventType.MouseMove
				'Print "Mouse Moving"
			Case EventType.MouseUp
'				If Mouse.ButtonReleased(MouseButton.Left)
'					mouseLB.down=Mouse.ButtonReleased(MouseButton.Left)
'				endif
'				mouseMB.down=Mouse.ButtonReleased(MouseButton.Middle)
'				mouseRB.down=Mouse.ButtonReleased(MouseButton.Right)

			Case EventType.MouseWheel
				
				'Print event.Wheel
				mouseWheel.down=true
				mouseWheel.tv.Y = Max(-1, Min(1, (event.Wheel.Y)))

				Select mouseWheel.tv.Y
				 	Case -1
						animFrame+=1
						If animFrame>=7 Then animFrame=0
					Case 1
						animFrame-=1
						If animFrame<=0 Then animFrame=6
				End
			
			End Select
		
	End
	
	Method OnMeasure:Vec2i() Override
	  Return virtualResolution
	End
	
	Method OnRender( canvas:Canvas ) Override
		
		RequestRender()
		drawMouse(canvas)
		'canvas.DrawText(mloc.X+" , "+mloc.Y,Window.Width*.5,Window.Height*.5)
		canvas.Color=Color.Magenta
		canvas.DrawText(titlemsg,title_x,title_y)
		
		canvas.Color=Color.Green
		If Mouse.X>560 And Mouse.Y<460
			canvas.DrawText("   "+Mouse.X+" , "+Mouse.Y,Mouse.X-80,Mouse.Y)
		Endif
		If Mouse.Y>460 And Mouse.X<560
			canvas.DrawText("   "+Mouse.X+" , "+Mouse.Y,Mouse.X,Mouse.Y-15)
		Endif
		If Mouse.X>560 And Mouse.Y>460
			canvas.DrawText("   "+Mouse.X+" , "+Mouse.Y,Mouse.X-80,Mouse.Y-15)
		Endif
		If Mouse.X<560 And Mouse.Y<460
			canvas.DrawText("   "+Mouse.X+" , "+Mouse.Y,Mouse.X,Mouse.Y)
		endif
		OnUpdate()
	End
	
	Method OnUpdate()
		mouseLB.down=Mouse.ButtonDown(MouseButton.Left)
		mouseMB.down=Mouse.ButtonDown(MouseButton.Middle)
		mouseRB.down=Mouse.ButtonDown(MouseButton.Right)
	End
	
	Method drawMouse(canvas:Canvas)
		
		title_x=canvas.Font.TextWidth(titlemsg)	'get the titlemsg text length
		title_y=canvas.Font.Height*.5
		title_x=virtualResolution.X *.5-title_x *.5 'center it on the screen
		
		canvas.Color=Color.White
		canvas.DrawImage(mouse.imgIdle,mouse.tv.X,mouse.tv.Y,0,1,1)
		
		If mouseLB.down
			canvas.DrawImage(mouseLB.imgDown,mouseLB.tv.X,mouseLB.tv.Y,0,1,1)
		Else
			canvas.DrawImage(mouseLB.imgIdle,mouseLB.tv.X,mouseLB.tv.Y,0,1,1)
		Endif
		
'		If mouseMB.down
'			canvas.DrawImage(mouseMB.imgDown,mouseMB.tv.X,mouseMB.tv.Y,0,1,1)
'		Else
'			canvas.DrawImage(mouseMB.imgIdle,mouseMB.tv.X,mouseMB.tv.Y,0,1,1)
'		Endif

		If mouseRB.down
			canvas.DrawImage(mouseRB.imgDown,mouseRB.tv.X,mouseRB.tv.Y,0,1,1)
		Else
			canvas.DrawImage(mouseRB.imgIdle,mouseRB.tv.X,mouseRB.tv.Y,0,1,1)
		Endif
		
		If mouseMB.down
			canvas.DrawImage(mouseWheelAnim2[animFrame],mouseWheel.tv.X,mouseMB.tv.Y,0,1,1)
		Else
			canvas.DrawImage(mouseWheelAnim[animFrame],mouseWheel.tv.X,mouseMB.tv.Y,0,1,1)
		Endif

			
	End
	
	Method  LoadSprites()
	
		sprites=Image.Load( "asset::mousesheet.png" )
		mouseWheelAnim = GrabAnim(1,1,26,58,7,28,sprites)
		
		sprites2=Image.Load( "asset::mousesheet2.png" )
		mouseWheelAnim2 = GrabAnim(1,1,26,58,7,28,sprites2)
	
	End
	
	Method GrabImage:Image( x:Int,y:Int,w:Int,h:Int,sprite:Image )
		Local image:=New Image( sprite,x,y,w,h )
		image.Handle=New Vec2f( 0.0,0.0 )' 0.0 = top, 0.5 = center, 1.0 botton
		
		Return image
	End
	
	Method GrabAnim:Image[]( x:Int,y:Int,w:Int,h:Int,count:Int,x_pitch:Int,sprite:Image )
		Local images:=New Image[count]
		For Local i:=0 Until count
			images[i]=GrabImage( x,y,w,h,sprite )
			images[i].Handle=New Vec2f( 0.0,0.0 )
			x+=x_pitch
		Next
		Return images
	End	
	
	Method InitAssets()

		' mouse
		mouse=New APD_Shape()
		mouse.imgIdle=Image.Load("asset::mouse.png")
		mouse.setSize()
		mouse.setLocation(New Vec2f(virtualResolution.X*.5 - mouse.Width*.5, virtualResolution.Y * .5-mouse.Height*.5))
		mouse.setHandle(New Vec2f(0.0,0.0))
	
		
		' left Button
		mouseLB=New APD_Button()
		mouseLB.imgIdle=Image.Load("asset::mouseLB.png")
		mouseLB.imgDown=Image.Load("asset::mouseLBdown.png")
		mouseLB.setSize()
		mouseLB.setLocation(New Vec2f(mouse.tv.X+mouse.Width*0.04,mouse.tv.Y+mouse.Height*.010))
		mouseLB.setHandle(New Vec2f(0.0,0.0))
		
	
		' middle Button
		mouseMB=New APD_Button()
		mouseMB.imgIdle=Image.Load("asset::mouseMB.png")
		mouseMB.imgDown=Image.Load("asset::mouseMBdown.png")
		mouseMB.setSize()
		mouseMB.setLocation(New Vec2f(mouseLB.tv.X+mouseLB.Width*.85,mouseLB.tv.Y+mouseLB.Height*.15 ))
		mouseMB.setHandle(New Vec2f(0.0,0.0))
		
	
		' right Button
		mouseRB=New APD_Button()
		mouseRB.imgIdle=Image.Load("asset::mouseRB.png")
		mouseRB.imgDown=Image.Load("asset::mouseRBdown.png")
		mouseRB.setSize()
		mouseRB.setLocation(New Vec2f(mouseLB.tv.X+mouseLB.Width,mouse.tv.Y+mouseLB.Height*.025))
		mouseRB.setHandle(New Vec2f(0.0,0.0))
		
		' wheel Button
		mouseWheel=New APD_Button()
		mouseWheel.imgIdle=Image.Load("asset::mouseMB.png")
		mouseWheel.imgDown=Image.Load("asset::mouseMBdown.png")
		mouseWheel.setSize()
		mouseWheel.setLocation(New Vec2f(mouseMB.tv.X,mouseMB.tv.Y))
		mouseWheel.setHandle(New Vec2f(0.0,0.0))
		
	End
	
End
Class CustomException Extends Throwable
    Field message:String
    Method New (msg:String)
        Self.message = msg
    End
End

Function Main() 
	Try
		New AppInstance
		New MyWindow( "Monkey 2 Mouse Test",640,480 )
		App.Run()
 	Catch err:CustomException
		Print err.message
    End
End

