//@renderpasses 0,1,2

varying vec2 texCoord0;
varying vec4 color;
//Here's the varying time float we can use in the fragment shader
varying float time;
uniform float mx2_Time2;

//@vertex

attribute vec4 mx2_Vertex;
attribute vec2 mx2_TexCoord0;
attribute vec4 mx2_Color;

uniform mat4 mx2_ModelViewProjectionMatrix;

uniform vec4 mx2_ImageColor;

void main(){

	texCoord0=mx2_TexCoord0;
	
	//Set the time float here to the mx2_Time we passed in the vertex buffer
	//You can then use it to do stuff in the fragment shader. Note I divide by 1000
	//otherwise it can animate too fast
	time = mx2_Time2;

	color=mx2_ImageColor * mx2_Color;
	
	gl_Position=mx2_ModelViewProjectionMatrix * mx2_Vertex;
}

//@fragment

uniform sampler2D mx2_ImageTexture0;
float random(float p) {
  return fract(sin(p)*10000.);
}

float noise(vec2 p) {
  return random(p.x + p.y*10000.);
}

vec2 sw(vec2 p) {return vec2( floor(p.x) , floor(p.y) );}
vec2 se(vec2 p) {return vec2( ceil(p.x)  , floor(p.y) );}
vec2 nw(vec2 p) {return vec2( floor(p.x) , ceil(p.y)  );}
vec2 ne(vec2 p) {return vec2( ceil(p.x)  , ceil(p.y)  );}

float smoothNoise(vec2 p) {
  vec2 inter = smoothstep(0., 1., fract(p));
  float s = mix(noise(sw(p)), noise(se(p)), inter.x);
  float n = mix(noise(nw(p)), noise(ne(p)), inter.x);
  return mix(s, n, inter.y);
  return noise(nw(p));
}

float movingNoise(vec2 p) {
  float total = 0.0;
  total += smoothNoise(p     - mx2_Time2);
  total += smoothNoise(p*2.  + mx2_Time2) / 2.;
  total += smoothNoise(p*4.  - mx2_Time2) / 4.;
  total += smoothNoise(p*8.  + mx2_Time2) / 8.;
  total += smoothNoise(p*16. - mx2_Time2) / 16.;
  total /= 1. + 1./2. + 1./4. + 1./8. + 1./16.;
  return total;
}

float nestedNoise(vec2 p) {
  float x = movingNoise(p);
  float y = movingNoise(p + 100.);
  return movingNoise(p + vec2(x, y));
}

void main(){

#if MX2_RENDERPASS==0
	  
	  vec2 p = texCoord0 * 6.;
	  float brightness = nestedNoise(p);
	  gl_FragColor.rgb = vec3(brightness);
	  gl_FragColor.a = 1.;
	
#else

	float alpha=texture2D( mx2_ImageTexture0,texCoord0 ).a * color.a;

	gl_FragColor.a = alpha ;

#endif

}
