//@renderpasses 0,1,2

varying vec2 texCoord0;
varying vec4 color;
uniform float mx2_Time2;

//@vertex

attribute vec4 mx2_Vertex;
attribute vec2 mx2_TexCoord0;
attribute vec4 mx2_Color;

uniform mat4 mx2_ModelViewProjectionMatrix;

uniform vec4 mx2_ImageColor;

void main(){

	texCoord0=mx2_TexCoord0;

	color=mx2_ImageColor * mx2_Color;
	
	gl_Position=mx2_ModelViewProjectionMatrix * mx2_Vertex;
}

//@fragment

uniform sampler2D mx2_ImageTexture0;

float wave(vec2 p, float angle) {
  vec2 direction = vec2(cos(angle), sin(angle));
  return cos(dot(p, direction));
}

float wrap(float x) {
  return abs(mod(x, 2.)-1.);
}

void main(){

#if MX2_RENDERPASS==0
	  vec2 p = (texCoord0 - 0.5) * 50.;
	  
	  float brightness = 0.;

	  for (float i = 1.; i <= 11.; i++) {
	    brightness += wave(p, mx2_Time2 / i);
	  }
	
	  brightness = wrap(brightness);
	
	  gl_FragColor.rgb = vec3(brightness);
	
#else

	float alpha=texture2D( mx2_ImageTexture0,texCoord0 ).a * color.a;

	gl_FragColor.a = alpha ;

#endif

}
