
Namespace myapp

#Import "<std>"
#Import "<mojo>"
#Import "assets/"

Using std..
Using mojo..

Class MyWindow Extends Window

	Field image:Image
	
	Field shader:Shader
	
	Field timeuniform:UserUniform

	Method New( title:String="Simple mojo app",width:Int=800,height:Int=600,flags:WindowFlags=Null )

		Super.New( title,width,height,flags )
		
		'shader = New Shader("Red", LoadString("asset::wave.glsl"))
		shader = New Shader("Red", LoadString("asset::noise.glsl"))
		timeuniform = AddUserUniform(New String[]("mx2_Time2"), 0, UniformCallback)
		
		image = Image.Load("asset::clouds.png", shader)
	End

	Method OnRender( canvas:Canvas ) Override
	
		App.RequestRender()

		canvas.Clear(New Color(0,0,0,1))
		
		canvas.DrawImage(image, 100, 50)
	End
	
	Function UniformCallback(useruniform:UserUniform, uniforms:UniformBlock)
		uniforms.SetScalar( "mx2_Time2", Float(Millisecs())/1000.0)
	End
	
End

Function Main()

	New AppInstance
	
	New MyWindow
	
	App.Run()
End
