' _______________________________________________________________________________________________________
'
' Game Pad
' 
' gamepad is an application that demonstrates Monkey2 features suchs canvas, images and image animation.
' In this demo you can control a flying dragon with keyboard, Mouse and Touch Screen.
' It runs on Windows, Mac and Mobile devices.
'
' Aroldo Carvalho Jan 11, 2017
' _______________________________________________________________________________________________________

#Import "images/"
#Import "sounds/"

#Import "<std>"
#Import "<mojo>"
#Import "<mojox>"

Using std..
Using mojo..
Using mojox..

Global virtualResolution:=New Vec2i( 640,480 )
'Phone 5 and 5S 1136 x 640
'iPhone 6 and 7 1334 x 750
'iPhone 6 and 7 Plus 1920 x 1080



Class APD_Shape 
	Field tv:=New Vec2f (0.0)
	Field Width:Float = 0.0
	Field Height:Float = 0.0
	Field active:Bool = True
	Field imgIdle:Image
	Field imgDown:Image
	Field anim:Image[]
	Method setLocation(location:Vec2f)
		tv=location
	End
	Method setHandle(handle:Vec2f)
		imgIdle.Handle=handle
		imgDown.Handle=handle
	End
	Method setSize()
		Width=imgIdle.Width
		Height=imgIdle.Height
	End
	
End
 
Class APD_Button Extends APD_Shape
	Field down:Bool = False
End

Class Star
	Field s:Vec2f
	Field m:Vec2f
	Field starcolor:Color[] = New Color[](Color.White,Color.Red,Color.Blue,Color.Yellow,Color.White,Color.Orange, Color.Magenta, Color.Pink)
	Field colorlen:Int
	Field Width:Int
	Field Height:Int
	Method New(w:Int,h:Int)
		s.X = Rnd(0,w)
		s.Y = Rnd(0,h)
		m.X = Rnd(-1,-0.1)
		colorlen=8
		Width=w
		Height=h
	End Method
	Method update()
		s+=m
		If s.X < 0 Then s.X = Width
	End Method
	Method draw(canvas:Canvas)
		canvas.Color = starcolor[(Rnd(0,colorlen))]
		canvas.DrawPoint(s.X,s.Y)
	End Method
End Class
 
Class MyApp Extends Window
	'Sprites and Images
	Global sprites:Image
	Global dragonUpAnim:Image[]
	Global dragonLeftAnim:Image[]
	Global dragonRightAnim:Image[]
	Global dragonDownAnim:Image[]
	Global animFrame:Float=0
	Global lastAnim:Image[]
	'Create Buttons
	Field buttonUP:APD_Button
	Field buttonDOWN:APD_Button
	Field buttonLEFT:APD_Button
	Field buttonRIGHT:APD_Button
	'Player 
	Field x:Float, y:Float, w:Float, h:Float
	'Stars
	Global starList:List<Star> = New List<Star>
	' Screen Title
	Field titlemsg:String
 	Field titleln:Int
 	Field title_x:Float
 	' Sound
 	Field musicsnd:Sound
 	Field dragonsnd:Sound
 	Field chanidx:Int=0
 	Field maxchan:Int=6
	Field channel:Channel[]
	Field mute:Bool
 	
	Method New( title:String,width:Int,height:Int,flags:WindowFlags=WindowFlags.Resizable )
		Super.New( title,width,height,flags )
		    	
		Layout="letterbox"
		
		LoadSprites()
		
		InitPad()
		
		InitStars()
		
		InitTitle()
		
		InitSound()
		
		PlaySFX(musicsnd,True)
	End
	
	
    
	Method OnMouseEvent( event:MouseEvent ) Override
		Select event.Type
		Case EventType.MouseDown
		'Print "Mouse Down"
		Case EventType.MouseClick
		'Print "Mouse Click"
		Case EventType.MouseRightClick
		'Print "Mouse Right Click"		    
		End Select
	End
	
	  Method OnRender( canvas:Canvas ) Override
	  
	  	App.RequestRender()	

	    'canvas.Clear(New Color(0.5,0.5,0.5))
	    title_x=canvas.Font.TextWidth(titlemsg)	'get the titlemsg text length
	    title_x=virtualResolution.X *.5-title_x *.5 'center it on the screen

		For Local star:=Eachin starList
			star.update()
			star.draw(canvas)
		Next
		canvas.Color=New Color(1.0,1.0,1.0)
	    If buttonUP.down
	    	canvas.DrawImage(buttonUP.imgDown,buttonUP.tv.X,buttonUP.tv.Y,0,1,1)
	    	canvas.DrawImage(dragonUpAnim[animFrame],x,y,0,1,1)
	    	lastAnim=dragonUpAnim
	    else
	    	canvas.DrawImage(buttonUP.imgIdle,buttonUP.tv.X,buttonUP.tv.Y,0,1,1)
	    	canvas.DrawImage(lastAnim[animFrame],x,y,0,1,1)
	    endif
	    If buttonLEFT.down
			canvas.DrawImage(buttonLEFT.imgDown,buttonLEFT.tv.X,buttonLEFT.tv.Y,0,1,1)
			canvas.DrawImage(dragonLeftAnim[animFrame],x,y,0,1,1)
			lastAnim=dragonLeftAnim
		else
			canvas.DrawImage(buttonLEFT.imgIdle,buttonLEFT.tv.X,buttonLEFT.tv.Y,0,1,1)
			canvas.DrawImage(lastAnim[animFrame],x,y,0,1,1)
		endif
		If buttonRIGHT.down
			canvas.DrawImage(buttonRIGHT.imgDown,buttonRIGHT.tv.X,buttonRIGHT.tv.Y,0,1,1)
			canvas.DrawImage(dragonRightAnim[animFrame],x,y,0,1,1)
			lastAnim=dragonRightAnim
		else
			canvas.DrawImage(buttonRIGHT.imgIdle,buttonRIGHT.tv.X,buttonRIGHT.tv.Y,0,1,1)
			canvas.DrawImage(lastAnim[animFrame],x,y,0,1,1)
		endif
		If buttonDOWN.down
			canvas.DrawImage(buttonDOWN.imgDown,buttonDOWN.tv.X,buttonDOWN.tv.Y,0,1,1)
			canvas.DrawImage(dragonDownAnim[animFrame],x,y,0,1,1)
			lastAnim=dragonDownAnim
		else
			canvas.DrawImage(buttonDOWN.imgIdle,buttonDOWN.tv.X,buttonDOWN.tv.Y,0,1,1)
			canvas.DrawImage(lastAnim[animFrame],x,y,0,1,1)
		endif
		
		canvas.Color=New Color(1.0,0.0,1.0)
		canvas.DrawText("x:"+x+" y:"+y,buttonLEFT.tv.X+buttonLEFT.Width,buttonLEFT.tv.Y+buttonLEFT.Height*.5-canvas.Font.Height*.5)
		canvas.Color=New Color(1.0,0.39,0.0)
		canvas.DrawText(titlemsg,title_x ,16,0,0)

	
		animFrame+=.10
		If animFrame>=4 Then animFrame=0
		
		OnUpdate()	' How can OnUpdate can be invoked automatically?
	   
	  End
	  
	  Method OnUpdate()
	  	'Reset gamepad keys
	  	resetPad()
	  	'check for mouse over
	  	CheckPadM()
	  	'check for touch on the screen
	  	CheckPadT()
	  	'check for key press
	  	CheckPadK()
	  End
	  
	  Method OnMeasure:Vec2i() Override
	    Return virtualResolution
	  End
	  
	  Method OnButtonUp:Void()
	  	'Print "Pad Up"
		  y-=1
		  If y<=-h*.5 Then y=virtualResolution.Y

	  End
	  
	  Method OnButtonLeft:Void()
	  	'Print "Pad Left"
	  	x-=1
		If x<=-w*.5 Then x=virtualResolution.X
	  End
	  
	  Method OnButtonRight:Void()
		'Print "Pad Right"
		x+=1
		If x>=virtualResolution.X+w*.5 Then x=0
	  End
	  
	  Method OnButtonDown:Void()
		'Print "Pad Down"
		 y+=1
		 If y>=virtualResolution.Y+h*.5 Then y=0
	  End

	  Method isTouchDown:Bool(butX:Float, butY:FLoat, butW:Float, butH:Float, butActive:Bool)
		Local touchpos:Vec2f
		Local k:Bool
	
		If Touch.FingerDown( 0 )	'Check for first Finger Hit
			touchpos = Touch.FingerLocation( 0 )
			If ( (touchpos.X > butX) And (touchpos.X < butX + butW) And (touchpos.Y > butY) And (touchpos.Y < butY + butH) And butActive)
				k = True
			Else
				k = False
			Endif
		endif
		If Touch.FingerDown(1)	'Check for second Finger Hit
			touchpos = Touch.FingerLocation( 1 )
			If ( (touchpos.X > butX) And (touchpos.X < butX + butW) And (touchpos.Y > butY) And (touchpos.Y < butY + butH) And butActive)
				k = True
			Else
				k = False
			EndIf
		EndIf
		Return k
	
	End
	
	Method isButtonHit:Bool(butX:Float, butY:FLoat, butW:Float, butH:Float, butActive:Bool)
		Local touchpos:Vec2f
		Local k:Bool
	
		'If Mouse.ButtonDown(MouseButton.Left)	'Check for first Finger Hit
			touchpos = Mouse.Location
			If ( (touchpos.X > butX) And (touchpos.X < butX + butW) And (touchpos.Y > butY) And (touchpos.Y < butY + butH) And butActive)
				k = True
			Else
				k = False
			EndIf
		'EndIf
		Return k
	
	End
	
	Method CheckPadM()
		If isButtonHit(buttonUP.tv.X,buttonUP.tv.Y,buttonUP.Width,buttonUP.Height,true) 
			buttonUP.down=True
			OnButtonUp()
			'Print "Pad UP"
		Elseif isButtonHit(buttonLEFT.tv.X,buttonLEFT.tv.Y,buttonLEFT.Width,buttonLEFT.Height,true)		
			OnButtonLeft()
			buttonLEFT.down=True
			'Print "Pad LEFT"
		Elseif isButtonHit(buttonRIGHT.tv.X,buttonRIGHT.tv.Y,buttonRIGHT.Width,buttonRIGHT.Height,true)	
			OnButtonRight()
			buttonRIGHT.down=True
			'Print "Pad RIGHT"
		Elseif isButtonHit(buttonDOWN.tv.X,buttonDOWN.tv.Y,buttonDOWN.Width,buttonDOWN.Height,true)	
			OnButtonDown()
			buttonDOWN.down=True
			'Print "Pad DOWN"
'		Else 
'			resetPad()
		End
	End
	
	Method CheckPadT()
		If  isTouchDown(buttonUP.tv.X,buttonUP.tv.Y,buttonUP.Width,buttonUP.Height,true)
			buttonUP.down=True
			OnButtonUp()
			'Print "Pad UP"
		Elseif  isTouchDown(buttonLEFT.tv.X,buttonLEFT.tv.Y,buttonLEFT.Width,buttonLEFT.Height,true)	
			OnButtonLeft()
			buttonLEFT.down=True
			'Print "Pad LEFT"
		Elseif  isTouchDown(buttonRIGHT.tv.X,buttonRIGHT.tv.Y,buttonRIGHT.Width,buttonRIGHT.Height,true)
			OnButtonRight()
			buttonRIGHT.down=True
			'Print "Pad RIGHT"
		Elseif  isTouchDown(buttonDOWN.tv.X,buttonDOWN.tv.Y,buttonDOWN.Width,buttonDOWN.Height,true)
			OnButtonDown()
			buttonDOWN.down=True
			'Print "Pad DOWN"
'		Else 
'			resetPad()
		End
	End
	
	Method CheckPadK()
	If Keyboard.KeyDown( Key.Up )
		OnButtonUp()
		buttonUP.down=True
	Elseif Keyboard.KeyDown( Key.Left )
		OnButtonLeft()
		buttonLEFT.down=True
	Elseif Keyboard.KeyDown( Key.Right )
		OnButtonRight()
		buttonRIGHT.down=True
	Elseif Keyboard.KeyDown( Key.Down )
		OnButtonDown()
		buttonDOWN.down=True
'	Else
'		resetPad()	
	Endif
	End
	
	Method resetPad()
		buttonUP.down=False
		buttonLEFT.down=False
		buttonRIGHT.down=False
		buttonDOWN.down=False
	End
	
	Method GrabImage:Image( x:Int,y:Int,w:Int,h:Int )
		Local image:=New Image( sprites,x,y,w,h )
		image.Handle=New Vec2f( 0.0,0.0 )' 0.0 = top, 0.5 = center, 1.0 botton
		Return image
	End
	
	Method GrabAnim:Image[]( x:Int,y:Int,w:Int,h:Int,count:Int,x_pitch:Int )
		Local images:=New Image[count]
		For Local i:=0 Until count
			images[i]=GrabImage( x,y,w,h )
			images[i].Handle=New Vec2f( .5,.5 )
			x+=x_pitch
		Next
		Return images
	End	
			
	Method  LoadSprites()
		
		sprites=Image.Load( "asset::dragon.png" )
		
		dragonUpAnim = GrabAnim(0,384,128,128,4,128)
		dragonLeftAnim = GrabAnim(0,128,128,128,4,128)
		dragonRightAnim = GrabAnim(0,256,128,128,4,128)
		dragonDownAnim = GrabAnim(0,0,128,128,4,128)
		lastAnim=dragonRightAnim
		
		'player position and size
		x=virtualResolution.X*.5;y=virtualResolution.Y*.5;w=128;h=128
	End
	
	Method InitPad()
		
		' up
		buttonUP=New APD_Button()
		buttonUP.imgIdle=Image.Load("asset::pad_up.png")
		buttonUP.imgDown=Image.Load("asset::pad_up_on.png")
		buttonUP.setSize()
		buttonUP.setLocation(New Vec2f(buttonUP.Width,virtualResolution.Y-buttonUP.Height*3))
		buttonUP.setHandle(New Vec2f(0.0,0.0))
		
		' left
		buttonLEFT=New APD_Button()
		buttonLEFT.imgIdle=Image.Load("asset::pad_left.png")
		buttonLEFT.imgDown=Image.Load("asset::pad_left_on.png")
		buttonLEFT.setSize()
		buttonLEFT.setLocation(New Vec2f(0,buttonUP.tv.Y+buttonUP.Height ))
		buttonLEFT.setHandle(New Vec2f(0.0,0.0))
		
		' right
		buttonRIGHT=New APD_Button()
		buttonRIGHT.imgIdle=Image.Load("asset::pad_right.png")
		buttonRIGHT.imgDown=Image.Load("asset::pad_right_on.png")
		buttonRIGHT.setSize()
		buttonRIGHT.setLocation(New Vec2f(buttonLEFT.tv.X+buttonLEFT.Width*2,buttonLEFT.tv.Y))
		buttonRIGHT.setHandle(New Vec2f(0.0,0.0))
		
		' down
		buttonDOWN=New APD_Button()
		buttonDOWN.imgIdle=Image.Load("asset::pad_down.png")
		buttonDOWN.imgDown=Image.Load("asset::pad_down_on.png")
		buttonDOWN.setSize()
		buttonDOWN.setLocation(New Vec2f(buttonLEFT.tv.X+buttonLEFT.Width,buttonLEFT.tv.Y+buttonLEFT.Height))
		buttonDOWN.setHandle(New Vec2f(0.0,0.0))
	End
	
	Method InitStars()
		For Local i:=0 To 100
			starList.AddLast(New Star(virtualResolution.X,virtualResolution.Y))
		Next
	End Method
	
	Method InitTitle()
		titlemsg = "Gamepad works with Mouse, Touch Screen and Keyboard - APD Games"
		titleln = titlemsg.Length
	End
	
	Method InitSound()
		channel= New Channel[maxchan]
		mute=True ' True = Muted, False= Play
		musicsnd=Sound.Load( "asset::intro.ogg" )
		dragonsnd=Sound.Load( "asset::dragon-wings.ogg" )
		
		For Local i:=0 Until channel.Length
			channel[i]=New Channel
			channel[chanidx].Rate=2.0
			channel[chanidx].Volume=0.3
		Next
'		Print "vol:"+channel.Volume
'		Print "pan:"+channel.Pan
'		Print "rate:"+channel.Rate
'		channel.Volume=.5
'		channel.Pan=0
'		channel.Rate=2.0
	End
	
	Method PlaySFX(sound:Sound, loop:Bool)
		If Not mute
			
			channel[chanidx].Play( sound, loop )
			chanidx+=1
			if chanidx>maxchan-1 Then chanidx = 0
		Endif
	End
End

Function Main()
	New AppInstance
	New MyApp( "Game Pad",640,480 )
	App.Run()
End

