'#Import "<std>"
'#Import "<mojo>"
 
'Using std..
'Using mojo..
'Using gles20..

#import "rameses3d"

#import "assets/deltafang-hold.3do"
#import "assets/tree.3do"
#import "assets/isphere2.3do"
#import "assets/orbit.3do"

#import "assets/sphere.3do"
#import "assets/rings.3do"

#import "assets/station.3do"
#import "assets/satelite.3do"
#import "assets/spaceship.3do"
#import "assets/asteroid.3do"
#import "assets/alienship.3do"


#import "assets/base.3do"
#import "assets/grid.3do"
#import "assets/gridcube.3do"
#import "assets/gridFlat.3do"
#import "assets/gridpin.3do"

#import "assets/orbit1.3do"
#import "assets/circle.3do"

#import "assets/orbit2.3do"
#import "assets/slice1.3do"
#import "assets/slice2.3do"
#import "assets/slice3.3do"

#import "assets/scifi.jpg"
#import "assets/uv.jpg"
 
Const Size := New Vec2i( 950,720 )
 
 


Class MyWindow Extends GLWindow
	field myShader:GLShader
	field myShader2:GLShader

	field my3d:Rameses3d
	
	field r3d_Ship:int
	field r3d_AlienShip:int

	field r3d_Station:int
	field r3d_Satelite:int
	field r3d_Asteroid:int

	field r3d_Planet:int
	field r3d_Rings:int
	
	field r3d_Orbit:int
	field r3d_Galaxy:int

	field r3d_Base:int
	field r3d_Grid:int
	field r3d_GridCube:int
	field r3d_GridFlat:int
	field r3d_GridPin:int
	
	field r3d_Orbit1:int
	field r3d_Circle:int

	field r3d_Orbit2:int
	field r3d_Slice1:int
	field r3d_Slice2:int
	field r3d_Slice3:int
	
	field tex:Texture

	field ox:float = 0
	field oy:float = -1
	field oz:float = -5
	field objectRotate:float = 0
	
	field sc:float = 1

	field shipDirection:int = 0
	field shipRotation:float = 0
	field shipXCell:int = 0
	field shipYCell:int = 0
	
	Method New()
		Super.New( "My Window", Size.X, Size.Y, WindowFlags.Resizable )
	    
		'this is a timer. it will 'tick' 60 times a second. calling OnUpdate
		_timer = New Timer( 60, OnUpdate )

		'if you want a constant canvas size use this
'		Layout = "letterbox"
		'or If you want the canvas to always fill the window use this
		Layout = "fill"

		InitShaders()

		
		'next initalize Rameses
		my3d = New Rameses3d( Width, Height )
		
		r3d_Ship = my3d.Load( "asset::spaceship.3do", myShader )
		r3d_AlienShip = my3d.Load( "asset::alienship.3do", myShader )

		r3d_Station = my3d.Load( "asset::station.3do", myShader )
		r3d_Satelite = my3d.Load( "asset::satelite.3do", myShader )
		r3d_Asteroid = my3d.Load( "asset::asteroid.3do", myShader )

		r3d_Planet = my3d.Load( "asset::sphere.3do", myShader )
		r3d_Rings = my3d.Load( "asset::rings.3do", myShader )

'		r3d_Ship = my3d.Load( "asset::tree.3do", myShader )
'		r3d_Ship = my3d.Load( "asset::uvtest.3do", myShader )
		r3d_Orbit = my3d.Load( "asset::orbit.3do", myShader )
		r3d_Galaxy = my3d.Load( "asset::isphere2.3do", myShader2 )

		r3d_Base = my3d.Load( "asset::base.3do", myShader )
		r3d_Grid = my3d.Load( "asset::grid.3do", myShader )
		r3d_GridCube = my3d.Load( "asset::gridcube.3do", myShader )
		r3d_GridFlat = my3d.Load( "asset::gridflat.3do", myShader )
		r3d_GridPin = my3d.Load( "asset::gridpin.3do", myShader )

		r3d_Orbit1 = my3d.Load( "asset::orbit1.3do", myShader )
		r3d_Circle = my3d.Load( "asset::circle.3do", myShader )

		r3d_Orbit2 = my3d.Load( "asset::orbit2.3do", myShader )
		r3d_Slice1 = my3d.Load( "asset::slice1.3do", myShader )
		r3d_Slice2 = my3d.Load( "asset::slice2.3do", myShader )
		r3d_Slice3 = my3d.Load( "asset::slice3.3do", myShader )
		
'		tex = Texture.Load( "asset::uv.jpg", TextureFlags.Dynamic )
		
'		glClearColor(0.1, 0.1, 0.5, 1.0)
		glClearColor(0, 0, 0, 1.0)

		glEnable(GL_CULL_FACE)
		glEnable(GL_DEPTH_TEST)
	End
	
	method InitShaders()
		'first get the shader
		myShader = New GLShader()

		Local vertex:String = "
		uniform mat4 Matrix;
		uniform vec3 Color;
		uniform vec4 Light;
		uniform vec3 LightColor;
		uniform float mx2_Time;
		attribute vec4 mx2_Vertex;
		attribute vec4 mx2_Color;
		attribute vec4 mx2_Normal;
		attribute vec2 mx2_UV;
		attribute float mx2_Data1;
		attribute float mx2_Data2;
		varying vec3 OutColor;
		varying vec3 OutNormal;
		varying vec4 Light1;
		varying vec2 UV;
		varying float Time;
		void main() {
			UV = mx2_UV;
			Time = mx2_Time;

			vec4 position = Matrix * mx2_Vertex;
			gl_Position = position;
			vec4 normal = Matrix * mx2_Normal;
			OutNormal = normal.xyz;
			
			Light1 = normalize(vec4(position.xyz-Light.xyz, 0.0));
			Light1 *= 0.4;
	
			OutColor = mix( mx2_Color.rgb, Color, 1.0-mx2_Color.a ) * LightColor;
//			OutColor = Color;
//			OutColor = mx2_Color.rgb * LightColor;
//			OutColor = vec3( UV, 0.0 );
//			OutColor = OutNormal;
//			OutColor = (mx2_Vertex.rgb+0.25)*1.5;
		}
	"
	 
		Local fragment:String = "
		uniform sampler2D TextureSampler;
		varying vec3 OutColor;
		varying vec3 OutNormal;
		varying vec4 Light1;
		varying vec2 UV;
		varying float Time;

		float field(in vec3 p,float s,  int idx) {
			float strength = 7. + .03 * log(1.e-6 + fract(sin(Time) * 4373.11));
			float accum = s/4.;
			float prev = 0.;
			float tw = 0.;
			for (int i = 0; i < 26; ++i) {
				float mag = dot(p, p);
				p = abs(p) / mag + vec3(-.5, -.4, -1.5);
				float w = exp(-float(i) / 7.);
				accum += w * exp(-strength * pow(abs(mag - prev), 2.2));
				tw += w;
				prev = mag;
			} 
			return max(0., 5. * accum / tw - .7);
		}
		
		vec3 nrand3( vec2 co ){
			vec3 a = fract( cos( co.x*8.3e-3 + co.y )*vec3(1.3e5, 4.7e5, 2.9e5) );
			vec3 b = fract( sin( co.x*0.3e-3 + co.y )*vec3(8.1e5, 1.0e5, 0.1e5) );
			vec3 c = mix(a, b, 0.5);
			return c;
		}
		
		
		float snoise(vec3 uv, float res){
			const vec3 s = vec3(1e0, 1e2, 1e3);
		
			uv *= res;
		
			vec3 uv0 = floor(mod(uv, res))*s;
			vec3 uv1 = floor(mod(uv+vec3(1.), res))*s;
		
			vec3 f = fract(uv); f = f*f*(3.0-2.0*f);
		
			vec4 v = vec4(uv0.x+uv0.y+uv0.z, uv1.x+uv0.y+uv0.z, uv0.x+uv1.y+uv0.z, uv1.x+uv1.y+uv0.z);
		
			vec4 r = fract(sin(v*1e-1)*1e3);
			float r0 = mix(mix(r.x, r.y, f.x), mix(r.z, r.w, f.x), f.y);
		
			r = fract(sin((v + uv1.z - uv0.z)*1e-1)*1e3);
			float r1 = mix(mix(r.x, r.y, f.x), mix(r.z, r.w, f.x), f.y);
		
			return mix(r0, r1, f.z)*2.-1.;
		}


		void main(){
			vec2 uv = UV;
			
			vec2 uvs = vec2(cos(uv.x), uv.y);
			
			vec3 p = vec3(uvs / 4., 0) + vec3(1., -1.3, 0.);
			p += vec3(sin(16.), sin(12.),  sin(128.));
		
			float freqs[4];
			freqs[0] = 0.05;
			freqs[1] = 0.3;
			freqs[2] = 0.3;
			freqs[3] = 0.7;
			
			float width = 4096.0;
		
			float t = 1.0-cos(field(p, freqs[3], 26));
			float v = (1. - exp((abs(uv.x) - 1.) * 6.)) * (1. - exp((abs(uv.y) - 1.) * 6.));
		
			vec2 pp = uv;
			pp.x = pp.x*3.0 - 2.0;
			pp.y = pp.y*4.0 - 2.0;
			pp.y = -pp.y ;
	
			p.x *= 0.5;
			  	
			float color = 3.0 - (6.*length(pp));
	
			vec3 coord = vec3(atan(pp.x,pp.y)/6.2832, length(pp)*0.4, .5);
	
			for(int i = 1; i <= 7; i++){
				float power = pow(2.0, float(i));
//				color += (1.5 / power) * snoise(coord + vec3(0.,-0.*.05, 0.*.01), power*16.);
				color += (1.5 / power) * snoise(coord + vec3(0.,-Time*.000005, Time*.000005), power*16.);
			}
	
			vec4 c2 = vec4( color*0.1, pow(max(color,0.),2.)*0.01, pow(max(color,0.),3.)*0.05 , 1.0);//*0.2;



			
			vec4 starcolor = vec4(0.0, 0.0, 0.0, 0.0);

			//Let's add some stars
			vec2 seed = p.xy * 12.0;
			seed = floor(seed * 2.0 * width);
			vec3 rnd = nrand3( seed );
			starcolor += vec4(pow(rnd.y, 50.0));
		
			//Second Layer
			vec2 seed2 = p.xy * 4.0;
			seed2 = floor(seed2 * width);
			vec3 rnd2 = nrand3( seed2 );
			starcolor += vec4(pow(rnd2.y,85.0)) * 2.0;
			
			vec4 bgColor = vec4(1.5*freqs[2] * t * t* t , 1.2*freqs[1] * t * t, sin(freqs[3]*t), 1.0);
			
			vec4 outColor = bgColor + c2 + starcolor;

//			vec3 coloruv = texture2D( TextureSampler, UV ).rgb;
//			vec4 coloruv2 = vec4( coloruv, 1.0) * 0.5;

			gl_FragColor = outColor;// + coloruv2;
		}
	"
		myShader2 = New GLShader( vertex, fragment )
	End method

	
	Method OnUpdate()
'		_gameTime = Millisecs()
		
'		RequestRender()
	End Method


	Method OnRender(canvas:mojo.graphics.Canvas) Override
		App.RequestRender()
		Super.OnRender(canvas)

		'set up a measure that will recalculate if the window is resized
		If _width <> Width or _height <> Height Then
			my3d.SetRes( Width, Height )
			'The Page Must be laid out
'			Page.OnRecalcLayout( 0, 0, Width, Height )
			

'			local texint:GLuint = tex.GLTexture
'			tex.Bind( 0, TextureFilter.None )

			_width = Width
			_height = Height
		End if


		canvas.DrawText("lx "+shipXCell, 10, 10)
		canvas.DrawText("ly "+shipYCell, 10, 30)

		canvas.DrawText("left/right = turn,  up/down", 80, 10)

'		canvas.DrawText("lx "+my3d.lx, 10, 10)
'		canvas.DrawText("ly "+my3d.ly, 10, 30)
'		canvas.DrawText("lz "+my3d.lz, 10, 50)

'		canvas.DrawText("ox "+ox, 80, 10)
'		canvas.DrawText("oy "+oy, 80, 30)
'		canvas.DrawText("oz "+oz, 80, 50)
		
'		canvas.Color = Color.White
'		canvas.DrawLine( 0, Height*0.5, Width, Height * 0.5 )
'		canvas.DrawLine( Width*0.5, 0, Width*0.5, Height )
		canvas.DrawText( "FPS="+App.FPS,Width,0,1,0 )
'		canvas.DrawText( "Mojo Rendering+OpenGL rendering!",Width/2,Height/2,.5,.5 )
	End

	
	Method OnKeyEvent( event:KeyEvent ) Override
		'heres the best way to check for shift keys etc
		local shift:bool = event.Modifiers & Modifier.Shift
		
		Select event.Type
			case EventType.KeyDown
			
				Select event.Key
'					Case Key.LeftBracket
'						sc -= 0.1
'					Case Key.RightBracket
'						sc += 0.1
					Case Key.Up
						Select shipDirection
							Case 0 'right
								shipXCell += 1
							Case 1 'up
								shipYCell -= 1
							Case 2 'left
								shipXCell -= 1
							Case 3 'down
								shipYCell += 1
						End Select
'						shipYCell -= 1
'						If shift Then
'							my3d.lz += 1
'						Else
'							my3d.ly += 1
'						End If
					Case Key.Down
						Select shipDirection
							Case 0 'right
								shipXCell -= 1
							Case 1 'up
								shipYCell += 1
							Case 2 'left
								shipXCell += 1
							Case 3 'down
								shipYCell -= 1
						End Select
'						shipYCell += 1
'						If shift Then
'							my3d.lz -= 1
'						Else
'							my3d.ly -= 1
'						End If
					Case Key.Left
						shipRotation += Pi *0.5
						shipDirection += 1
						If shipDirection > 3 Then shipDirection = 0
'						shipXCell -= 1
'						my3d.lx -= 1
					Case Key.Right
						shipRotation -= Pi * 0.5
						shipDirection -= 1
						If shipDirection < 0 Then shipDirection = 3
'						shipXCell += 1
'						my3d.lx += 1
				End Select
				
				shipXCell = Clamp( shipXCell, -8, 7 )
				shipYCell = Clamp( shipYCell, -8, 7 )
		End Select
		
	End method


	Method OnRenderGL() Override
'		glClearColor( 0,0,1,1 )
		
'		glClearDepthf( 0 )
		
		glClearStencil( 0 )
		
		glClear( GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT|GL_STENCIL_BUFFER_BIT )


		'Drawing area. You're always drawing to the entire window in GL regardless of Layout.
		'
		'Don't really need this for this example is it only affects glDrawBlah, but nice to know...
		'
		glViewport( 0,0,Frame.Width,Frame.Height )


'		glFlush()
		
		'clear the screen buffers
'		glClear( GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT)
'		glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT )


		
		Local pitch:float = Sin(App.Millisecs*0.001)
		Local rotate:float = App.Millisecs * -0.0005
		Local roll:float = 0

'		my3d.DrawModel( r3d_Ship, ox, oy, oz, Color.Grey, sc*0.1, 1.6, pitch, roll )
'		my3d.DrawLines( r3d_Ship, ox, oy, oz, Color.White, sc*1.01, 1.6, Sin(App.Millisecs*0.0001)  )

		my3d.DrawModel( r3d_Galaxy, 0, 0, -50, 0, Color.White, 200, rotate*0.03 )

'		my3d.DrawModel( r3d_Planet, my3d.lx, my3d.ly, my3d.lz, 0, Color.White, 0.1 )
'		my3d.DrawPoints( r3d_Planet, my3d.lx, my3d.ly, my3d.lz, Color.White, 1, App.Millisecs * 0.0005 )
'		my3d.DrawLines( r3d_Planet, my3d.lx, my3d.ly, my3d.lz, Color.White, 1, App.Millisecs * 0.0005 )


		Local scale:float = 1.6
		my3d.viewPoint = 1.7
		my3d.DrawModel( r3d_Base, 0, -1.52, -3.7, 0,  Color.Black, sc*scale, 0)
'		my3d.DrawLines( r3d_Grid, 0, -1.5, -3.7, 1,  Color.Cyan*0.5, sc*scale, 0)

		Local sc2:float = scale * 0.1
		Local sc3:float = sc2 * 0.5
		Local sc4:float = sc2 * 1.8
		Local xp:int = shipXCell
		Local yp:int = shipYCell
		my3d.DrawModel( r3d_Ship, sc3+sc2*xp, -1.5+sc4, -3.7+sc2*yp+sc3, 1,  Color.White*1.5, sc3, shipRotation )
		my3d.DrawModel( r3d_GridPin, sc3+sc2*xp, -1.5, -3.7+sc2*yp+sc3, 1,  Color.Grey, sc*scale )

		xp = 6
		yp = -2
		my3d.DrawModel( r3d_AlienShip, sc3+sc2*xp, -1.5+sc4, -3.7+sc2*yp+sc3, 1,  Color.Grey, sc4, 3 )
		my3d.DrawModel( r3d_GridPin, sc3+sc2*xp, -1.5, -3.7+sc2*yp+sc3, 1,  Color.Brown*0.5, sc*scale )

'		xp = 2
'		yp = -6
'		my3d.DrawModel( r3d_Planet, sc3+sc2*xp, -1.15+sc4, -3.7+sc2*yp+sc3, 1,  Color.Steel, sc3*13, objectRotate*0.1 )
'		my3d.DrawModel( r3d_Rings, sc3+sc2*xp, -1.15+sc4, -3.7+sc2*yp+sc3, 1,  Color.Steel, sc3*13, objectRotate*0.1, 0.2 )
'		my3d.DrawModel( r3d_GridPin, sc3+sc2*xp, -1.5, -3.7+sc2*yp+sc3, 1,  Color.Steel, sc*scale )

		xp = -6
		yp = 2
		objectRotate += 0.01
		my3d.DrawModel( r3d_Satelite, sc3+sc2*xp, -1.5+sc4, -3.7+sc2*yp+sc3, 1,  Color.White, sc3*5, 1 )
		my3d.DrawModel( r3d_GridPin, sc3+sc2*xp, -1.5, -3.7+sc2*yp+sc3, 1,  Color.Grey, sc*scale )

		xp = -2
		yp = 5
		my3d.DrawModel( r3d_Station, sc3+sc2*xp, -1.5+sc4, -3.7+sc2*yp+sc3, 1,  Color.Grey, sc3*7, 0, objectRotate*0.13, 0.7 )
		my3d.DrawModel( r3d_GridPin, sc3+sc2*xp, -1.5, -3.7+sc2*yp+sc3, 1,  Color.Grey, sc*scale )


			xp = -3
			yp = -2
			my3d.DrawModel( r3d_Asteroid, sc3+sc2*xp, -1.5, -3.7+sc2*yp+sc3, 0.6,  Color.DarkGrey, sc*scale*0.4, objectRotate)
			my3d.DrawModel( r3d_GridPin, sc3+sc2*xp, -1.5, -3.7+sc2*yp+sc3, 1,  Color.Red*0.5, sc*scale*0.5 )


		my3d.viewPoint = 1.7
		my3d.DrawLines( r3d_Grid, 0, -1.5, -3.7, 1,  Color.Cyan*0.5, sc*scale, 0)

		'draw bottom ship
		my3d.DrawLines( r3d_Ship, -0.45, -0.34, -1, 0,  Color.Pine, sc*0.03, rotate, pitch, roll )
		my3d.DrawLines( r3d_Orbit, -0.45, -0.36, -1, 0,  Color.Pine*0.4, sc*0.08, rotate-0.9, pitch, roll )

		'draw current system
'		my3d.DrawPoints( r3d_Planet, 0.45, -0.365, -1, Color.Pine, 0.03 )
		
'		my3d.DrawLines( r3d_Orbit1, 0.45, -0.365, -1, Color.Pine*0.3, 0.1 )
'		my3d.DrawPoints( r3d_Planet, 0.45+0.04, -0.365, -1, Color.Pine, 0.02 )

'		my3d.DrawLines( r3d_Orbit1, 0.45, -0.365, -1, Color.Pine*0.3, 0.2 )
'		my3d.DrawPoints( r3d_Planet, 0.45+0.08, -0.365, -1, Color.Pine, 0.01 )

'		my3d.DrawLines( r3d_Orbit1, 0.45, -0.365, -1, Color.Pine*0.3, 0.24 )

'		my3d.DrawLines( r3d_Orbit1, 0.45, -0.365, -1, Color.Pine*0.3, 0.34 )
'		my3d.DrawPoints( r3d_Planet, 0.45-0.095, -0.365, -1, Color.Pine, 0.01 )

		'draw main viewer
		my3d.viewPoint = 0
		my3d.DrawLines( r3d_Orbit2, 0, -0.3, -1, 0,  Color.Pine*0.5, sc*1, 0 )

'		glEnable(GL_BLEND)
'		glBlendFunc(GL_SRC_ALPHA, GL_ONE)
		
'			my3d.DrawModel( r3d_Circle, 0, -0.3, -1, Color.Pine*0.1, sc, 0 )
'		
'			my3d.DrawModel( r3d_Slice1, 0, -0.3, -1, Color.Orange*0.4, sc*1.1, 0 )
'			my3d.DrawModel( r3d_Slice2, 0, -0.3, -1, Color.Brown*0.3, sc*0.9, 0 )
'			my3d.DrawModel( r3d_Slice3, 0, -0.3, -1, Color.Brown*0.2, sc*0.8, 0 )
'		
'		glDisable(GL_BLEND)

		'draw transparent things
		my3d.viewPoint = 1.7
		glEnable(GL_BLEND)
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA)

			xp = 2
			yp = -6
			my3d.DrawModel( r3d_Planet, sc3+sc2*xp, -1.15+sc4, -3.7+sc2*yp+sc3, 0.5,  Color.Steel, sc3*13, objectRotate*0.1 )
			my3d.DrawModel( r3d_Rings, sc3+sc2*xp, -1.15+sc4, -3.7+sc2*yp+sc3, 0.6,  Color.Steel, sc3*13, objectRotate*0.1, 0.2 )
			my3d.DrawModel( r3d_GridPin, sc3+sc2*xp, -1.5, -3.7+sc2*yp+sc3, 0.8,  Color.Steel, sc*scale )
			xp = 1
			yp = -7
			my3d.DrawModelHeight( r3d_GridFlat, sc3+sc2*xp, -1.5, -3.7+sc2*yp+sc3, 0.6,  Color.Grey, sc*scale, 0)
			xp = 2
			my3d.DrawModelHeight( r3d_GridFlat, sc3+sc2*xp, -1.5, -3.7+sc2*yp+sc3, 0.6,  Color.Grey, sc*scale, 0)
			xp = 3
			my3d.DrawModelHeight( r3d_GridFlat, sc3+sc2*xp, -1.5, -3.7+sc2*yp+sc3, 0.6,  Color.Grey, sc*scale, 0)
			xp = 1
			yp = -6
			my3d.DrawModelHeight( r3d_GridFlat, sc3+sc2*xp, -1.5, -3.7+sc2*yp+sc3, 0.6,  Color.Grey, sc*scale, 0)
			xp = 3
			my3d.DrawModelHeight( r3d_GridFlat, sc3+sc2*xp, -1.5, -3.7+sc2*yp+sc3, 0.6,  Color.Grey, sc*scale, 0)
			xp = 1
			yp = -5
			my3d.DrawModelHeight( r3d_GridFlat, sc3+sc2*xp, -1.5, -3.7+sc2*yp+sc3, 0.6,  Color.Grey, sc*scale, 0)
			xp = 2
			my3d.DrawModelHeight( r3d_GridFlat, sc3+sc2*xp, -1.5, -3.7+sc2*yp+sc3, 0.6,  Color.Grey, sc*scale, 0)
			xp = 3
			my3d.DrawModelHeight( r3d_GridFlat, sc3+sc2*xp, -1.5, -3.7+sc2*yp+sc3, 0.6,  Color.Grey, sc*scale, 0)

			xp = 2
			yp = 2
			my3d.DrawModelHeight( r3d_GridCube, sc3+sc2*xp, -1.5, -3.7+sc2*yp+sc3, 0.6,  Color.Grey, sc*scale, 0.2)
			my3d.DrawModelHeight( r3d_GridFlat, sc3+sc2*xp, -1.5, -3.7+sc2*yp+sc3, 0.6,  Color.Aqua, sc*scale, 0.2)
			xp = 3
			yp = 2
			my3d.DrawModelHeight( r3d_GridCube, sc3+sc2*xp, -1.5, -3.7+sc2*yp+sc3, 0.6,  Color.Grey, sc*scale, 0.4)
			my3d.DrawModelHeight( r3d_GridFlat, sc3+sc2*xp, -1.5, -3.7+sc2*yp+sc3, 0.6,  Color.Aqua, sc*scale, 0.4)
			
			xp = -1
			yp = 5
			my3d.DrawModelHeight( r3d_GridFlat, sc3+sc2*xp, -1.5, -3.7+sc2*yp+sc3, 0.6,  Color.Grey, sc*scale, 0)
			xp = -3
			my3d.DrawModelHeight( r3d_GridFlat, sc3+sc2*xp, -1.5, -3.7+sc2*yp+sc3, 0.6,  Color.Grey, sc*scale, 0)
			xp = -2
			yp = 4
			my3d.DrawModelHeight( r3d_GridFlat, sc3+sc2*xp, -1.5, -3.7+sc2*yp+sc3, 0.6,  Color.Grey, sc*scale, 0)
			yp = 6
			my3d.DrawModelHeight( r3d_GridFlat, sc3+sc2*xp, -1.5, -3.7+sc2*yp+sc3, 0.6,  Color.Grey, sc*scale, 0)
'			xp = -3
'			yp = -2
'			my3d.DrawModelHeight( r3d_GridCube, sc3+sc2*xp, -1.5, -3.7+sc2*yp+sc3, 0.6,  Color.Grey, sc*scale, 0.4)
'			my3d.DrawModelHeight( r3d_GridFlat, sc3+sc2*xp, -1.5, -3.7+sc2*yp+sc3, 0.6,  Color.Red, sc*scale, 0.4)
		glDisable(GL_BLEND)
	End

	
private	
	'the timer ticks 60 times a second and handles the screen update
	Field _timer:Timer

	'global window size to track when window has changed
	field _width:int = 0
	field _height:int = 0
End
 
 
Function Main()
	Local cfg := New StringMap<String>
	
	cfg["GL_depth_buffer_enabled"] = 1
	cfg["GL_stencil_buffer_enabled"] = 1
	
	New AppInstance( cfg )

	New MyWindow
	App.Run()
End