#Import "<std>"
#Import "<mojo>"
 
Using std..
Using mojo..
Using gles20..

#import "matrix"


Class R3dLoader Extends ResourceManager
	field Vertices:Float[]
	'NOTE anticlockwise winding!!!!!!
	field Elements:int[]
	
	field ElementLength:int
	
	field NormalX:float
	field NormalY:float
	field NormalZ:float


	method New()
	End method
	
	method New( path:string )
		Load( path )
	End method
	
	method Load:bool( path:string )
		_pathname = path
		Local file := Stream.Open( path, "r" )
		If Not file Then
			Print "Cant Load "+path
			Return False
		End If
		
		Local str:string
		
		str = String.FromChar( file.ReadByte() )
		str += String.FromChar( file.ReadByte() )
		str += String.FromChar( file.ReadByte() )
		str += String.FromChar( file.ReadByte() )
'		Print str
		If str <> "RIFF" Then
			file.Close()
			Print "Error: Initial Header RIFF missing"
			return False
		End If
		Local fileLength:int = file.ReadInt()

		Local Error:Int = False
		Local k:Int
		Local CurrentModel:Int = - 1
		
		Local ModelCount:Int = 0
		Local modelref:int[] = new Int[2000]
		
		Local axisx:Float
		Local axisy:Float
		Local axisz:Float
		
		Local checkGUID:Int = False
		
		Local ID:string
		Local FileLength:Int
		Local chunk:Int = 0
		Local chunksize:Int = 0
		
		FileLength = file.Length
			
		Local Version:Int = - 1
		Local Stored:Int
		Local Objects:Int
				
		Local colorCount:Int = 0
		Local r:float
		Local g:float
		Local b:float
		Local a:float
		Local ColExists:Int
		
		Local SaveColRef:Color[] = New Color[1024]
		Local VertX:float[]
		Local VertY:float[]
		Local VertZ:float[]
		
		Local Faces0:short[]
		Local Faces1:short[]
		Local Faces2:short[]
		Local FaceCol0:short[]
		Local FaceCol1:short[]
		Local FaceCol2:short[]
		Local FaceUVX0:float[]
		Local FaceUVX1:float[]
		Local FaceUVX2:float[]
		Local FaceUVY0:float[]
		Local FaceUVY1:float[]
		Local FaceUVY2:float[]
		
		Local VertexRef:short[]
		Local VertexVert:short[]
		Local VertexCol:short[]
		Local VertexUV:short[]
		Local VertexCount:int = -1
				
		Local name:String
				
		Local x:Float
		Local y:Float
		Local z:Float
				
		Local col1:Int
		Local col2:Int
		Local col3:Int
		Local uvx1:Float
		Local uvy1:Float
		Local uvx2:Float
		Local uvy2:Float
		Local uvx3:Float
		Local uvy3:Float
				
		'now cycle through the data and process
			
		'load the header
		
		While Not(Error) And file.Position < FileLength
			If Not file.Eof Then
				ID = String.FromChar( file.ReadByte() )
				If Not file.Eof Then
					ID += String.FromChar( file.ReadByte() )
					If Not file.Eof Then
						ID += String.FromChar( file.ReadByte() )
						If Not file.Eof Then
							ID += String.FromChar( file.ReadByte() )
						Else
							Error = True
						End If
					Else
						Error = True
					End If
				Else
					Error = True
				End If
			Else
				Error = True
			End If

			If Error Then
				file.Close()
				Print "Error with Header"
				Exit
			End If

			chunksize = 0
			If Not file.Eof Then
				'get the chunksize
				chunksize = file.ReadInt()
			Else
				file.Close()
				Error = True
				Exit
			End If

'			Print "chunk id=" + ID+" size="+chunksize+" chunk="+chunk

			Select ID
				Case "RAMO"
					If chunk > 0 Then Exit
					
				Case "form"	
'					If chunk < 1 Then Exit
							
					Version = file.ReadShort()
					Stored = file.ReadShort()
					Objects = file.ReadShort()
							
'					Print "~nform Version=" + Version
					Select Stored
						Case 1
							Print "contents = "+Objects+" type=model"
						Case 2
							Print "contents = "+Objects+" type=group"
						Case 3
							Print "contents = " + Objects+" type=multiple"
					End Select		
							
					file.ReadShort()
	
					file.ReadShort()
					file.ReadShort()
					file.ReadShort()
					file.ReadShort()
#jump colors
				Case "cols"	
'					Print chunk+" "+Version
					If Version < 1 Then Exit
					colorCount = file.ReadInt()
'					Print "Colors = " + colorCount
					For k = 0 until colorCount
						r = float( file.ReadUByte() )/255
						g = float( file.ReadUByte() )/255
						b = float( file.ReadUByte() )/255
						a = float( file.ReadUByte() )/255
						
						SaveColRef[k] = New Color( r, g, b, a )

'						ColExists = AddColori(r, g, b, a)
'						SaveColRef[k] = ColExists
'							SaveColRef[ColExists] = k
						
'						Print "color=" + k + "  r=" + SaveColRef[k].r + " g=" + SaveColRef[k].g + " b=" + SaveColRef[k].b + " a=" + a
'								Print "ref="+colexists+" col="+SaveColRef[k]
					Next	

				Case "name"
'					Print"name chunk="+chunk+" version="+version
					If Version < 1 Then Exit
					
					local str:string = ""
					For k = 1 To chunksize
						str += String.FromChar( file.ReadByte() )
					Next
					name = str
'					Print "name="+name
'					If Not(ignoreLoad) Then
'						ModelBegin(ModelPtr - 1, name, OBJECT_MODEL)
'						Models[ModelPtr].Filename = StripDir(filename)
'					End If
				
				Case "guid"
					If Version < 1 Then Exit

					local str:string = ""
					For k = 1 To chunksize
						str += String.FromChar( file.ReadByte() )
					Next
					name = str
'					Print "guid name="+name
#jump material									
				Case "mat7"	
					If Version < 1 Then Exit

					Local nimage1x:Int
					Local nimage1y:Int
					Local nimage1width:Int
					Local nimage1height:Int
					Local nimage2x:Int
					Local nimage2y:Int
					Local nimage2width:Int
					Local nimage2height:Int

					Local nAlphaOn:Int

					Local nisLight:Int
					Local nisFauxLight:Int
					Local nisGlass:Int
					Local nis2Sided:Int
					Local ncastShadow:Int
					Local nReflect:Int
					Local nShine:Int
					Local fAlpha:Int
					Local nMaterial:Int
					Local nData1:Int
					Local nData2:Int
					Local nData3:Int
					Local nData4:Int
					Local nSmooth:Int
					Local nInvert:Int
					Local nRaise:Int
					Local nSAlpha:Int
					Local nSSS:Int
					Local nSSScatter:Int
					Local nSSBounce:Int
					Local nBump:Int
					Local nFade:Int

					Local nRed2:Int
					Local nGreen2:Int
					Local nBlue2:Int

					nimage1x = file.ReadInt()
					nimage1y = file.ReadInt()
					nimage1width = file.ReadInt()
					nimage1height = file.ReadInt()
					nimage2x = file.ReadInt()
					nimage2y = file.ReadInt()

					nimage2width = file.ReadInt()
					nimage2height = file.ReadInt()
					
'					Print nimage1x+" "+nimage1y+" "+nimage1width+" "+nimage1height+" "+nimage2x+" "+nimage2y+" "+nimage2width+" "+nimage2height

					
					nAlphaOn = file.ReadInt()

					nisLight = file.ReadInt()
					nisFauxLight = file.ReadInt()
					nisGlass = file.ReadInt()
					nis2Sided = file.ReadInt()
					ncastShadow = file.ReadInt()
					nReflect = file.ReadInt()
					nShine = file.ReadInt()

					fAlpha = file.ReadFloat()
					nMaterial = file.ReadInt()
					nData1 = file.ReadInt()
					nData2 = file.ReadInt()
					nData3 = file.ReadInt()
					nData4 = file.ReadInt()
					nSmooth = file.ReadInt()
					nInvert = file.ReadInt()
					nRaise = file.ReadInt()
					nSAlpha = file.ReadInt()
					nSSS = file.ReadInt()
					nSSScatter = file.ReadInt()
					nSSBounce = file.ReadInt()
					nBump = file.ReadInt()
					nFade = file.ReadInt()

					nRed2 = file.ReadInt()
					nGreen2 = file.ReadInt()
					nBlue2 = file.ReadInt()
#rem
					If Not(ignoreLoad) And models[modelptr] Then
						Models[ModelPtr].image1x = nimage1x
						Models[ModelPtr].image1y = nimage1y
						Models[ModelPtr].image1width = nimage1width
						Models[ModelPtr].image1height = nimage1height
						Models[ModelPtr].image2x = nimage2x
						Models[ModelPtr].image2y = nimage2y

						Models[ModelPtr].image2width = nimage2width
						Models[ModelPtr].image2height = nimage2height
						Models[ModelPtr].AlphaOn = nAlphaOn

						Models[ModelPtr].isLight = nisLight
						Models[ModelPtr].isFauxLight = nisFauxLight
						Models[ModelPtr].isGlass = nisGlass
						Models[ModelPtr].is2Sided = nis2Sided
						Models[ModelPtr].castShadow = ncastShadow
						Models[ModelPtr].Reflect = nReflect
						Models[ModelPtr].Shine = nShine

						Models[ModelPtr].Alpha = fAlpha
						Models[ModelPtr].Material = nMaterial
						Models[ModelPtr].Data1 = nData1
						Models[ModelPtr].Data2 = nData2
						Models[ModelPtr].Data3 = nData3
						Models[ModelPtr].Data4 = nData4
						Models[ModelPtr].Smooth = nSmooth
						Models[ModelPtr].Invert = nInvert
						Models[ModelPtr].Raise = nRaise
						Models[ModelPtr].SSS = nSSS
						Models[ModelPtr].SSScatter = nSSScatter
						Models[ModelPtr].SSBounce = nSSBounce
						Models[ModelPtr].Bump = nBump
						Models[ModelPtr].Fade = nFade

						Models[ModelPtr].Red2 = nRed2
						Models[ModelPtr].Green2 = nGreen2
						Models[ModelPtr].Blue2 = nBlue2
					End If
#end					

				Case "axis"
					If Version < 1 Then Exit

					axisx = file.ReadFloat()
					axisy = file.ReadFloat()
					axisz = file.ReadFloat()
#jump vertexes
				Case "vrt2"
					If Version < 1 Then Exit

					Local vertexCount:int = chunksize / 16
'					Print "vertexes = "+ vertexCount
					Local bend:Float
					
					VertX = New float[vertexCount]
					VertY = New float[vertexCount]
					VertZ = New float[vertexCount]

'					If Not(ignoreLoad) Then
'						VertexBegin()
						For k = 0 until vertexCount
							x = file.ReadFloat()
							y = file.ReadFloat()
							z = file.ReadFloat()
							bend = file.ReadFloat()
							
							VertX[k] = x
							VertY[k] = y
							VertZ[k] = -z
'								Print "vertex=" + k + " x=" + x + " y=" + y + " z=" + z
						
'							AddVertex(VertexPos, x,y,z)
'							BendVertexes[VertexPos] = bend
						
'							IncVertex()
						Next
'						VertexEnd()
'					Else
'						For k = 0 until (chunksize / 16)
'							x = file.ReadFloat()
'							y = file.ReadFloat()
'							z = file.ReadFloat()
'							bend = file.ReadFloat()
'
'							Vert0[k] = x
'							Vert1[k] = y
'							Vert2[k] = z
'						Next	
'					End If

				Case "bend"
					If Version < 1 Then Exit
					
					x = file.ReadFloat()
					y = file.ReadFloat()
					z = file.ReadFloat()
					
'					If Not(ignoreLoad) Then
'						Models[ModelPtr].bend = x
'						Models[ModelPtr].bendjitter = y
'						Models[ModelPtr].bendjitterspeed = z
'					End If

				Case "lod1"
'							Print"name chunk="+chunk+" version="+version
					If Version < 1 Then Exit

					Local nIn:Int
					nIn = file.ReadInt()
'							Print "LOD in="+nin
'					If Not(ignoreLoad) Then
'						Models[ModelPtr].LOD = nIn
'					End If
#jump faces
				Case "fac2"
					If Version < 1 Then Exit
					Local faceCount:int = chunksize / 48
'					Print "faces = "+ faceCount
					
					Faces0 = New short[faceCount]
					Faces1 = New short[faceCount]
					Faces2 = New short[faceCount]
					FaceCol0 = New short[faceCount]
					FaceCol1 = New short[faceCount]
					FaceCol2 = New short[faceCount]
					FaceUVX0 = New float[faceCount]
					FaceUVX1 = New float[faceCount]
					FaceUVX2 = New float[faceCount]
					FaceUVY0 = New float[faceCount]
					FaceUVY1 = New float[faceCount]
					FaceUVY2 = New float[faceCount]
					
					VertexVert = New short[faceCount * 3]
					VertexCol = New short[faceCount * 3]
					Local l:int

					'NOTE anticlockwise winding!!!!!!
					Elements = New int[faceCount * 3]

'					If Not(ignoreLoad) Then
'						FaceBegin()
						For k = 0 until faceCount
							Faces0[k] = file.ReadInt()
							Faces1[k] = file.ReadInt()
							Faces2[k] = file.ReadInt()
							
							col1 = file.ReadInt()
							col2 = file.ReadInt()
							col3 = file.ReadInt()
							
							If col1 = -1 Then col1 = 1
							If col2 = -1 Then col2 = 1
							If col3 = -1 Then col3 = 1

							If col1 > colorCount Then col1 = colorCount
							If col2 > colorCount Then col2 = colorCount
							If col3 > colorCount Then col3 = colorCount
							
							FaceCol0[k] = col1
							FaceCol1[k] = col2
							FaceCol2[k] = col3
							
'									Print "Colcount="+colorcount+"  "+col1+" "+col2+" "+col3

							uvx1 = file.ReadFloat()
							uvy1 = file.ReadFloat()

							uvx2 = file.ReadFloat()
							uvy2 = file.ReadFloat()

							uvx3 = file.ReadFloat()
							uvy3 = file.ReadFloat()
							
							FaceUVX0[k] = uvx1
							FaceUVY0[k] = uvy1
							FaceUVX1[k] = uvx2
							FaceUVY1[k] = uvy2
							FaceUVX2[k] = uvx3
							FaceUVY2[k] = uvy3
							
'							Print " face "+k+"  col "+col1+"  uv1 "+uvx1+", "+uvy1+"  uv2 "+uvx2+", "+uvy2+"  uv3 "+uvx3+", "+uvy3

'							Print " face "+k+"  v0 "+Faces0[k]+"."+FaceCol0[k]+"  v1 "+Faces1[k]+"."+FaceCol1[k]+"  v2 "+Faces2[k]+"."+FaceCol2[k]
							
							Local got:int = -1
							If VertexCount = -1 Then
								got = 0
								VertexVert[0] = Faces0[0]
								VertexCol[0] = FaceCol0[0]
								VertexCount = 1
							Else
								l = 0
								Repeat
									If Faces0[k] = VertexVert[l] And FaceCol0[k] = VertexCol[l] Then got = l
									l += 1
								Until l >= VertexCount or got > -1
								If got = -1 Then
									got = VertexCount
									VertexVert[VertexCount] = Faces0[k]
									VertexCol[VertexCount] = FaceCol0[k]
									VertexCount += 1
								End If
							End If
							Faces0[k] = got

							got = -1
							l = 0
							Repeat
								If Faces1[k] = VertexVert[l] And FaceCol1[k] = VertexCol[l] Then got = l
								l += 1
							Until l >= VertexCount or got > -1
							If got = -1 Then
								got = VertexCount
								VertexVert[VertexCount] = Faces1[k]
								VertexCol[VertexCount] = FaceCol1[k]
								VertexCount += 1
							End If
							Faces1[k] = got

							got = -1
							l = 0
							Repeat
								If Faces2[k] = VertexVert[l] And FaceCol2[k] = VertexCol[l] Then got = l
								l += 1
							Until l >= VertexCount or got > -1
							If got = -1 Then
								got = VertexCount
								VertexVert[VertexCount] = Faces2[k]
								VertexCol[VertexCount] = FaceCol2[k]
								VertexCount += 1
							End If
							Faces2[k] = got
							
'							Print "   "+Faces0[k]+" "+Faces1[k]+" "+Faces2[k]
							
'							Elements[k * 3] = Faces0[k]
'							Elements[k * 3 + 1] = Faces1[k]
'							Elements[k * 3 + 2] = Faces2[k]
							Elements[k * 3] = k * 3
							Elements[k * 3 + 1] = k * 3 + 1
							Elements[k * 3 + 2] = k * 3 + 2
							
							
'								Print "face=" + k + " v1=" + v1 + " v2=" + v2 + " v3=" + v3 + " col1=" + col1 + " col2=" + col2 + " col3=" + col3
'								Print "face=" + k + " v1=" + v1 + " v2=" + v2 + " v3=" + v3 + "  tx1="+uvx1+" ty1="+uvy1 + "  tx2="+uvx2+" ty2="+uvy2 + "  tx3="+uvx3+" ty3="+uvy3
'							Print " colref col1="+SaveColRef[col1]+" col2="+SaveColRef[col2]+" col3="+SaveColRef[col3]
							
'							AddFaceUV(FacePos, VertexPtr, v1,v2,v3, SaveColRef[col1], SaveColRef[col2], SaveColRef[col3], uvx1, uvy1, uvx2, uvy2, uvx3, uvy3)
'							IncFace()
						Next
#jump construct						
'						Print VertexCount
						Vertices = New Float[ faceCount * 16 * 3 ]

'						For k = 0 Until VertexCount
'							Print "v "+k+" "+VertexVert[k]+" "+VertX[VertexVert[k]]
'						next
'						Print ""
						
						l = 0
						Local v1:int
						Local v2:int
						Local v3:int
						Local c:int
						For k = 0 Until faceCount
'							Print k+"  "+Faces0[k] +" "+Faces1[k] +" "+Faces2[k]
							v1 = VertexVert[ Faces0[k] ]
							v2 = VertexVert[ Faces1[k] ]
							v3 = VertexVert[ Faces2[k] ]
							
							CalculateNormal( VertX[ v1 ], VertY[ v1 ], VertZ[ v1 ], VertX[ v2 ], VertY[ v2 ], VertZ[ v2 ], VertX[ v3 ], VertY[ v3 ], VertZ[ v3 ] )
'							Print k+"  "+NormalX+" "+NormalY+" "+NormalZ
							
							c = VertexCol[ Faces0[k] ]

							Vertices[l] = SaveColRef[ c ].r
							Vertices[l+1] = SaveColRef[ c ].g
							Vertices[l+2] = SaveColRef[ c ].b
							Vertices[l+3] = SaveColRef[ c ].a
							Vertices[l+4] = VertX[ v1 ]
							Vertices[l+5] = VertY[ v1 ]
							Vertices[l+6] = VertZ[ v1 ]
							Vertices[l+7] = 0
							Vertices[l+8] = NormalX
							Vertices[l+9] = NormalY
							Vertices[l+10] = NormalZ
							Vertices[l+11] = 0
							Vertices[l+12] = FaceUVX0[k]
							Vertices[l+13] = FaceUVY0[k]
							l += 16

							c = VertexCol[ Faces1[k] ]

							Vertices[l] = SaveColRef[ c ].r
							Vertices[l+1] = SaveColRef[ c ].g
							Vertices[l+2] = SaveColRef[ c ].b
							Vertices[l+3] = SaveColRef[ c ].a
							Vertices[l+4] = VertX[ v2 ]
							Vertices[l+5] = VertY[ v2 ]
							Vertices[l+6] = VertZ[ v2 ]
							Vertices[l+7] = 0
							Vertices[l+8] = NormalX
							Vertices[l+9] = NormalY
							Vertices[l+10] = NormalZ
							Vertices[l+11] = 0
							Vertices[l+12] = FaceUVX1[k]
							Vertices[l+13] = FaceUVY1[k]
							l += 16

							c = VertexCol[ Faces2[k] ]

							Vertices[l] = SaveColRef[ c ].r
							Vertices[l+1] = SaveColRef[ c ].g
							Vertices[l+2] = SaveColRef[ c ].b
							Vertices[l+3] = SaveColRef[ c ].a
							Vertices[l+4] = VertX[ v3 ]
							Vertices[l+5] = VertY[ v3 ]
							Vertices[l+6] = VertZ[ v3 ]
							Vertices[l+7] = 0
							Vertices[l+8] = NormalX
							Vertices[l+9] = NormalY
							Vertices[l+10] = NormalZ
							Vertices[l+11] = 0
							Vertices[l+12] = FaceUVX2[k]
							Vertices[l+13] = FaceUVY2[k]
							l += 16
						Next

			End Select	


		wend

		file.Close()
		ElementLength = Elements.Length

		Return true
	End method


	method CalculateNormal( v1x:float, v1y:float, v1z:float, v2x:float, v2y:float, v2z:float, v3x:float, v3y:float, v3z:float )
		local lhsx:float = v2x - v1x
		local lhsy:float = v2y - v1y
		local lhsz:float = v2z - v1z
		Local rhsx:float = v3x - v2x
		Local rhsy:float = v3y - v2y
		Local rhsz:float = v3z - v2z

		'cross
		Local vx:float = lhsy * rhsz - lhsz * rhsy
		Local vy:float = lhsz * rhsx - lhsx * rhsz
		Local vz:float = lhsx * rhsy - lhsy * rhsx

		'normalize
		Local length:double = Sqrt(vx * vx + vy * vy + vz * vz)
    
		NormalX = vx / length
		NormalY = vy / length
		NormalZ = vz / length
	End method

private
	field _pathname:string
End Class


class GLShader
	Field shader:GLuint

	field sColor:int
	field sPosition:int
	field sNormal:int
	field sUV:int

	method New()
		' Load Shader
		shader = SimpleShader()
		
		sColor = glGetAttribLocation( shader, "mx2_Color" )
		sPosition = glGetAttribLocation( shader, "mx2_Vertex" )
		sNormal = glGetAttribLocation( shader, "mx2_Normal" )
		sUV = glGetAttribLocation( shader, "mx2_UV" )
	End method


	method New( vertex:string, fragment:string )
		' Load Shader
		shader = LoadShader( vertex, fragment )
		Print shader
		
		sColor = glGetAttribLocation( shader, "mx2_Color" )
		sPosition = glGetAttribLocation( shader, "mx2_Vertex" )
		sNormal = glGetAttribLocation( shader, "mx2_Normal" )
		sUV = glGetAttribLocation( shader, "mx2_UV" )
	End method


	method GetUniform:int( uniformText:string)
		Return glGetUniformLocation( shader, uniformText )
	End method


	method glLoadProgram:GLuint(vertexSource:String, fragmentSource:String)
		Local vs := glCompile( GL_VERTEX_SHADER, vertexSource )
		Local fs := glCompile( GL_FRAGMENT_SHADER, fragmentSource )
		
		Local program := glCreateProgram()
		
		glAttachShader( program, vs )
		glAttachShader( program, fs )
		
		glLink( program )
		
		glDeleteShader( vs )
		glDeleteShader( fs )
		
		Return program
	End method

	 
	method LoadShader:GLuint( vertex:string, fragment:string )
		local program:int = glLoadProgram(vertex, fragment)
		Return program
	End method


	method SimpleShader:GLuint()
		Local vertex:String = "
		uniform float ViewPoint;
		uniform mat4 Matrix;
		uniform vec3 Color;
		uniform vec3 BaseColor;
		uniform vec4 Light;
		uniform vec3 LightColor;
		attribute vec4 mx2_Vertex;
		attribute vec4 mx2_Color;
		attribute vec4 mx2_Normal;
		attribute vec2 mx2_UV;
		attribute float mx2_Data1;
		attribute float mx2_Data2;
		varying vec3 OutColor;
		varying vec3 OutNormal;
		varying vec4 Light1;
		varying vec2 UV;
		void main() {
			UV = mx2_UV;

			vec4 position = Matrix * mx2_Vertex;
			position.y += position.z * ViewPoint;
			gl_Position = position;
			vec4 normal = normalize(Matrix * mx2_Normal);
			OutNormal = normal.xyz;
			
			Light1 = normalize(vec4(position.xyz-Light.xyz, 0.0));
//			Light1 *= 0.4;
	
			OutColor = mix( mx2_Color.rgb, Color, 1.0-mx2_Color.a ) * LightColor;
//			OutColor = Color;
//			OutColor = mx2_Color.rgb * LightColor;
//			OutColor = vec3( UV, 0.0 );
//			OutColor = OutNormal;
//			OutColor = (mx2_Vertex.rgb+0.25)*1.5;

			OutColor *= BaseColor;
		}
	"
	 
		Local fragment:String = "
		uniform sampler2D TextureSampler;
		uniform float LightMix;
		uniform float TextureMix;
		varying vec3 OutColor;
		varying vec3 OutNormal;
		varying vec4 Light1;
		varying vec2 UV;
		void main() {
			vec3 color = texture2D( TextureSampler, UV ).rgb;
			
			float cosTheta = dot( OutNormal, Light1.xyz );
			//OutColor = the input color
			//color = texture
			vec3 col = mix( OutColor, color, TextureMix );

//			gl_FragColor = vec4(OutColor * cosTheta, 0);

//			gl_FragColor = vec4(OutColor * cosTheta * color , 0);
//			gl_FragColor = vec4(OutColor * color , 0);
//			gl_FragColor = vec4(OutColor , 1);
//			gl_FragColor = vec4( 1., 1., 1., 0.1 );

//			vec3 col = mix( OutColor * cosTheta, OutColor * cosTheta *color, TextureMix );
//				gl_FragColor = mix( vec4(OutColor , 1), vec4(OutColor * cosTheta *color, 0.25), LightMix );
//				gl_FragColor = mix( vec4(OutColor , 1), vec4(col, 0.25), LightMix );

			gl_FragColor = vec4( mix(col, col * cosTheta , LightMix ), 1.0);
		}
	"
	 
		local program:int = glLoadProgram(vertex, fragment)
		Return program
	End method
	
End Class


class Rameses3dModel
	field r3d:R3dLoader

	Field vbo:GLuint
	Field ebo:GLuint
	Field shader:GLShader
	
	field ElementLength:int

	Field matrixView:Matrix = New Matrix
	
	Field matrixScale:Matrix = New Matrix
	Field matrixRotX:Matrix = New Matrix
	Field matrixRotY:Matrix = New Matrix
	Field matrixRotZ:Matrix = New Matrix
	Field matrixTranslate:Matrix = New Matrix
	
	Field matrixProjection:Matrix = New Matrix
	Field matrixViewProjection:Matrix = New Matrix

	field color:Vec4f = New Vec4f

	field time:float
	
	Field matrixUniform:Int
	Field lightUniform:Int
	Field lightColorUniform:Int
	Field lightMixUniform:Int
	Field textureMixUniform:Int
	Field colorUniform:Int
	Field baseColorUniform:Int
	Field timeUniform:Int
	Field viewpointUniform:Int
	Field xywhUniform:Int
	
	field light:Vec4f = New Vec4f
	field lightColor:Color = Color.White
	
	method New( path:string, inShader:GLShader )', projMatrix:Matrix )
		r3d = New R3dLoader( path )
		ElementLength = r3d.ElementLength

		shader = inShader
		matrixUniform = shader.GetUniform( "Matrix" )
		viewpointUniform = shader.GetUniform( "ViewPoint" )
		colorUniform = shader.GetUniform( "Color" )
		baseColorUniform = shader.GetUniform( "BaseColor" )
		timeUniform = shader.GetUniform( "mx2_Time" )
		lightUniform = shader.GetUniform( "Light" )
		lightMixUniform = shader.GetUniform( "LightMix" )
		textureMixUniform = shader.GetUniform( "TextureMix" )
		lightColorUniform = shader.GetUniform( "LightColor" )
		xywhUniform = shader.GetUniform( "XYWH" )
	End method

	
	method Bind( projMatrix:Matrix )
		glDeleteBuffers(1, Varptr vbo)
		glDeleteBuffers(1, Varptr ebo)
		  
  		matrixProjection = projMatrix
'		matrixViewProjection = New Matrix
 
		' Create vertex buffer	
		glGenBuffers( 1, Varptr vbo )
		glBindBuffer( GL_ARRAY_BUFFER, vbo )
		glBufferData( GL_ARRAY_BUFFER, r3d.Vertices.Length * 4, r3d.Vertices.Data, GL_STATIC_DRAW )
 
		' create element buffer
		glGenBuffers( 1, Varptr ebo)
		glBindBuffer( GL_ELEMENT_ARRAY_BUFFER, ebo )
		glBufferData( GL_ELEMENT_ARRAY_BUFFER, r3d.Elements.Length * 4, r3d.Elements.Data, GL_STATIC_DRAW )

		'push the data into the buffers
		glBindBuffer( GL_ARRAY_BUFFER, vbo )
		glEnableVertexAttribArray( shader.sColor )
		glEnableVertexAttribArray( shader.sPosition )
		glEnableVertexAttribArray( shader.sNormal )
		glEnableVertexAttribArray( shader.sUV )
		glVertexAttribPointer( shader.sColor, 4, GL_FLOAT, False, 64, Cast<Void Ptr>(0) )
		glVertexAttribPointer( shader.sPosition, 3, GL_FLOAT, true, 64, Cast<Void Ptr>(16) )
		glVertexAttribPointer( shader.sNormal, 4, GL_FLOAT, false, 64, Cast<Void Ptr>(32) )
		glVertexAttribPointer( shader.sUV, 2, GL_FLOAT, false, 64, Cast<Void Ptr>(48) )
 
		' bind the element buffer object
		glBindBuffer( GL_ELEMENT_ARRAY_BUFFER, ebo )
	End method


	method TransformFlat( viewPoint:float, x:float, y:float, z:float, lightMix:float, textureMix:float, baseColor:Color, scale:float, yrot:float, CharStart:int, CellWidth:int, CellHeight:int, lx:float, ly:float, lz:float )
		matrixView = Matrix.Scale( scale, scale, scale )
		matrixView *= Matrix.RotateY(yrot)' * Matrix.RotateX(xrot) * Matrix.RotateZ(zrot)
		matrixView *= Matrix.Translation( x, y, z )

		matrixViewProjection = matrixView * matrixProjection

		' use the shader and update the matrix uniform
		glUseProgram( shader.shader )
		glUniformMatrix4fv( matrixUniform, 1, False, matrixViewProjection.ToArray.Data )

		glUniform1fv( viewpointUniform, 1, varptr viewPoint )
		
		'update the basecolor
		color.x = baseColor.r
		color.y = baseColor.g
		color.z = baseColor.b
		glUniform3fv( baseColorUniform, 1, Varptr color.x )
		'update the additional color
		color.x = 0.7
		color.y = 0.7
		color.z = 0.7
'		color = New Vec4f( 1, 0.2, 0, 0 )
		glUniform3fv( colorUniform, 1, Varptr color.x )

		'update the xywh
		color.x = CharStart Mod 16
		color.y = int(CharStart / 16)
		color.z = Clamp( CellWidth, 1, 16)
		color.w = Clamp( CellHeight, 1, 16)
'		Print color.x+" "+color.y+" "+color.z+" "+color.w
		glUniform4fv( xywhUniform, 1, Varptr color.x )
		
		'update the time
		time = Millisecs()
		glUniform1fv( timeUniform, 1, Varptr time )

		'update texture viewing
		glUniform1fv( textureMixUniform, 1, Varptr textureMix )

		'update the light
		light.x = -lx
		light.y = -ly
		light.z = -lz
		glUniform4fv( lightUniform, 1, Varptr light.x )
		glUniform1fv( lightMixUniform, 1, Varptr lightMix )
		glUniform3fv( lightColorUniform, 1, Varptr lightColor.r )
	End method


	method Transform( viewPoint:float, x:float, y:float, z:float, lightMix:float, textureMix:float, baseColor:Color, scale:float, scaleHeight:float, yrot:float, xrot:float, zrot:float, lx:float, ly:float, lz:float )
		matrixView = Matrix.Scale( scale, scale * scaleHeight, scale )
		matrixView *= Matrix.RotateY(yrot) * Matrix.RotateX(xrot) * Matrix.RotateZ(zrot)
		matrixView *= Matrix.Translation( x, y, z )

		matrixViewProjection = matrixView * matrixProjection

		' use the shader and update the matrix uniform
		glUseProgram( shader.shader )
		glUniformMatrix4fv( matrixUniform, 1, False, matrixViewProjection.ToArray.Data )

		glUniform1fv( viewpointUniform, 1, varptr viewPoint )
		
		'update the basecolor
		color.x = baseColor.r
		color.y = baseColor.g
		color.z = baseColor.b
		glUniform3fv( baseColorUniform, 1, Varptr color.x )
		'update the additional color
		color.x = 0.7
		color.y = 0.7
		color.z = 0.7
'		color = New Vec4f( 1, 0.2, 0, 0 )
		glUniform3fv( colorUniform, 1, Varptr color.x )

		'update the xywh
		color.x = 0.0
		color.y = 0.0
		color.z = 1.0
		color.w = 1.0
		glUniform4fv( xywhUniform, 1, Varptr color.x )
		
		'update the time
		time = Millisecs()
		glUniform1fv( timeUniform, 1, Varptr time )

		'update texture viewing
		glUniform1fv( textureMixUniform, 1, Varptr textureMix )

		'update the light
		light.x = -lx
		light.y = -ly
		light.z = -lz
		glUniform4fv( lightUniform, 1, Varptr light.x )
		glUniform1fv( lightMixUniform, 1, Varptr lightMix )
		glUniform3fv( lightColorUniform, 1, Varptr lightColor.r )
	End method


	method DrawModel()
		glDrawElements( GL_TRIANGLES, ElementLength, GL_UNSIGNED_INT, Cast<Int Ptr>(0) )
	End method


	method DrawPoints()
		glDrawElements( GL_POINTS, ElementLength, GL_UNSIGNED_INT, Cast<Int Ptr>(0) )
	End method

	method DrawLines()
		glDrawElements( GL_LINES, ElementLength, GL_UNSIGNED_INT, Cast<Int Ptr>(0) )
	End method
End Class


class Rameses3d
	Field projMatrix:Matrix
	
	field models:Rameses3dModel[] = New Rameses3dModel[25]
	field modelCount:int = 0
	
	field currentModel:int = -1

	field lx:float = -3
	field ly:float = 3
	field lz:float = -5
	
	field viewPoint:Float = 0

	method New( width:int, height:int )
		SetRes( width, height )
	End method

	
	method Load:int( path:string, inShader:GLShader )
		models[modelCount] = New Rameses3dModel( path, inShader )
		modelCount += 1
		Return modelCount -1
	End method
	
	
	method DrawModelHeight( model:int,  x:float, y:float, z:float, lightMix:float, textureMix:float, baseColor:Color, scale:float = 1, scaleHeight:float = 1 )
		If model <> currentModel Then
			currentModel = model
			models[model].Bind( projMatrix )
		End If
		
		
		models[model].Transform( viewPoint, x, y, z, lightMix, textureMix, baseColor, scale, scaleHeight, 1.6, 0, 0, lx, ly, lz )
		models[model].DrawModel()
	End method


	method DrawModelChar( model:int,  x:float, y:float, z:float, lightMix:float, textureMix:float, baseColor:Color, scale:float, yrot:float, charStart:int, charWidth:int = 1, charHeight:int = 1 )
		If model <> currentModel Then
			currentModel = model
			models[model].Bind( projMatrix )
		End If
		
		
		models[model].TransformFlat( viewPoint, x, y, z, lightMix, textureMix, baseColor, scale, yrot, charStart, charWidth, charHeight, lx, ly, lz )
		models[model].DrawModel()
	End method
	

	method DrawModel( model:int,  x:float, y:float, z:float, lightMix:float, textureMix:float, baseColor:Color, scale:float = 1, yrot:float = 0, xrot:float = 0, zrot:float = 0 )
		If model <> currentModel Then
			currentModel = model
			models[model].Bind( projMatrix )
		End If
		
		
		models[model].Transform( viewPoint, x, y, z, lightMix, textureMix, baseColor, scale, 1, yrot, xrot, zrot, lx, ly, lz )
		models[model].DrawModel()
	End method
	

	method DrawPoints( model:int,  x:float, y:float, z:float, lightMix:float, textureMix:float, baseColor:Color, scale:float = 1, yrot:float = 0, xrot:float = 0, zrot:float = 0 )
		If model <> currentModel Then
			currentModel = model
			models[model].Bind( projMatrix )
		End If
		
		models[model].Transform( viewPoint, x, y, z, lightMix, textureMix, baseColor, scale, 1, yrot, xrot, zrot, lx, ly, lz )
		models[model].DrawPoints()
	End method

	
	method DrawLines( model:int,  x:float, y:float, z:float, lightMix:float, textureMix:float, baseColor:Color, scale:float = 1, yrot:float = 0, xrot:float = 0, zrot:float = 0 )
		If model <> currentModel Then
			currentModel = model
			models[model].Bind( projMatrix )
		End If
		
		models[model].Transform( viewPoint, x, y, z, lightMix, textureMix, baseColor, scale, 1, yrot, xrot, zrot, lx, ly, lz )
		models[model].DrawLines()
	End method


	method SetRes( width:float, height:float )
'		Print "setres "+width+" "+height
'		glViewport( 0, 0, width, height )
		projMatrix = Matrix.Perspective(Pi / 4.0, 1.3, 0.5, 1000)
	End method
End Class
