
#import "rameses3d"


#import "assets/grid.3do"
 
'the size of our window
Const Size := New Vec2i( 950,720 )

'And some nice stuff
const PI:float = 3.14159265359 
const PIHALF:float = PI * 0.5

const SHOW_TEX:float = 1
const HIDE_TEX:float = 0

const USE_LIGHT:float = 1
const NO_LIGHT:float = 0



Class MyWindow Extends GLWindow

	'this is the 3d system
	field my3d:Rameses3d

	'we need at lest one shader
	field myShader:GLShader

	'and this is the 3d object
	field r3d_Grid:int

	'we dont need this,  but it is the texture that can be fed into rameses3d
	field tex:TextureGL
	
	Method New()
		'create a window
		Super.New( "My Window", Size.X, Size.Y, WindowFlags.Resizable )

		'this is a timer. it will 'tick' 60 times a second. calling OnUpdate
		_timer = New Timer( 60, OnUpdate )

		'if you want a constant canvas size use this
'		Layout = "letterbox"
		'or If you want the canvas to always fill the window use this
		Layout = "fill"

		'get the shaders. we are not using any user defined ones,  but we wil need to get a basic one
		InitShaders()

		'next initalize Rameses
		my3d = New Rameses3d( Width, Height )
		'and set a light. Think of you the observer as position 0, 0, 0.
		' with x being left/right
		' y being up/down
		' and z being in/out z starts at 0,  and goes minus away from you, plus towards you
		' so... 0, 1, -1 is centered,  above and into the screen
		my3d.SetLight( 0, 1, -2 )

		'load the texture - we are not using
'		tex = TextureGL.Load( "asset::ship32x32_font.png", TextureFlagsGL.Dynamic )

		'now we load the 3d shape from the assets
		r3d_Grid = my3d.Load( "asset::grid.3do", myShader )

		'and finally some opengl
		'set the clear color of the screen to black
		glClearColor(0, 0, 0, 1.0)

		'cull the face drawing and add depth
		glEnable(GL_CULL_FACE)
		glEnable(GL_DEPTH_TEST)
	End

	method InitShaders()
		'first get the basic internal shader from Rameses3d
		myShader = New GLShader()
	End method
	
	
	Method OnUpdate()
		'this 'ticks' at 60 fps
		
		'use it For your master updating system
		_gameTime = Millisecs()
		
		'lets update the rotation
		_objectRotate += 0.005

		'finally call everything to render
		'the render is done:OnRenderGL first then standard monkey2 OnRender
		RequestRender()
	End Method
	
	
	Method OnRender(canvas:Canvas) Override
		App.RequestRender()
		'this will call the opengl render
		Super.OnRender(canvas)
		

		canvas.DrawText( "FPS="+App.FPS,Width,0,1,0 )

		canvas.DrawText("Monkey2 OpenGL", 10, 10)
		canvas.Color = Color.Blue
		canvas.DrawRect( 210, 10, 10, 200 )

	End


	
	Method OnRenderGL() Override
		'clear the screen buffers
		glClearStencil( 0 )
		glClear( GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT|GL_STENCIL_BUFFER_BIT )

		'Drawing area. You're always drawing to the entire window in GL regardless of Layout.
		glViewport( 0, 0 ,Frame.Width, Frame.Height )

		'initalize the texture - we are not using
'		local texint:GLuint = tex.GLTexture
'		tex.Bind( 0, TextureFilterGL.None )

		Local scale:float = 1.618
		'here's the format for the following drawing commands:
		'method DrawModel( model:int,  x:float, y:float, z:float, lightMix:float, textureMix:float, baseColor:Color, scale:float = 1, yrot:float = 0, xrot:float = 0, zrot:float = 0 )
		
		my3d.DrawLines( r3d_Grid, 0, -1.5, -3.7, NO_LIGHT, HIDE_TEX,  Color.Cyan, scale, 0 )

		my3d.DrawModel( r3d_Grid, 0, -1, -3.7, NO_LIGHT, HIDE_TEX,  Color.Orange, scale*0.5, _objectRotate, _objectRotate )

		my3d.DrawLines( r3d_Grid, 0, -.5, -3.7, NO_LIGHT, HIDE_TEX,  Color.Red, scale*0.25, 0, -_objectRotate )
	End

private	
	'the timer ticks 60 times a second and handles the screen update
	Field _timer:Timer

	'global game time derrived from a single call to Millisecs()
	field _gameTime:int
	
	field _objectRotate:float = 0
End


 
Function Main()
	Local cfg := New StringMap<String>
	
	cfg["GL_depth_buffer_enabled"] = 1
	cfg["GL_stencil_buffer_enabled"] = 1
	
	New AppInstance( cfg )

	New MyWindow
	App.Run()
End