
#Import "<std>"
Using std..

Class Matrix
	' Matrix class is based on Monogame math.
Private
	Field data:Float[] = New Float[16]
 
Public
	Field M11:Float, M12:Float, M13:Float, M14:Float
	Field M21:Float, M22:Float, M23:Float, M24:Float
	Field M31:Float, M32:Float, M33:Float, M34:Float
	Field M41:Float, M42:Float, M43:Float, M44:Float
 
	Property ToArray:Float[]()
		data[0] = M11
		data[1] = M12
		data[2] = M13
		data[3] = M14
		data[4] = M21
		data[5] = M22
		data[6] = M23
		data[7] = M24
		data[8] = M31
		data[9] = M32
		data[10] = M33
		data[11] = M34
		data[12] = M41
		data[13] = M42
		data[14] = M43
		data[15] = M44
		Return data
	End
 
	Operator*:Matrix( matrix:Matrix )
		Local result:Matrix = New Matrix

		result.M11 = (Self.M11 * matrix.M11) + (Self.M12 * matrix.M21) + (Self.M13 * matrix.M31) + (Self.M14 * matrix.M41)
		result.M12 = (Self.M11 * matrix.M12) + (Self.M12 * matrix.M22) + (Self.M13 * matrix.M32) + (Self.M14 * matrix.M42)
		result.M13 = (Self.M11 * matrix.M13) + (Self.M12 * matrix.M23) + (Self.M13 * matrix.M33) + (Self.M14 * matrix.M43)
		result.M14 = (Self.M11 * matrix.M14) + (Self.M12 * matrix.M24) + (Self.M13 * matrix.M34) + (Self.M14 * matrix.M44)

		result.M21 = (Self.M21 * matrix.M11) + (Self.M22 * matrix.M21) + (Self.M23 * matrix.M31) + (Self.M24 * matrix.M41)
		result.M22 = (Self.M21 * matrix.M12) + (Self.M22 * matrix.M22) + (Self.M23 * matrix.M32) + (Self.M24 * matrix.M42)
		result.M23 = (Self.M21 * matrix.M13) + (Self.M22 * matrix.M23) + (Self.M23 * matrix.M33) + (Self.M24 * matrix.M43)
		result.M24 = (Self.M21 * matrix.M14) + (Self.M22 * matrix.M24) + (Self.M23 * matrix.M34) + (Self.M24 * matrix.M44)

		result.M31 = (Self.M31 * matrix.M11) + (Self.M32 * matrix.M21) + (Self.M33 * matrix.M31) + (Self.M34 * matrix.M41)
		result.M32 = (Self.M31 * matrix.M12) + (Self.M32 * matrix.M22) + (Self.M33 * matrix.M32) + (Self.M34 * matrix.M42)
		result.M33 = (Self.M31 * matrix.M13) + (Self.M32 * matrix.M23) + (Self.M33 * matrix.M33) + (Self.M34 * matrix.M43)
		result.M34 = (Self.M31 * matrix.M14) + (Self.M32 * matrix.M24) + (Self.M33 * matrix.M34) + (Self.M34 * matrix.M44)

		result.M41 = (Self.M41 * matrix.M11) + (Self.M42 * matrix.M21) + (Self.M43 * matrix.M31) + (Self.M44 * matrix.M41)
		result.M42 = (Self.M41 * matrix.M12) + (Self.M42 * matrix.M22) + (Self.M43 * matrix.M32) + (Self.M44 * matrix.M42)
		result.M43 = (Self.M41 * matrix.M13) + (Self.M42 * matrix.M23) + (Self.M43 * matrix.M33) + (Self.M44 * matrix.M43)
		result.M44 = (Self.M41 * matrix.M14) + (Self.M42 * matrix.M24) + (Self.M43 * matrix.M34) + (Self.M44 * matrix.M44)

		Return result
	End

	Function Identity:Matrix()
		Local result := New Matrix
		result.M11 = 1.0
		result.M22 = 1.0
		result.M33 = 1.0
		result.M44 = 1.0
		Return result
	End
	
	Function Translation:Matrix( x:Float, y:Float, z:Float )
		Local result := Identity()
		result.M41 = x
		result.M42 = y
		result.M43 = z
		Return result
	End
	
	Function Scale:Matrix( x:Float, y:Float, z:Float )
		Local result := Identity()
		result.M11 = x
		result.M22 = y
		result.M33 = z
		result.M44 = 1.0
		Return result
	End

	Function RotateX:Matrix( angle:Float )
		Local cos:Float = Cos(angle)
		Local sin:Float = Sin(angle)
		Local result := Identity()
		result.M22 = cos
		result.M23 = sin
		result.M32 = -sin
		result.M33 = cos
		Return result
	End
	
	Function RotateY:Matrix( angle:Float )
		Local cos:Float = Cos(angle)
		Local sin:Float = Sin(angle)
		Local result := Identity()
		result.M11 =  cos
		result.M13 = -sin
		result.M31 =  sin
		result.M33 =  cos
		Return result
	End
 
	Function RotateZ:Matrix( angle:Float )
		Local cos:Float = Cos(angle)
		Local sin:Float = Sin(angle)
		Local result := Identity()
		result.M11 =  cos
		result.M21 = -sin
		result.M12 =  sin
		result.M22 =  cos
		Return result
	End

	Function Perspective:Matrix( fovy:Float, aspect:Float, near:Float, far:float )
		Local yMax:Float = near * Tan(0.5 * fovy)
		Local yMin:Float = -yMax
		Local xMin:Float = yMin * aspect
		Local xMax:Float = yMax * aspect
		Return Frustum(xMin, xMax, yMin, yMax, near, far)
	End
	
	Function Frustum:Matrix( left:Float, right:Float, bottom:Float, top:Float, near:Float, far:Float )
		Local invRL:Float = 1.0 / (right - left)
		Local invTB:Float = 1.0 / (top - bottom)
		Local invFN:Float = 1.0 / (far - near)
		
		Local result := New Matrix()
		
		result.M11 = 2.0 * near * invRL
		result.M12 = 0.0
		result.M13 = 0.0
		result.M14 = 0.0
		
		result.M21 = 0.0
		result.M22 = 2.0 * near * invTB
		result.M23 = 0.0
		result.M24 = 0.0
		
		result.M31 = (right + left) * invRL
		result.M32 = (top + bottom) * invTB
		result.M33 = -(far + near) * invFN
		result.M34 = -1.0
		
		result.M41 = 0.0
		result.M42 = 0.0
		result.M43 = -2.0 * far * near * invFN
		result.M44 = 0.0
		
		Return result
	End


	Method Multiply( matrixA:Matrix, matrixB:Matrix )
		M11 = (matrixA.M11 * matrixB.M11) + (matrixA.M12 * matrixB.M21) + (matrixA.M13 * matrixB.M31) + (matrixA.M14 * matrixB.M41)
		M12 = (matrixA.M11 * matrixB.M12) + (matrixA.M12 * matrixB.M22) + (matrixA.M13 * matrixB.M32) + (matrixA.M14 * matrixB.M42)
		M13 = (matrixA.M11 * matrixB.M13) + (matrixA.M12 * matrixB.M23) + (matrixA.M13 * matrixB.M33) + (matrixA.M14 * matrixB.M43)
		M14 = (matrixA.M11 * matrixB.M14) + (matrixA.M12 * matrixB.M24) + (matrixA.M13 * matrixB.M34) + (matrixA.M14 * matrixB.M44)

		M21 = (matrixA.M21 * matrixB.M11) + (matrixA.M22 * matrixB.M21) + (matrixA.M23 * matrixB.M31) + (matrixA.M24 * matrixB.M41)
		M22 = (matrixA.M21 * matrixB.M12) + (matrixA.M22 * matrixB.M22) + (matrixA.M23 * matrixB.M32) + (matrixA.M24 * matrixB.M42)
		M23 = (matrixA.M21 * matrixB.M13) + (matrixA.M22 * matrixB.M23) + (matrixA.M23 * matrixB.M33) + (matrixA.M24 * matrixB.M43)
		M24 = (matrixA.M21 * matrixB.M14) + (matrixA.M22 * matrixB.M24) + (matrixA.M23 * matrixB.M34) + (matrixA.M24 * matrixB.M44)

		M31 = (matrixA.M31 * matrixB.M11) + (matrixA.M32 * matrixB.M21) + (matrixA.M33 * matrixB.M31) + (matrixA.M34 * matrixB.M41)
		M32 = (matrixA.M31 * matrixB.M12) + (matrixA.M32 * matrixB.M22) + (matrixA.M33 * matrixB.M32) + (matrixA.M34 * matrixB.M42)
		M33 = (matrixA.M31 * matrixB.M13) + (matrixA.M32 * matrixB.M23) + (matrixA.M33 * matrixB.M33) + (matrixA.M34 * matrixB.M43)
		M34 = (matrixA.M31 * matrixB.M14) + (matrixA.M32 * matrixB.M24) + (matrixA.M33 * matrixB.M34) + (matrixA.M34 * matrixB.M44)

		M41 = (matrixA.M41 * matrixB.M11) + (matrixA.M42 * matrixB.M21) + (matrixA.M43 * matrixB.M31) + (matrixA.M44 * matrixB.M41)
		M42 = (matrixA.M41 * matrixB.M12) + (matrixA.M42 * matrixB.M22) + (matrixA.M43 * matrixB.M32) + (matrixA.M44 * matrixB.M42)
		M43 = (matrixA.M41 * matrixB.M13) + (matrixA.M42 * matrixB.M23) + (matrixA.M43 * matrixB.M33) + (matrixA.M44 * matrixB.M43)
		M44 = (matrixA.M41 * matrixB.M14) + (matrixA.M42 * matrixB.M24) + (matrixA.M43 * matrixB.M34) + (matrixA.M44 * matrixB.M44)
	End

	method SetScale( x:Float, y:Float, z:Float )
		M11 = x
		M22 = y
		M33 = z
		M44 = 1.0
	End

	method SetRotateX( angle:Float )
		Local cos:Float = Cos(angle)
		Local sin:Float = Sin(angle)
		M22 = cos
		M23 = sin
		M32 = -sin
		M33 = cos
	End
	
	method SetRotateY( angle:Float )
		Local cos:Float = Cos(angle)
		Local sin:Float = Sin(angle)
		M11 =  cos
		M13 = -sin
		M31 =  sin
		M33 =  cos
	End
 
	method SetRotateZ( angle:Float )
		Local cos:Float = Cos(angle)
		Local sin:Float = Sin(angle)
		M11 =  cos
		M21 = -sin
		M12 =  sin
		M22 =  cos
	End

	method SetTranslation( x:Float, y:Float, z:Float )
		M41 = x
		M42 = y
		M43 = z
		M44 = 1.0
	End
	
End
