#Import "<std>"
#Import "<mojo>"
#Import "<mojox>"

#Import "netio"
#Import "netclient"
 
Namespace APPLICATION_CLIENT
 
Using std..
Using mojo..
Using mojox..
Using netio..
 
Global TestAddress:NetAddressInfo

Class NewClient Extends NetClient
	
	Field OnMSG:Void(String)
	
	Method New()
		Super.New(TestAddress)
	End
	
	' On Client Connection Success
	Method OnConnected() Override
		
		Print "Yay I'm connected"
		
	End
	
	' When this client is sent data fromt the server
	Method OnServerData(data:String) Override
	
		Local req := JsonObject.Parse(data)
		Print "Server Request: " + req.GetString("request")
		
		' Client action based on server data
		
		Select req.GetString("request") ' ----
			
			
		Case "system" 
		
			Print "- System Output"
			Local new_data := req.GetString("data")
			Print new_data
			
			
		Case "sql"
		
			Print "- SQL Result"
			Local new_data := req.GetString("data")
			Print new_data
			
		
		Case "clientlist"
		
			Print "- Client Map Retrieved"
			Local new_data := req.GetString("data")
			UpdateClientMap(new_data)
			Print "- Client Map Updated"
			
		Case "file"
		
			Print "- Got File Data"
			Local file_name := req.GetString("name")
			Local file_data := req.GetString("data")
			Print file_data
			
		Case "msg"
			
			OnMSG(req.GetString("msg"))
			
		Default
			
			Print "- Unefined Server Request: " + req.GetString("request")
		
		End Select ' ----
	
	End
	
End Class

Class MyWindow Extends Window

	Field N:NewClient ' Our Client Containern
	
	
	' Main GUI
	Field OutputView:HtmlView
	Field InputView:TextField
	
	Field MainView:DockingView

	Method New()
	
		' Initialize Window
		Super.New("Client", 800, 600)
		Layout = "fill"
	
		TestAddress.Host = "192.168.1.110"
		TestAddress.Port = 5000
	
	
		' Create/Initialize GUI View
		
		MainView = New DockingView
		
		OutputView = New HtmlView
		OutputView.HtmlSource += "<head><style>* { color: white; }</style></head>"
		
		InputView = New TextField
		
		MainView.AddView(InputView, "bottom")
		
		MainView.ContentView = OutputView
		
		ContentView = MainView
	
	
		Print "Loading Client..."
		N = New NewClient()
		N.OnMSG = OnClientMessage
		
		New Fiber( N.Process )
	
	End
	
	Method OnClientMessage(data:String)
	
		OutputView.HtmlSource += "<p>" + data + "</p>"
		
	End
	
	Method OnKeyEvent( E:KeyEvent ) Override
	
		Select E.Type
		
		Case EventType.KeyDown
		
			Select E.Key
			
			Case Key.Escape
				
				App.Terminate()
				
			Case Key.Enter
				
				Print "Enter"
				
				' For now, we'll manually write the request in json just to prevent parsing
				' Otherwise you could create a "New JsonObject" etc...
				
				' Send multiple requests to fetch data
				
				' ---- ## WARNING @@ -----
				' Not only can this crash the server/client it can 
				' !!!Possible Security Risk Here!!! | But shows the possibilities (Don't use these request types in real applications unless you know what you're doing!!!)
				' ONCE LIVE; THE FOLLOWING SHOULD BE ENCRYPTED
				
				#Rem
				N.SendData("{'request':'clientlist'}")
				N.SendData("{'request':'sql','data':'select * from table'}")
				N.SendData("{'request':'system','data':'ls -a'}")
				N.SendData("{'request':'file','name':'helloworld.txt'}")
				#End

				N.SendData("{'request':'msg', 'msg':'"+InputView.Text+"'}")
				InputView.Text = ""

			End
			
		End
		
	End

End Class

Function Main()

	New AppInstance
	New MyWindow
	App.Run()
	
End