Namespace netio

Class NetClient
	
Private
 
	Field Address:NetAddressInfo ' Server Address & Port
	
	' Connection to the Root Server
	Field ServerStream:SocketStream
	
	' Track Peer Client Connections
	Field PeerList:List<String>
	
Public
	
	Method New(hostport:NetAddressInfo)
	
		Address = hostport ' Set Server Address & Port
		PeerList = New List<String>
	
	End Method
 
	Method Process()
	
		' Connect to Server via HOST and PORT
		Local CLIENT := Socket.Connect( Address.Host, Address.Port )
		If Not CLIENT Print "Client | Couldn't Connect to Server!" ; Return ' Exit Failure
		
		' Configure Client Settings
		Print CLIENT.Address + " | Connected to Server : "+CLIENT.PeerAddress
		CLIENT.SetOption( "TCP_NODELAY", 1 )
		
		' Establish Stream Client - Server Connection
		ServerStream = New SocketStream( CLIENT )
		
		OnConnected() ' EVENT_CALL : OnConnected
 
		While(Not ServerStream.Eof) ' While Server STREAM isn't Closed
			
			' Get Incoming Server Data
			Local S_DATA:String = ServerStream.ReadSizedString()
			
			OnServerData( S_DATA ) ' EVENT_CALL : OnServerData
			
			Print "Server Message: " + S_DATA
			
		Wend ' Ending Client Processing

		Print "Client | Is Closing..."
		OnDisconnected() ' EVENT_CALL : OnDisconnected
		ServerStream.Close() ' Finally Kill the Client Stream
		
	End
	
	Method UpdateClientMap(data:String)
		PeerList.Clear()
		For Local _name := Eachin data.Split("~n")
			Self.PeerList.Add(_name)
		Next
	End
	
	Method SendData(data:String)
		ServerStream.WriteSizedString(data)
	End
	
	
	
	' CALLED WHEN - Client is Connected to the Server
	Method OnConnected() Virtual
	End
	
	' CALLED WHEN - Client has Disconnected
	Method OnDisconnected() Virtual
	End
	
	' CALLED WHEN - Client gets Data from the Server
	Method OnServerData(data:String) Virtual
	End
	
End