Namespace netio

Class NetServer
 
Private

	Field Address:NetAddressInfo ' Server Address & Port
	Field PersistentCount:Int ' Counter for Unique Connection IDs
	
Public

	' Track Client Connections
	Field ClientMap:StringMap<SocketStream>
	
	Method New(hostport:NetAddressInfo)
	
		' - Initialize Server Data
		Address = hostport
		ClientMap = New StringMap<SocketStream>
		
		PersistentCount = 0 ' Start at 0
		
		Print "Stream List Instantiated"
	
	End Method
 
	' - Write Abritrary Data To Specific Socket Stream
 	Method SendDataTo(data:String, stream_to:SocketStream)
	 	'If(Not stream_id.Eof)
			stream_to.WriteSizedString(data)
		'Endif
	End
	
	' - Write/Send Abritrary Data to All Connected Clients
	Method SendDataAll(data:String)
		For Local stream_id := Eachin ClientMap.Values
			If(Not stream_id.Eof) ' If Stream is Not Closed
				Print "Server | Writing to " + stream_id.Socket.PeerAddress
				stream_id.WriteSizedString(data)
			Else
				Print "Server | Skipping 'WriteTo()' Closed Socket"
			Endif
		End
	End
	
	' - Assembling the Host Names of Each Client
	Method GetHostNames:String()
		Local names:String
		For Local name := Eachin ClientMap.Keys
			names += name + "~n"
		Next	
		Return names.Slice(0, names.Length - 1)
	End
	
	' - Write Abritrary Data To Host Name SocketStream
	Method WriteToHostName(hostname:String, data:String)
	
		If(ClientMap.Contains(hostname))
			Local ss := ClientMap.Get(hostname)
			ss.WriteSizedString(data)
		Endif
		
	End
 
	Method Process:Void()
	
		' Create the Server Socket
		Local SERVER := Socket.Listen( Address.Host, Address.Port )
		If Not SERVER Print "Server: Failed to create server" ; Return ' Exit On Failure...
		
		' Instantiate Server Configurations
		Print "Server | "+SERVER.Address+" | Is listening..."
		SERVER.SetOption( "SO_REUSEADDR", 1 )
		SERVER.SetOption( "TCP_NODELAY", 1 )
		
		OnConnected() ' EVENT_CALL : OnConnected
		
		Repeat ' Begin Listening for Client Instance Requests
		
			' Accept Incoming Client Connection Request
			Local NEW_SOCKET := SERVER.Accept()
			If Not NEW_SOCKET Exit ' Exit On If Null
			
			' Connection Found...
			Print "Server Accepted Client | " + NEW_SOCKET.PeerAddress
			
			' Add New Connection Stream to List
			Local NEW_STREAM := New SocketStream( NEW_SOCKET )
			
			Local CLIENT_HOSTNAME:String = "client_"+PersistentCount
			ClientMap.Add( CLIENT_HOSTNAME, NEW_STREAM ) ' ----- < Added to Map Here
			
			PersistentCount += 1
			
			' EVENT_CALL : OnClientConnect
			OnClientConnect( NEW_STREAM )
			
			Print "- Client Map Updated"
			
			New Fiber( Lambda() ' Listen for Requests from NEW_STREAM Instance Asynchronously
			
				Repeat
					
					' Extract Data Buffer From NEW_STREAM Instance
					Local DATA := NEW_STREAM.ReadSizedString()
					If Not DATA Exit ' Exit if Data's Empty
					
					OnClientData(NEW_STREAM, DATA) ' EVENT_CALL : OnClientData
					Print "Client Message: " + DATA
					
				Forever
				
				' Client: NEW_STREAM - Has Disconnected/Closed
				OnClientDisconnect( NEW_STREAM ) ' EVENT_CALL : OnClientDisconnect
				ClientMap.Remove( CLIENT_HOSTNAME ) ' Remove Disonnected Socket from Tracking List
				
				Print "- Stream Removed : " + NEW_STREAM.Socket.PeerAddress
				NEW_STREAM.Close() ' Close it once more 'Just Incase' (Probably Pointless)
				
			End )
		
		Forever ' End Listening for Client Instance Requests
		
		Print "Server | Terminating..."
		OnDisconnected() ' EVENT_CALL : OnDisconnected
		SERVER.Close() ' Finally Kill the Server Instance
		
	End
	
	' CALLED WHEN - Server has established itself
	Method OnConnected() Virtual
	End
	
	' CALLED WHEN - The Server has stopped broadcasting
	Method OnDisconnected() Virtual
	End
	
	' CALLED WHEN - A Client has Registered a Connection
	Method OnClientConnect(from_sock:SocketStream) Virtual
	End
	
	' CALLED WHEN - A Client has Sent Data to the Server
	Method OnClientData(from_sock:SocketStream, data:String) Virtual
	End
	
	' CALLED WHEN - A Client has Lost Connection/Closed their Connection
	Method OnClientDisconnect(from_sock:SocketStream) Virtual
	End
	
End Class
