#Import "<std>"
#Import "<mojo>"

#Import "netio"
#Import "netserver"

#Import "helloworld.txt"
 
Namespace APPLICATION_SERVER
 
Using std..
Using mojo..
Using netio..
 
Global TestAddress:NetAddressInfo

Class NewServer Extends NetServer

	Method New()
		Super.New(TestAddress)
		
	End
	
	Method OnClientConnect(from_sock:SocketStream) Override
		
		Print "A New Client :)"
		
	End
	
	Method OnClientData(from_sock:SocketStream, data:String) Override

		Local req := JsonObject.Parse(data)
		Local req_name:String = req.GetString("request")
		Print "- Client Request: " + req_name
		
		Select req_name ' Server Responce Request

		Case "system"
		
			from_sock.WriteSizedString("{'request':'system','data':'system result here'}")
			
		Case "sql"
		
			from_sock.WriteSizedString("{'request':'sql','data':'sql data here'}")
			
		Case "clientlist"
			
			' Echo Clients
			from_sock.WriteSizedString("{'request':'clientlist','data':'" + GetHostNames() + "'}")
			
		Case "file"
		
			
			' Echo File Content To Client
			Local file_name:String = req.GetString("name")
			Local file_data:String = LoadString("asset::"+file_name)
			If(file_data <> "")
				from_sock.WriteSizedString("{'request':'file','name':'"+file_name+"','data':'" + file_data + "'}")
			Endif
			
		Case "msg"
			
			SendDataAll("{'request':'msg','msg':'" + req.GetString("msg").Replace("", "~q") + "'}")
			
		Default
		
			Print "- Unefined Server Request: " + req_name
			
		End Select
	
	End
	
End Class

Class MyWindow Extends Window

	Field N:NewServer ' Our Client Container

	Method New()
	
		' Initialize Window
		Super.New("Server", 320, 240)
		Layout = "fill"
		
		TestAddress.Host = "192.168.1.110"
		TestAddress.Port = 5000
	
		Print "Loading Server..."
		N = New NewServer()
		
		New Fiber( N.Process )
	
	End
	
	Method OnKeyEvent( E:KeyEvent ) Override
	
		Select E.Type
		
		Case EventType.KeyDown
		
			Select E.Key
			
			Case Key.Escape
				
				App.Terminate()
				
			Case Key.Enter
				
				'N.SendDataAll("Server says hai too all")

			End
			
		End
		
	End

End Class

Function Main()

	New AppInstance
	New MyWindow
	App.Run()
	
End