Namespace insectoids

#Import "<std>"
#Import "<mojo>"

#Import "graphics/"
#Import "sounds/"


Using std..
Using mojo..

Const stretchy:int=True

Global winw:int=512,winh:int=480

Global width:int=640
Global height:int=480
Global num_rots:Int=64

global alien_rots:= New Image[num_rots]
Global playerList:List<Player>
Global bulletList:List<Bullet>
Global alienList:List<Alien>
Global bombList:List<Bomb>
Global explosionList:List<Explosion>

Global game_state:int,game_timer:int,level_name:string,alien_speed:int
Global num_aliens:int,num_flying:int,fly_timer:Int,num_bulls:int,num_players:int
Global c_x:float,c_y:float,c_xs:float,c_ys:float,c_dir:float,c_phase:float,rev_dir:int,c_speed:float,c_xsize:float,c_ysize:float
Global player_image:Image,stars_image:Image,bomb_image:Image,bull_image:Image,stars_scroll:Int,boom_anim:Image[]
Global mini_ship:Image,insectoids_image:Image,tmp_image:Image
Global ufo:Image

Global boom_sound:Sound
Global cool_sound:Sound
Global kazap_sound:Sound
Global shoot_sound:Sound
Global index:Int = 0
Global fontHeight:Int = 12

Class MyWindow Extends Window
	Field gameActive:Bool = False
	Field timer:Timer
	Method New( title:String="Simple mojo app",width:Int=640,height:Int=480,flags:WindowFlags=Null )

		Super.New( title,width,height,flags )
'		Local tmp_image:Image=New Image( width,fontHeight )
		'SetBuffer(ImageBuffer(tmp_image))
		'SetFont(font)
		'SetBuffer(CanvasBuffer(canvas))
		playerList = New List<Player>
		bulletList = New List<Bullet>
		alienList = New List<Alien>
		bombList = New List<Bomb>
		explosionList = New List<Explosion>
		boom_sound=Sound.Load( "asset::boom.ogg" )
		If boom_sound = Null
			Print "unable to load boom_sound"
			App.Terminate()
		Endif
		cool_sound=Sound.Load( "asset::cool.ogg" )
		kazap_sound=Sound.Load( "asset::kazap.ogg" )
		shoot_sound=Sound.Load( "asset::shoot.ogg" )
		fontHeight = 12
		LoadGraphics()
		game_state=0
		game_timer=0
		
		local fps:int=60
		
		'timer=New Timer(60,OnUpdate)
	End

	Method OnUpdate()
		Local x:int 
		x = (x+1)Mod 640
	end
 
	Method OnRender( canvas:Canvas ) Override
	
		App.RequestRender()
		Select True
		Case Keyboard.KeyHit(Key.Key8)	'window size
			Print "window size"
		Case Keyboard.KeyHit(Key.Key9)	'window close
			App.Terminate()
		Case Keyboard.KeyHit(Key.Key1)'menu action!
			BeginGame()
			gameActive = true
		Case Keyboard.KeyHit(Key.Key3)
			EndGame()
			gameActive = false
		Case Keyboard.KeyHit(Key.Key5)
				If Confirm( "Really Quit?","true" ) Print ""
		Case Keyboard.KeyHit(Key.Key7)
			Notify("Insectoids! (in a window...)","True")
		Case Keyboard.KeyHit(Key.Tab)	'suspend!
		End Select
		If gameActive
			canvas.Color = New Color(0,0,0)
			canvas.Clear(New Color(0,00))
			UpdateGame()
			canvas.Color=New Color(1,1,1)
			RenderGame(canvas)
		Endif
		canvas.DrawText( "Hello World!",Width/2,Height/2,.5,.5 )
	End
	
End

Function Main()

	New AppInstance
	
	New MyWindow
	
	App.Run()
End



Class Alien
	Field x:float,y:float,rot:int,state:int
	Field f_x:float,f_y:Float
	Field dest_y:float,dest_rot:int,rot_step:int,bomb_cnt:Int
End Class

Class Player
	Field x:int,y:int,state:int,lives:int,bang:int,score:int
End Class

Class Bomb
	Field x:Float,y:Float,xs:Float,ys:Float
End Class

Class Bullet
	Field x:int,y:Int
End Class

Class Explosion
	Field x:int,y:int,frame:Int
End Class

'font=LoadFont( "arial",24,True )
'SetFont font


Function CreatePlayer()
	Local p:Player=New Player
	playerList.AddLast(p)
	p.lives=3
	ResetPlayer( p )
	num_players=num_players+1
End Function

Function ResetPlayer( p:Player )
	p.x=width/2
	p.y=height-20
	p.state=1
End Function

Function UpdatePlayer( p:Player )

	If p.state<>1 Then Return

	If Keyboard.KeyDown(Key.Left)
		If p.x>16 Then p.x=p.x-6
	Else If Keyboard.KeyDown(Key.Right)
		If p.x<width-16 Then p.x=p.x+6
	EndIf
	
	If game_state<>2 Then Return
	
	If Keyboard.KeyHit(Key.Z) And num_bulls<3
		shoot_sound.Play()
		Local b:Bullet=New Bullet
		bulletList.AddLast(b)
		b.x=p.x
		b.y=p.y-16
		num_bulls=num_bulls+1
	EndIf

	Local dead:Bool=False	
	For Local a:Alien=EachIn alienList
		If ImagesOverlap( player_image,p.x,p.y,alien_rots[a.rot*num_rots/360 ],a.x,a.y )
			dead=True
			Exit
		EndIf
	Next
	For Local bb:Bomb=EachIn bombList
		If ImagesOverlap( player_image,p.x,p.y,bomb_image,bb.x,bb.y )
			dead=True
			Exit
		EndIf
	Next
	
	If Not dead Then Return
	
	boom_sound.Play()
	
	For Local k:int=-105 To 0 Step 15
		CreateExplosion( p.x+Rnd(-10,10),p.y+Rnd(-10,10),k )
	Next
	
	p.bang=1
	p.state=2
	p.lives=p.lives-1
	game_state=3
	
End Function

Function RenderPlayer( canvas:Canvas,p:Player )

	canvas.Color = New Color(1,1,1)'255,255,255
	canvas.DrawText(width/2,4,p.score,1)

	For Local k:int=1 To p.lives
		canvas.DrawImage(mini_ship,k*12+4,14)
	Next
	
	If p.state=1
		canvas.DrawImage(player_image,p.x,p.y)
		Return
	EndIf
	
	p.bang=p.bang+8
	
	Local r:float=p.bang
	For Local i:int=255 To 1 Step -15
		canvas.Color = New Color(i/255.0,i/255.0,i/255.0)
		For Local an:int=0 To 359 Step 6
			Local x:int=p.x+Cos(an*Pi/180)*r
			Local y:int=p.y+Sin(an*Pi/180)*r
			canvas.DrawRect(x,y,3,3)
		Next
		r=r-6
		If r<=0 Then Exit
	Next
	
End Function

Function AddPoints( p:Player,pnts:int )
	Local t:int=p.score/5000
	p.score=p.score+pnts
	If p.score/5000<>t Then p.lives=p.lives+1
End Function

Function UpdateBullet( b:Bullet )
	b.y=b.y-8
		
	For Local a:Alien=EachIn alienList
		Local pnts:Int
		If ImagesOverlap( bull_image,b.x,b.y,alien_rots[ a.rot*num_rots/360 ],a.x,a.y )
			kazap_sound.Play() '.Sound()
			If a.state=1
				pnts=25
			Else If a.state=2
				pnts=50
			Else
				pnts=100
			EndIf
			AddPoints( playerList.First,pnts) 'First Player,pnts )
			CreateExplosion( a.x,a.y )
			bulletList.Remove(b)
			num_bulls=num_bulls-1
			If a.state<>1 num_flying=num_flying-1
			num_aliens=num_aliens-1
			alienList.Remove(a)
			Return
		EndIf
	Next
	
	If b.y>0 Then Return
	bulletList.Remove(b)
	num_bulls=num_bulls-1
	
End Function

Function RenderBullet( canvas:Canvas,b:Bullet )
	canvas.DrawImage(bull_image,b.x,b.y)
End Function

Function UpdateBomb( b:Bomb )
	b.x=b.x+b.xs
	b.y=b.y+b.ys
	If b.y>height Then bombList.Remove(b)
End Function

Function RenderBomb(canvas:Canvas, b:Bomb )
	canvas.DrawImage(bomb_image,b.x,b.y)
End Function

Function UpdateAlien( a:Alien )

	Select a.state
	Case 1
		If a.rot<>0
			If a.rot>180 a.rot=a.rot+6 Else a.rot=a.rot-6
			If a.rot<0 Or a.rot>=360 Then a.rot=0
		EndIf
		Local dx:int=c_x+a.f_x*c_xs - a.x
		local dy:int=c_y+a.f_y*c_ys - a.y
		If dx<-alien_speed Then dx=-alien_speed Else If dx>alien_speed Then dx=alien_speed
		If dy<-alien_speed Then dy=-alien_speed Else If dy>alien_speed Then dy=alien_speed
		a.x=a.x+dx
		a.y=a.y+dy
		If c_dir<0 And a.x<16 Then rev_dir=True
		If c_dir>0 And a.x>width-16 Then rev_dir=True
	Case 2
		a.rot=a.rot+a.rot_step
		If a.rot<0 Then a.rot=a.rot+360 Else If a.rot>=360 Then a.rot=a.rot-360
		If a.rot<90 Or a.rot>270
			a.dest_rot=Rnd(180-40,180+40)
			a.dest_y=a.dest_y+Rnd( 100,300 )
			a.state=3
		EndIf
		a.x=a.x+Cos( (a.rot-90)*Pi/180.0 )*alien_speed
		a.y=a.y+Sin( (a.rot-90)*Pi/180.0 )*alien_speed
		DropBomb( a )
	Case 3		
		Local dr:int=a.rot-a.dest_rot
		If Abs(dr)>Abs(a.rot_step)
			a.rot=a.rot+a.rot_step
			If a.rot<0 Then a.rot=a.rot+360 Else If a.rot>=360 Then a.rot=a.rot-360
		EndIf
		a.x=a.x+Cos( (a.rot-90)*Pi/180.0 )*alien_speed
		a.y=a.y+Sin( (a.rot-90)*Pi/180.0 )*alien_speed
		If a.y>height
			a.x=Rnd(width/2)+width/4
			a.y=0
			num_flying=num_flying-1
			a.state=1
		Else If a.y>a.dest_y
			a.rot_step=-a.rot_step
			a.state=2
		EndIf
		DropBomb( a )
	End Select
End Function

Function RenderAlien( canvas:Canvas,a:Alien )
	canvas.DrawImage(alien_rots[ a.rot*num_rots/360 ],a.x,a.y)
End Function

Function UpdateExplosion( e:Explosion )
	e.frame=e.frame+1
	If e.frame=18 Then explosionList.Remove(e)
End Function

Function RenderExplosion( canvas:Canvas,e:Explosion )
	If e.frame<0 Then Return
	canvas.DrawImage(boom_anim[e.frame/3],e.x,e.y)
End Function

Function CreateExplosion( x:int,y:int,frame:int=0 )
	Local e:Explosion=New Explosion
	explosionList.AddLast(e)
	e.x=x
	e.y=y
	e.frame=frame
End Function

Function DropBomb( a:Alien )
	If a.bomb_cnt=0 Then a.bomb_cnt=Rnd(50,100)
	a.bomb_cnt=a.bomb_cnt-1
	If a.bomb_cnt>0 Then Return
	Local p:Player=playerList.First
	If p=Null Then Return
	Local b:Bomb=New Bomb
	bombList.AddLast(b)
	b.x=a.x
	b.y=a.y
	If a.x<p.x Then b.xs=1 Else b.xs=-1
	b.ys=6
End Function

Function UpdateFormation()

	c_phase=(c_phase+c_speed)Mod 360
	Local t:float=Sin( c_phase *Pi/180.0)*.5+.5
	c_xs=t*c_xsize+2
	c_ys=t*c_ysize+2
	
	If game_state<>1 Then c_x=c_x+c_dir
	
End Function

Function UpdateFlyTimer()

	If num_aliens>3
		If fly_timer=0 Then fly_timer=600
		fly_timer=fly_timer-1
		If fly_timer>120 Then Return
		If fly_timer Mod 30<>0 Then Return
	EndIf
	
	Local n:int=Rnd( num_aliens-num_flying )
	
	For Local a:Alien=EachIn alienList
		If a.state=1
			If n=0
				a.dest_y=a.y
				a.rot_step=3
				If Rnd(1)<.5 Then a.rot_step=-3
				num_flying=num_flying+1
				a.state=2
				Return
			EndIf
			n=n-1
		EndIf
	Next
End Function

Function UpdateGame()

	Select game_state
	Case 0
		game_timer=game_timer+1
	Case 1
		game_timer=game_timer+1
		If game_timer=150 Then game_state=2
		UpdateFormation()
	Case 2
		UpdateFlyTimer()
		UpdateFormation()
		If num_aliens=0 Then BeginLevel()
	Case 3
		UpdateFormation()
		If num_flying=0 And explosionList.Empty
			Local p:Player=playerList.First
			If p.lives>0
				ResetPlayer( p )
				game_state=2
			Else
				game_state=4
				game_timer=0
			EndIf
		EndIf
	Case 4
		UpdateFlyTimer()
		UpdateFormation()
		game_timer=game_timer+1
		If game_timer=150 Then EndGame()
	End Select
	
	rev_dir=False
	For Local a:Alien=EachIn alienList
		UpdateAlien( a )
	Next
	If rev_dir Then c_dir=-c_dir
	
	For Local bb:Bomb=EachIn bombList
		UpdateBomb( bb )
	Next
	
	For Local p:Player=EachIn playerList
		UpdatePlayer( p )
	Next
	
	For Local b:Bullet=EachIn bulletList
		UpdateBullet( b )
	Next
	
	For Local e:Explosion=EachIn explosionList
		UpdateExplosion( e )
	Next
End Function

Function RenderGame(canvas:Canvas)

	TileImage(canvas,stars_image,0,stars_scroll)
	TileImage(canvas,stars_image,7,stars_scroll*2)
	TileImage(canvas,stars_image,23,stars_scroll*3)
	stars_scroll=(stars_scroll+1) Mod stars_image.Width
	
	For Local a:Alien=EachIn alienList
		RenderAlien( canvas,a )
	Next
	
	For Local bb:Bomb=EachIn bombList
		RenderBomb(canvas, bb )
	Next
	
	For Local p:Player=EachIn playerList
		RenderPlayer(canvas, p )
	Next
	
	For Local b:Bullet=EachIn bulletList
		RenderBullet( canvas,b )
	Next
	
	For Local e:Explosion=EachIn explosionList
		RenderExplosion( canvas,e )
	Next
	
	Select game_state
	Case 0
		canvas.DrawImage(insectoids_image,width/2,height/3)
		If game_timer<150 Or (game_timer-150) Mod 80<40
			canvas.Color = New Color(1,1,1) ' 255,255,255
			'TitleText( canvas,"USE GAME MENU TO START",width/2,height-FontHeight()*2,game_timer )
		EndIf
	Case 1
		'Rainbow( game_timer*5 )
		TitleText( canvas,level_name,width/2,height/2,game_timer*2 )
	Case 4
		canvas.Color = New Color(1,1,1) '255,255,255
		Text(canvas,width/2,height/2,"GAME OVER",1,1)
	End Select
	
End Function

Function TitleText( canvas:Canvas,txt:string,x:int,y:int,time:int )
	Local n:int=0
	If time<100 Then n=100-time
	If n<=1
		Text (canvas,x,y,txt,1,1)
	Else
		ExplodeText(canvas, x,y,txt,n*.5+1,n+1 )
	EndIf
End Function

Function LoadGraphics()

	'AutoMidHandle(True)
	
	stars_image=Image.Load( "asset::stars.png" )
	If stars_image = Null Print "unable to load stars.png"
	stars_image.Handle = New Vec2f(.5,.5)
	player_image=Image.Load( "asset::player.png" )';ScaleImage(player_image,1,1)
	player_image.Handle = New Vec2f(.5,.5)

	mini_ship=player_image 'CopyImage( player_image )';ScaleImage(mini_ship,.4,.4)
	mini_ship.Handle= New Vec2f(.5,.5)
	bull_image=Image.Load( "asset::bullet.png" ) 'ScaleImage(bull_image,.5,1)
	bull_image.Handle= New Vec2f(.5,.5)
	bomb_image=Image.Load( "asset::bbomb.png" ) 'ScaleImage(bomb_image,.6,.6)
	bomb_image.Handle= New Vec2f(.5,.5)
	boom_anim=LoadFrames( "asset::kaboom.png",60,48,0,6 )
	insectoids_image=Image.Load( "asset::insectoids_logo.png" )
	insectoids_image=ResizeImage(insectoids_image,400,128)
	Print insectoids_image.Width + "   " +insectoids_image.Height
	For Local i:Int = 0 Until boom_anim.Length
		boom_anim[i]= ResizeImage(boom_anim[i],32,32)';ResizeImage(boom_anim,32,32)
	Next
	Local i:Image=Image.Load( "asset::alien.png" )
	i.Handle = New Vec2f(.5,.5)
	If i = Null Print "unable to load alien.png"
	i = ScaleImage(i,.6,.6)
	ufo = i
	For Local k:int=0 To num_rots-1
		alien_rots[k]=CopyImage( i )
		alien_rots[k].Handle = New Vec2f(.5,.5)
		alien_rots[k] = RotateImage(alien_rots[k],k*(360/num_rots)*Pi/180)
	Next
End Function

Function BeginLevel()

	cool_sound.Play()
	

	'Read(level_name)
	
	If index > 5  'level_name=""
		index = 0 'Restore .levels
		level_name = "Level "+index 'Read(level_name)
		alien_speed=alien_speed+1
		If alien_speed>6 Then alien_speed=6
	EndIf
	c_x=width/2
	c_y=height/4
	c_phase=0
	c_dir=1
	Local cnt:int
	For Local j:Int = 0 Until levels[index].Length
		Local x:Int = levels[index][j][0]
		Local y:Int = levels[index][j][1]
		Local cnt:Int = levels[index][j][2]
		For Local k:int=1 To cnt
			Local a:Alien=New Alien
			alienList.AddLast(a)
			a.x=c_x
			a.y=c_y
			a.rot=0
			a.state=1
			a.f_x=x*16
			a.f_y=y*12
			x=x+1
		Next
		num_aliens=num_aliens+cnt
	Next

	game_state=1
	game_timer=0
	
End Function

Function BeginGame()

'	HidePointer(canvas)
'	DisableMenu(game_new)
'	EnableMenu(game_end)
'	UpdateWindowMenu(window)
	
	local level:int=0
	num_bulls=0
	num_aliens=0
	num_flying=0
	game_state=0
	num_players=0
	alien_speed=6
	
	CreatePlayer()
	
'	Restore .levels
	
	BeginLevel()
	
End Function

Function EndGame()

	playerList.Clear()
	bulletList.Clear()
	alienList.Clear()
	bombList.Clear()

	game_state=0
	game_timer=0
	
'	DisableMenu(game_end)
'	EnableMenu(game_new)
'	UpdateWindowMenu(window)
'	ShowPointer(canvas)
	
End Function

Function Rainbow(canvas:Canvas,time:int )
	Local r:int=time Mod 768
	If r>255 Then r=511-r
	Local g:int=(time+256)Mod 768
	If g>255 Then g=511-g
	Local b:int=(time+512) Mod 768
	If b>255 Then b=511-b
	If r<0 Then r=0
	If g<0 Then g=0
	If b<0 Then b=0
	canvas.Color = New Color(r/255.0,g/255.0,b/255.0)
End Function

Function ExplodeText(canvas:Canvas, x:int,y:int,txt:string,xn:Float,yn:float )
	canvas.Clear(New Color(0,0,0))
	canvas.DrawText(txt,0,0)
	Local w:int=100
	Local h:int= 12
		
	For Local ty:int=0 To h-1 Step 3
		For Local tx:Int=0 To w-1 Step 3
			Local xo:float=(tx-w/2)*xn
			Local yo:float=(ty-h/2)*yn
			'canvas.DrawRect(x+xo,y+yo,3,3,tmp_image,tx,ty)
		Next
	Next
	
End Function


Function LoadFrames:Image[] (path:String, cellWidth:Int, cellHeight:Int, first:Int, count:int)
	Local image:Image = Image.Load(path)
	If Not image
		Print("Error: Cant load image: "+path)
		App.Terminate()
	End
	Print image.Width +"  "+image.Height
	If cellWidth * cellHeight * count > image.Width * image.Height 
		Print ("Error Loading "+path)
		App.Terminate()
	endif	
	Local frames:= New Image[count]
	
	Local x:= first*cellWidth, y:= 0
	For Local i:=0 Until count
		frames[i] = New Image(image,x,y,cellWidth,cellHeight)
		'frames[i].Handle = New Vec2f(.5,.5)
		x+=cellWidth
	Next
	
	Return frames
End


Function CopyImage:Image(img:Image)
	Local tempImg:Image = New Image(img.Width,img.Height)
	Local canvas:Canvas = New Canvas(tempImg)
	canvas.Clear(New Color(0,0,0,0))
	canvas.DrawImage(img,img.Width*img.Handle.X,img.Height*img.Handle.Y)
	canvas.Flush()
	Return tempImg
End function

Function ScaleImage:Image(img:Image,xs:Float,ys:float)
	Local tmpImage:Image = New Image(img.Width*xs,img.Height*ys)
	Local canvas:Canvas = New Canvas(tmpImage)
	canvas.Clear(New Color(0,0,0,0))
	canvas.Scale(xs,ys)
	canvas.DrawImage(img,img.Width/2,img.Height/2)
	canvas.Flush()
	Return tmpImage	
End Function

Function RotateImage:Image(img:Image,ang:float)
	Local d:Float = Sqrt(img.Width*img.Width+img.Height*img.Height)
	Local image:Image = New Image(d,d)
	Local canvas:Canvas = New Canvas(image)
	canvas.Clear(New Color(0,0,0,0))
	canvas.DrawImage(img,d/2,d/2,ang)
	canvas.Flush()
	image.Handle = New Vec2f(.5,.5)
	Return image	
End Function 

Function Text(canvas:Canvas,x:float,y:Float,str:String,hx:float=1,hy:float=1)
	canvas.DrawText(str,hx,hy)
End function

Function TileImage( canvas:Canvas,image:Image,x:float=0,y:float=0)
	Local ax:Float = (x-image.Width)
	Local ay:Float = (y-image.Height)
	While ay < winh+image.Height
		Local nx:Float = ax
		While nx < winw+image.Width
			canvas.DrawImage(image,nx,ay)
			nx += image.Width
		Wend
		ay += image.Width
	Wend
End Function

Function ResizeImage:Image(img:Image,w:Int,h:int)
	Local sx:Float = w/img.Width
	Local sy:Float = h/img.Height
	Local image:Image = New Image(w,h)
	Local canvas:Canvas = New Canvas(image)
	canvas.Clear(New Color(0,0,0,0))
	canvas.DrawImage(img,0,0,0,sx,sy)
	canvas.Flush()
	Return image
End Function

Function ImagesOverlap:Int (image1:Image,x1:Float,y1:Float,image2:Image,x2:Float,y2:Float)
	Local b1x1:Float = x1 - image1.Handle.X
	Local b1y1:Float = y1 - image1.Handle.Y
	Local b1x2:Float = b1x1 + image1.Width
	Local b1y2:Float = b1y1 + image1.Height
	Local b2x1:Float = x2 - image2.Handle.X
	Local b2y1:Float = y2 - image2.Handle.Y
	Local b2x2:Float = b2x1 + image2.Width
	Local b2y2:Float = b2y1 + image2.Height
	If b1x1 > b2x2 Return False
	If b1x2 < b2x1 Return False
	If b1y1 > b2y2 Return False
	If b1y2 < b2y1 Return False 	
	Return True
End Function


Global levels:Float[][][] = New Float[][][](New Float[][](New Float[](1,.25,0),New Float[](-2,-2,5),New Float[](-3,-1,7),New Float[](-3,0,7),New Float[](-3,1,7),New float[](-3,2,7)),
											New Float[][](New Float[](1,.25,.25),New Float[](0,-2,1),New Float[](-1,-1,3),New Float[](-2,0,5),New Float[](-3,1,7),New Float[](-4,2,9),New Float[](-5,3,11)),
											New Float[][](New Float[](3,.25,.5),New Float[](-5,-2,11),New Float[](-4,-1,9),New Float[](-3,0,7),New Float[](-4,1,9),New Float[](-5,2,11)),
											New Float[][](New Float[](2,0,1),New Float[](-5,-1,11),New Float[](-5,0,11),New FLoat[](-5,1,11),New Float[](-5,2,11),New FLoat[](-5,3,11),New Float[](-5,4,11),New Float[](-5,5,11)),
											New Float[][](New Float[](1,.25,.125),New Float[](-3,-2,7),New Float[](-4,-1,9),New Float[](-5,0,11),New Float[](-5,1,11),New Float[](-5,2,11),New Float[](-5,3,11),New Float[](-5,4,11),New Float[](-5,5,11),New Float[](-5,6,11),New Float[](-5,7,11)),
											New Float[][](New Float[](1,.25,.125),New Float[](-7,-2,15),New Float[](-7,-1,15),New Float[](-7,0,15),New FLoat[](-7,1,15),New FLoat[](-7,2,15),New Float[](-7,3,15),New Float[](-7,4,15),New FLoat[](-7,5,15),New FLoat[](-7,6,15),New FLoat[](-7,7,15),New FLoat[](-7,8,15),New FLoat[](-7,9,15),New FLoat[](-7,10,15),New FLoat[](-7,11,15)))

