Namespace Myapp
#Import "<std>"
#Import "<mojo>"
#Import "<mojo3d>"
#Import "assets/"
Using std..
Using mojo..
Const VWIDTH:=1920, VHEIGHT:=1080

Class Myapp Extends Window
Field img : Image
Field pix : Pixmap
Field scale : Vec2f
Field elapsed : Int = 1
Field Myapp : Stack<sprite>[] = New Stack<sprite>[4]
Field images : Image[] = New Image[](
Image.Load("asset::32x32sheet.png"),Image.Load("asset::32x32sheet.png"),Image.Load("asset::32x32sheet.png"),Image.Load("asset::32x32sheet.png") )
Field lastMilli := Millisecs()
Field image : Image
Field icanvas : Canvas

Method New()
	Super.New("Myapp", VWIDTH, VHEIGHT, WindowFlags.Resizable )
		ClearColor = Color.Black
		image=New Image(512,512,PixelFormat.RGBA8,TextureFlags.Dynamic)
		image.Texture.Flags &=~ TextureFlags.FilterMipmap
		image.Handle=New Vec2f(0.5,0.5)
	icanvas=New Canvas(image)
	Local tmpimage:=Floor( random.Rnd( 3 ))
	For Local i:=0 Until Myapp.Length
	Myapp[i] = New Stack<sprite>
	End
End
 
Method OnRender( canvas:Canvas ) Override
App.RequestRender()
	icanvas.Clear(Color.Black)
	canvas.Alpha=1.0
		icanvas.Alpha=1.0
		For Local x:=0 Until 512/16
			For Local y:=0 Until 512/16
				If (x~y)&1
					icanvas.Color=Color.Black
				Else
					icanvas.Color=Color.Yellow
				Endif
				icanvas.DrawRect( Int(x)*16,Int(y)*16,16,16 )
			Next
		Next

Global currentx : Int 
currentx = (currentx+2) Mod 512
For Local temp:=0 To 511
icanvas.DrawRect(64+temp,0, 1, 64, image, 0+temp+currentx,0,1,64)
Next
		icanvas.Color=Color.White
		icanvas.DrawText( "This way up!",icanvas.Viewport.Width/2,0,.5,0)
If Keyboard.KeyReleased(Key.Escape) Then App.Terminate()

Local count:Int
icanvas.Alpha = 1
canvas.Alpha = 1
For Local s:=Eachin Myapp
For Local sprite:=Eachin s
canvas.Alpha = 1 
sprite.Update(); sprite.Draw(canvas);count+=1
canvas.Alpha = 1
sprite.Update(); sprite.Draw(icanvas);count+=1
Next
Next

icanvas.Flush()
Global rot:=0.0
canvas.Alpha = 1.0
canvas.DrawImage( image,App.MouseLocation.x,App.MouseLocation.y, Pi/4.0)
icanvas.Alpha = 1
canvas.Color = Color.White ;canvas.DrawRect( 0, 0, VWIDTH, 25 )
canvas.Color = Color.Black
canvas.DrawText("Counting ("+ count +")",0,0);canvas.DrawText(" FPS: " + App.FPS, 300, 0 )
End Method

Method OnMouseEvent( event:MouseEvent ) Override
If event.Type = EventType.MouseDown
Local _len := 0
If event.Button = MouseButton.Left Then _len = 1

Local tmpimage:Int
For Local i:=1 Until _len + 1
tmpimage = Floor( random.Rnd( 3 ))
Myapp[ tmpimage ].Add( New sprite( Mouse.X, Mouse.Y, images[ tmpimage ] ) )
End

End
End Method
 
End
 
Class sprite
Field x: Float, y: Float, xspeed: Float, yspeed: Float, texture: Image
Global gravity := 0.2
 
Method New( x: Float, y: Float, texture:Image )
Self.x = x ; Self.y = y ; Self.texture = texture ; xspeed = random.Rnd(7)
End
 
Method Update:Void( )
'yspeed += gravity ; y += yspeed ; x += xspeed
'If y >= VHEIGHT Then y = VHEIGHT ; yspeed = -random.Rnd( 25 )
'If x < 0 Or x > VWIDTH Then xspeed *= -1 ; x = Clamp(x, 0.0, Float(VWIDTH) )
End

Method Draw(canvas:Canvas)
		canvas.BlendMode = BlendMode.Alpha ' Opque Alpha Multiply Additive
		
		Local w:Int = 64
		Local h:Int = 64
		Local rx:Int  = -(w * 0.5)
		Local ry:Int = -(h * 0.5)
		
		canvas.PushMatrix()
		canvas.Translate(x,y)

' ROTATION (check if possible to create pixelperfect rotation using matrix)
		'canvas.Rotate(Pi/2.0)     ' 90°          (1*Pi   / 2)
		'canvas.Rotate(Pi/1.0)     ' 180°         (2*Pi   / 2)
		'canvas.Rotate((Pi*2)/2.0) ' 270°         (3*Pi   / 2)
		'canvas.Rotate(Pi*2.0)     ' 0° = 360°    (4*Pi   / 2)
		
		canvas.Rotate(Pi/4.0)      ' 45°		  (1*Pi   / 4)
		'canvas.Rotate((Pi*3)/4.0) ' 135°		  (3*Pi   / 4)
		'canvas.Rotate((Pi*5)/4.0) ' 225°		  (5*Pi   / 4)
		'canvas.Rotate((Pi*7)/4.0) ' 315°		  (7*Pi   / 4)

' FLIPPMIRROR
'		canvas.DrawRect(rx+w,ry+h,-w,-h,texture,0*32,1*32,w,h)  ' Flippedmirrored (X & Y)
'		canvas.DrawRect(rx,ry+h,w,-h,texture,0*32,1*32,w,h) 	' Flippedmirrored (only x)
'		canvas.DrawRect(rx+w,ry,-w,h,texture,0*32,1*32,w,h) 	' Flippedmirrored (only y)
		canvas.DrawRect(rx,ry,w,h,texture,0*32,1*32,w,h) 		' Normal (no mirror)
		
	canvas.PopMatrix()
End
End
 
Function Main()
	New AppInstance
	New Myapp
	App.Run()
End Function