Namespace bunnies
#Import "assets/32x32sheet.png"
#Import "<std>"
#Import "<mojo>"
Using std..
Using mojo..
Const VWIDTH:=1920, VHEIGHT:=1080

Class Bunnymark Extends Window
Field frames: Int = 1
Field elapsed: Int = 1
Field bunnies:Stack<Bunny>[] = New Stack<Bunny>[4]

Field images:Image[] = New Image[](
Image.Load("asset::32x32sheet.png"),Image.Load("asset::32x32sheet.png"),Image.Load("asset::32x32sheet.png"),Image.Load("asset::32x32sheet.png") )
Field lastMilli := Millisecs()
Field image:Image
Field icanvas:Canvas

Method New()
Super.New("Bunnymark", VWIDTH, VHEIGHT, WindowFlags.Resizable )

image=New Image(512,512,PixelFormat.RGBA8,TextureFlags.Dynamic)
image.Texture.Flags &=~ TextureFlags.FilterMipmap
image.Handle=New Vec2f(0.5,0.5)
icanvas=New Canvas(image)

Local tmpimage:=Floor( random.Rnd( 3 ))
For Local i:=0 Until bunnies.Length
bunnies[i] = New Stack<Bunny>
End
End
 
Method OnRender( canvas:Canvas ) Override
App.RequestRender()

		For Local x:=0 Until 16
			For Local y:=0 Until 16
				If (x~y)&1
					icanvas.Color=New Color( Sin( Millisecs()*.01 )*.5+.5,Cos( Millisecs()*.02 )*.5+.5,.5 )
				Else
					icanvas.Color=Color.Yellow
				Endif
				icanvas.DrawRect( Int(x)*16,Int(y)*16,16,16 )
			Next
		Next
		
		icanvas.Color=Color.White
		icanvas.DrawText( "This way up!",icanvas.Viewport.Width/2,0,.5,0 )
		icanvas.Flush()

Global currentx : Int 
currentx = (currentx+2) Mod 512
For Local temp:=0 To 511
icanvas.DrawRect(64+temp,0, 1, 64, image, 0+temp+currentx,0,1,64)
Next

If Keyboard.KeyReleased(Key.Escape) Then App.Terminate()
Local bunnycount:Int
For Local s:=Eachin bunnies
For Local bunny:=Eachin s
bunny.Update(); bunny.Draw(canvas);bunnycount+=1

Next
Next

Global rot:=0.0

canvas.DrawImage( image,App.MouseLocation.x,App.MouseLocation.y,rot )
canvas.DrawImage (image,100,100)
canvas.Alpha = 1.0
canvas.Color = Color.White ;canvas.DrawRect( 0, 0, VWIDTH, 25 )
canvas.Color = Color.Black
canvas.DrawText("The Bunnymark ( " + bunnycount + " )",0,0);canvas.DrawText(" FPS: " + App.FPS, 300, 0 )
End Method

Method OnMouseEvent( event:MouseEvent ) Override
If event.Type = EventType.MouseDown
Local _len := 0
If event.Button = MouseButton.Left Then _len = 225

Local tmpimage:Int
For Local i:=1 Until _len + 1
tmpimage = Floor( random.Rnd( 3 ))
bunnies[ tmpimage ].Add( New Bunny( Mouse.X, Mouse.Y, images[ tmpimage ] ) )
End
End

End Method

End
 
Class Bunny
Field x: Float, y: Float, xspeed: Float, yspeed: Float, texture: Image
Global gravity := 0.5
 
Method New( x: Float, y: Float, texture:Image )
Self.x = x ; Self.y = y ; Self.texture = texture ; xspeed = random.Rnd(10)
End
 
Method Update:Void( )
yspeed += gravity ; y += yspeed ; x += xspeed
If y >= VHEIGHT Then y = VHEIGHT ; yspeed = -random.Rnd( 35 )
If x < 0 Or x > VWIDTH Then xspeed *= -1 ; x = Clamp(x, 0.0, Float(VWIDTH) )
End

Method Draw(canvas:Canvas)
canvas.Color = New Color(0.5,0.5,0.5)
canvas.Alpha = 0.1 
canvas.BlendMode = BlendMode.Alpha
canvas.DrawRect(Int(x),Int(y),-64,-64,texture,0*32,1*32,64,64)
End
End
 
Function Main()
New AppInstance
New Bunnymark
App.Run()
End Function