uniform sampler2D ColorTexture;
uniform float EffectLevel;
uniform float color_r;
uniform float color_g;
uniform float color_b;
uniform float color_a;

void shader(){
	// Convert clip position to valid tex coords
	vec2 texcoords = (b3d_ClipPosition.st/b3d_ClipPosition.w)*0.5+0.5;

	// Read source color
	vec4 color = texture2D(ColorTexture,texcoords).rgba;

	// Calculate magenta
	vec4 result = vec4(color_r,color_g,color_b,color_a)*color.a;

	// Mix based on effect level
	color = vec4(mix(color.rgba,result,EffectLevel)) ;

	// Write output
	b3d_FragColor = vec4(color);
}