Import mojo2
Class MyApp Extends App

	Field canvas:Canvas,icanvas:Canvas
	Field image:Image,sourceImage:Image,targetImage:Image
	Field shaderonplease:Int,size:Int=32,w:Int = 800,h:Int = 600
	Field effect:ShaderEffect,level:Float=1,cx:Int
	
	Method OnCreate()
		sourceImage=Image.Load("32x32sheet.png",0,0,0)
		targetImage=New Image(sourceImage.Width,sourceImage.Height,,,0)
		image=New Image(512,512,0,0,0) ; Image.SetFlagsMask(Image.Managed) ; effect=New ShaderEffect
		canvas=New Canvas ; icanvas=New Canvas(image)
	End

	Method OnUpdate()
		If KeyHit(KEY_SPACE) Then effect.SetColor(Rnd(1.0),Rnd(1.0),Rnd(1.0),1.0) ; shaderonplease = True
		If shaderonplease Then level = Sin(Millisecs*.5)*.5+.5 ' SHADER PARAMETER
	End

 	Method OnRender()	
		' Shader
		effect.SetLevel level ; effect.Render(sourceImage,targetImage)
		canvas.DrawImage(targetImage,100,100)
		
		' Init canvas & image
		canvas.SetViewport 0,0,w,h ; canvas.SetScissor 0,0,w,h
		canvas.SetProjection2d 0,w,0,h ; canvas.Clear 0,0,0
		icanvas.SetViewport 0,0,w,h ; icanvas.SetScissor 0,0,w,h
		icanvas.SetProjection2d 0,w,0,h ;	icanvas.Clear 0,0,0

		' Draw to image
		icanvas.DrawImage targetImage,256,256
		cx=(cx+2) Mod 512 ; For Local temp:=0 To 127 ; icanvas.DrawRect 064+temp,0,1,64,targetImage,0+temp+cx,0,1,64 ; Next
		icanvas.Flush

		' Draw to canvas
		canvas.DrawRect 0,0,256,256,image,0,0,256,256
		canvas.Flush
	End
End

Function Main()
	New MyApp 
End

Class BWShader Extends Shader
	Private
	Global _instance:BWShader
	
	Method New()
		Build(LoadString("monkey://data/shader.glsl"))
	End
	
	Method OnInitMaterial:Void(material:Material)
		material.SetTexture "ColorTexture",Texture.White() ; material.SetScalar "EffectLevel",1
		material.SetScalar "color_r",1 ; material.SetScalar "color_g",1 ; material.SetScalar "color_b",1 ; material.SetScalar "color_a",1
	End
	
	Function Instance:BWShader()
		If Not _instance _instance=New BWShader
		Return _instance
	End
End

Class ShaderEffect
	Private
	Global _canvas:Canvas
	Field _material:Material

	Method New()
		If Not _canvas _canvas=New Canvas
		_material=New Material(BWShader.Instance())
	End
	
	Method SetLevel:Void(level:Float)
		_material.SetScalar "EffectLevel",level
	End
	
	Method SetColor:Void(r:Float,g:Float,b:Float,a:Float=1.0)
		_material.SetScalar "color_r",r ; _material.SetScalar "color_g",g ; _material.SetScalar "color_b",b ;_material.SetScalar "color_a",a
	End
	
	Method Render:Void(source:Image,target:Image)
		_material.SetTexture "ColorTexture",source.Material.ColorTexture
		_canvas.Clear 0,0,0,0
		_canvas.SetRenderTarget target
		_canvas.SetViewport 0,0,target.Width,target.Height
		_canvas.SetProjection2d 0,target.Width,0,target.Height
		_canvas.DrawRect 0,0,target.Width,target.Height,_material
		_canvas.Flush
	End
End