
Namespace datapacker

#Import "<std>"
#Import "<mojo>"
#Import "Packer"

Using std..
Using mojo..

#Import "assets/"

Class MyWindow Extends Window

	Method New( title:String="Data Packer",width:Int=640,height:Int=480,flags:WindowFlags=Null )

		Super.New( title,width,height,flags )
		
		Init()
	End

	Method OnRender( canvas:Canvas ) Override
	
		App.RequestRender()
	
		If _img Then canvas.DrawImage( _img,Width/2,Height/2 )
	End
	
	Private
	
	Field _img:Image
	
	Method Init()
		
		' you should pack files in other place and use load/get
		' but we pack right here for test
		Local packer:=New Packer( AppDir()+"data.bin" )
		packer.Pack( New String[]( "asset::blue.png","asset::red.png" ) )
		
		' try to load image srom packed file
		_img=packer.GetImage( "asset::red.png" )
		If _img Then _img.Handle=New Vec2f( .5 )
	End
	
End

Function Main()

	New AppInstance
	
	New MyWindow
	
	App.Run()
End


