#GLFW_WINDOW_WIDTH = 1920 ' 1440
#GLFW_WINDOW_HEIGHT = 1080 ' 900
#GLFW_WINDOW_FULLSCREEN =True
Import mojo2
 
Class MyApp Extends App
	Field canvas:Canvas, icanvas:Canvas,scanvas:Canvas, sourcecanvas:Canvas
	Field image:Image, sourceImage:Image, targetImage:Image
	Field s:Int = 4, cx:Int, d, wx:Int, wy:Int
	Field tilemap:Int[512*512]
	Field size:Int=4*4
	' ---------------------------------------------------------------------------------------
	Method OnCreate()
		For Local y:=0 To 511
			For Local x:=0 To 511
				tilemap[x + y * 512] = Int(Rnd(127))
			Next
		Next
 
		' Create empty tiles
		sourceImage=New Image(512,512,0,0,0) ' THIS
		sourcecanvas =  New Canvas(sourceImage)
		sourcecanvas.Clear 0,0,0
			
		' or load tiles '
		' sourceImage=Image.Load("sheet.png",0,0,0)
	
		targetImage=New Image(sourceImage.Width,sourceImage.Height,0,0,0) ' THIS
		image=New Image(512,512,0,0,0) ' THIS
		Image.SetFlagsMask(Image.Managed) ' THIS
		icanvas=New Canvas(image)
		scanvas=New Canvas(targetImage)
		canvas=New Canvas
	End
 
	' ---------------------------------------------------------------------------------------
	
	Method OnUpdate()
		If KeyHit(KEY_ESCAPE) Then EndApp
		wx=wx+2
	End
	
 	Method OnRender()
	 	scanvas.Clear 0,0,0
		scanvas.DrawImage sourceImage,0,0 ' Instead of shader, it copies sourceImage without alteration to targetImage.
		scanvas.Flush()
 
		' Init canvas & image
		Local w=DeviceWidth
		Local h=DeviceHeight
		'canvas.SetViewport 0,0,w,h
		'canvas.SetScissor 0,0,w,h
		'canvas.SetProjection2d 0,w,0,h
		canvas.Clear 0,0,0
		'icanvas.SetViewport 0,0,w,h
		'icanvas.SetScissor 0,0,w,h
		'icanvas.SetProjection2d 0,w,0,h
 
 		' Draw to image
		' Scroll by drawing onto itself
		icanvas.Clear 0,0,0
		icanvas.DrawImage sourceImage,0,0
		icanvas.DrawImage targetImage,256,256
		cx=(cx+2) Mod 512
		For Local temp:=0 To 127
			icanvas.DrawRect 64+temp,0,1,64,targetImage,0+temp+cx,0,1,64
		Next
		
		' Plot something to show how to draw to image after shader have been applied.
		For Local temp:=1 To 16
			If Int(Rnd(1)) Then icanvas.SetColor 0,0,0 Else icanvas.SetColor 1,1,1
			Local xx:= Int(Rnd(7))
			Local yy:= Int(Rnd(7))
			icanvas.SetColor 0,1,0
			icanvas.DrawRect xx*4,yy*4,2*4,2*4
		Next
		icanvas.Flush
		
		' Draw to canvas.
		Local scrx:=wx Mod size
		Local scry:=wy Mod size
		Local mapx:=wx / size
		Local mapy:=wy / size	
		Local cnty:= -scry
		For Local y:=mapy To mapy+((h/size)+1)
			Local cntx:=-scrx
			For Local x:=mapx To mapx+((w/size)+1)
				Local char:= tilemap[x + y * 512] ; Local tilex:= char & 15 ; Local tiley:= char Shr 4
				canvas.DrawRect cntx,cnty,size,size,image,tilex Shl 5,tiley Shl 5,32,32
				cntx=cntx+size
			Next
			cnty=cnty+size
		Next
		canvas.Flush
	End
End
 
' ---------------------------------------------------------------------------------------
 
Function Main()
	New MyApp 
End