Namespace Myapp
#Import "<std>"
#Import "<mojo>"
#Import "<mojo3d>"
#Import "assets/"
Using std..
Using mojo..
Const w:=1920, h:=1080 ' w:=1440 h:= 900 ' how stretch or center fullscreen, also is it possible to shut off UI at edges

Class Myapp Extends Window 
	Field canvas:Canvas, icanvas:Canvas, scanvas:Canvas, sourcecanvas:Canvas
	Field image:Image, sourceImage:Image, targetImage:Image
	Field s:Int, cx:Int, wx:Int, wy:Int
	Field tilemap:Int[] = New Int[512*512]
	Field size:Int=8, wxx:Float
	' ---------------------------------------------------------------------------------------
	Method New( title:String="Myapp",width:Int=w,height:Int=h,flags:WindowFlags=WindowFlags.Resizable)
		Super.New("Myapp",w,h,flags)
		Fullscreen=True

		For Local y:=0 To 511
			For Local x:=0 To 511
				tilemap[x + y * 512] = Int(Rnd(127))
			Next
		Next
		
		' Create empty tiles
		sourceImage=New Image(128,128,PixelFormat.RGBA8,TextureFlags.Dynamic)
 
		sourcecanvas =  New Canvas(sourceImage)
		sourcecanvas.Clear(Color.Black)
		
		' or load tiles
		sourceImage=Image.Load("asset::128x1282.png") ' 0,0,0 in Mx ! PixelFormat.RGBA8,TextureFlags.Dynamic)
		
		' Getting an error "Attempt to invoke method on null instance"
		targetImage=New Image(sourceImage.Width,sourceImage.Height,PixelFormat.RGBA8,TextureFlags.Dynamic) ' ,,,0)
		image=New Image(128,128,PixelFormat.RGBA8,TextureFlags.Dynamic) ' image=New Image(512,512,0,0,0) & Image.SetFlagsMask(Image.Managed)
		icanvas=New Canvas(image)
		scanvas=New Canvas(targetImage)
		' canvas=New Canvas() not needed image.Texture.Flags &=~ TextureFlags.FilterMipmap
	End
' ---------------------------------------------------------------------------------------
	Method OnRender( canvas:Canvas ) Override
		App.RequestRender()
		' canvas.Alpha=1.0
		scanvas.Clear(Color.Black)
		scanvas.DrawImage(sourceImage,0,0)	' Instead of shader, it copies sourceImage without alteration to targetImage.
		scanvas.Flush()
 
		' Init canvas & image
		canvas.Clear(Color.Black) ' canvas.Viewport(0,0,w,h) ; canvas.Scissor(0,0,w,h) ; canvas.Projection2d(0,w,0,h)
		icanvas.Clear(Color.Black) ' icanvas.Viewport(0,0,w,h) ; icanvas.Scissor(0,0,w,h) ; icanvas.Projection2d(0,w,0,h)
 
		' Draw to image
			
		' Scroll by drawing onto itself
		icanvas.Clear(Color.Black)
		icanvas.DrawImage(sourceImage,0,0)
		icanvas.DrawImage(targetImage,128,128)
		cx=(cx+2) Mod 128
		For Local temp:=0 To 127
			icanvas.DrawRect(64+temp,0,1,64,targetImage,0+temp+cx,0,1,64)
		Next
		
		' Plot something to show how to draw to image after shader have been applied.
		For Local temp:=1 To 16
		'	If Int(Rnd(1)) Then icanvas.Color = Color.Black Else icanvas.Color = Color.White
		'	Local xx:= Int(Rnd(7))
		'	Local yy:= Int(Rnd(7))
			icanvas.Color = Color.White
		'	icanvas.DrawRect(xx*4,yy*4,2*4,2*4)
		Next
		icanvas.Flush()
	
		' Draw to canvas.
		Local scrx:=wx Mod size
		Local scry:=wy Mod size
		Local mapx:=wx / size
		Local mapy:=wy / size	
		Local cnty:= -scry
		For Local y:=mapy To mapy+((h/size)+1)
			Local cntx:=-scrx
			For Local x:=mapx To mapx+((w/size)+1)
				Local char:= tilemap[x + y * 128]
				Local tilex:= char & 7
				Local tiley:= char Shr 3
				canvas.DrawRect(cntx,cnty,size,size,image,tilex Shl 3,tiley Shl 3,8,8)
				cntx=cntx+size
			Next
			cnty=cnty+size
		Next
		canvas.Flush()
 
		' User input here as there is no OnUpdate() equivalent in Monkey2
		If Keyboard.KeyReleased(Key.Escape) Then App.Terminate()
		wxx=(wxx+0.02) ' Mod 360
		wy = 512 + Int(math.Sin(wxx)*512)
		wx = 512 + Int(math.Cos(wxx)*512)
		End Method
End
' ---------------------------------------------------------------------------------------
Function Main()
	New AppInstance
	New Myapp
	App.Run()
End Function